/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.disaggregation.processors;

import ec.benchmarking.simplets.TsMultiBenchmarking;
import ec.tss.disaggregation.documents.MultiBenchmarkingResults;
import ec.tss.disaggregation.documents.MultiCholetteSpecification;
import ec.tstoolkit.algorithm.AlgorithmDescriptor;
import ec.tstoolkit.algorithm.IProcSpecification;
import ec.tstoolkit.algorithm.IProcessing;
import ec.tstoolkit.algorithm.IProcessingFactory;
import ec.tstoolkit.algorithm.ProcessingContext;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.timeseries.regression.ITsVariable;
import ec.tstoolkit.timeseries.regression.TsVariables;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MultiCholetteProcessor
implements IProcessingFactory<MultiCholetteSpecification, TsVariables, MultiBenchmarkingResults> {
    public static final String FAMILY = "Benchmarking";
    public static final AlgorithmDescriptor DESCRIPTOR = new AlgorithmDescriptor("Benchmarking", "Multi-variate Cholette", null);
    public static final MultiCholetteProcessor instance = new MultiCholetteProcessor();

    protected MultiCholetteProcessor() {
    }

    public void dispose() {
    }

    public AlgorithmDescriptor getInformation() {
        return DESCRIPTOR;
    }

    public boolean canHandle(IProcSpecification spec) {
        return spec instanceof MultiCholetteSpecification;
    }

    public IProcessing<TsVariables, MultiBenchmarkingResults> generateProcessing(MultiCholetteSpecification spec, ProcessingContext context) {
        return new DefaultProcessing(spec);
    }

    public IProcessing<TsVariables, MultiBenchmarkingResults> generateProcessing(MultiCholetteSpecification spec) {
        return new DefaultProcessing(spec);
    }

    public Map<String, Class> getSpecificationDictionary(Class<MultiCholetteSpecification> specClass) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Map<String, Class> getOutputDictionary(boolean compact) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static class DefaultProcessing
    implements IProcessing<TsVariables, MultiBenchmarkingResults> {
        private final MultiCholetteSpecification spec;

        public DefaultProcessing(MultiCholetteSpecification spec) {
            this.spec = spec.clone();
        }

        private String var(int pos) {
            return "s" + (pos + 1);
        }

        public MultiBenchmarkingResults process(TsVariables input) {
            TsMultiBenchmarking bench = new TsMultiBenchmarking();
            bench.setRho(this.spec.getParameters().getRho());
            bench.setLambda(this.spec.getParameters().getLambda());
            TsFrequency[] freqs = input.frequencies();
            HashMap<TsFrequency, TsDomain> domains = new HashMap<TsFrequency, TsDomain>();
            for (int i = 0; i < freqs.length; ++i) {
                domains.put(freqs[i], input.common(freqs[i]));
            }
            for (ITsVariable var : input.variables()) {
                if (var.getDefinitionFrequency() == TsFrequency.Undefined || var.getDim() != 1) continue;
                TsDomain dom = (TsDomain)domains.get(var.getDefinitionFrequency());
                TsData data = new TsData(dom);
                List<DataBlock> singletonList = Collections.singletonList(new DataBlock(data.internalStorage()));
                var.data(dom, singletonList);
                bench.addInput(input.get((Object)var), data);
            }
            for (String c : this.spec.getConstraints()) {
                TsMultiBenchmarking.TemporalConstraintDescriptor temp = TsMultiBenchmarking.TemporalConstraintDescriptor.parse((String)c);
                if (temp != null) {
                    bench.addTemporalConstraint(temp);
                    continue;
                }
                TsMultiBenchmarking.ContemporaneousConstraintDescriptor cont = TsMultiBenchmarking.ContemporaneousConstraintDescriptor.parse((String)c);
                if (cont == null) continue;
                bench.addContemporaneousConstraint(cont);
            }
            bench.process();
            MultiBenchmarkingResults results = new MultiBenchmarkingResults();
            for (String n : bench.endogenous()) {
                results.addBenchmarked(n, bench.getResult(n));
            }
            for (String n : bench.input()) {
                results.addInput(n, bench.getInput(n));
            }
            return results;
        }
    }
}

