/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.disaggregation.processors;

import ec.benchmarking.simplets.TsExpander;
import ec.tss.disaggregation.documents.TsSmoothingSpecification;
import ec.tss.disaggregation.processors.ITemporalDisaggregationProcessingFactory;
import ec.tstoolkit.algorithm.AlgorithmDescriptor;
import ec.tstoolkit.algorithm.IProcSpecification;
import ec.tstoolkit.algorithm.IProcessing;
import ec.tstoolkit.algorithm.IProcessingFactory;
import ec.tstoolkit.algorithm.ProcessingContext;
import ec.tstoolkit.algorithm.SingleTsData;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class TsSmoothingProcessor
implements ITemporalDisaggregationProcessingFactory,
IProcessingFactory<TsSmoothingSpecification, TsData, SingleTsData> {
    public static final String NAME = "tsexpander";
    public static final String INTERPOLATION = "interpolation";
    public static final AlgorithmDescriptor DESCRIPTOR = new AlgorithmDescriptor("Temporal Disaggregation", "tsexpander", null);
    public static final TsSmoothingProcessor instance = new TsSmoothingProcessor();

    public void dispose() {
    }

    public AlgorithmDescriptor getInformation() {
        return DESCRIPTOR;
    }

    public boolean canHandle(IProcSpecification spec) {
        return spec instanceof TsSmoothingSpecification;
    }

    public IProcessing<TsData, SingleTsData> generateProcessing(final TsSmoothingSpecification specification, ProcessingContext context) {
        return new IProcessing<TsData, SingleTsData>(){

            public SingleTsData process(TsData input) {
                TsExpander expander = new TsExpander();
                double p = specification.getParameter() == null ? 0.0 : specification.getParameter().getValue();
                expander.setModel(specification.getModel());
                expander.setType(specification.getAggregationType());
                expander.useConst(specification.isConstant());
                expander.useTrend(specification.isTrend());
                if (specification.getParameter() != null && specification.getParameter().isFixed()) {
                    expander.estimateParameter(false);
                    expander.setParameter(specification.getParameter().getValue());
                } else {
                    expander.estimateParameter(true);
                }
                TsDomain ndom = input.getDomain().changeFrequency(specification.getNewFrequency(), true);
                ndom = ndom.extend(specification.getBackcastsCount(), specification.getForecastsCount());
                TsData ns = expander.expand(input, ndom);
                if (ns == null) {
                    return null;
                }
                return new SingleTsData(TsSmoothingProcessor.INTERPOLATION, ns);
            }
        };
    }

    public Map<String, Class> getSpecificationDictionary(Class<TsSmoothingSpecification> specClass) {
        LinkedHashMap<String, Class> dic = new LinkedHashMap<String, Class>();
        TsSmoothingSpecification.fillDictionary(null, dic);
        return dic;
    }

    public Map<String, Class> getOutputDictionary(boolean compact) {
        return Collections.singletonMap(INTERPOLATION, TsData.class);
    }
}

