/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.documents;

import ec.tss.documents.DocumentEvent;
import ec.tss.documents.DocumentManager;
import ec.tstoolkit.algorithm.AbstractDocument;
import ec.tstoolkit.algorithm.IActiveProcDocument;
import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.algorithm.IProcSpecification;
import ec.tstoolkit.algorithm.IProcessing;
import ec.tstoolkit.algorithm.ProcessingContext;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class ActiveDocument<S extends IProcSpecification, I, R extends IProcResults>
extends AbstractDocument<S, I, R>
implements IActiveProcDocument<S, I, R> {
    private I input_;
    private S spec_;
    private R results_;
    private boolean dirty_;
    private IProcessing.Status status_ = IProcessing.Status.Unprocessed;
    private final ProcessingContext context_;
    private volatile String desc_;

    public ActiveDocument(String desc) {
        this.desc_ = desc;
        this.context_ = ProcessingContext.getActiveContext();
    }

    public ActiveDocument(String desc, @NonNull ProcessingContext context) {
        this.desc_ = desc;
        this.context_ = context;
    }

    public void dispose() {
        DocumentManager.instance.remove(this.getKey());
    }

    public IProcessing.Status getStatus() {
        return this.status_;
    }

    public ProcessingContext getContext() {
        return this.context_;
    }

    protected void notify(DocumentEvent.Change event) {
        DocumentManager.instance.notify(new DocumentEvent(this, event));
    }

    public ActiveDocument clone() {
        try {
            ActiveDocument desc = (ActiveDocument)super.clone();
            return desc;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public S getSpecification() {
        return this.spec_;
    }

    public void setSpecification(S spec) {
        this.setSpecification(spec, false);
    }

    public void setDescription(String desc) {
        this.desc_ = desc;
    }

    protected void setSpecification(S spec, boolean quiet) {
        if (quiet) {
            this.spec_ = spec;
        } else {
            if (this.isLocked() || spec.equals(this.spec_)) {
                return;
            }
            this.spec_ = spec;
            this.clear();
            DocumentManager.instance.notify(new DocumentEvent(this, DocumentEvent.Change.Specification));
        }
    }

    public I getInput() {
        return this.input_;
    }

    public void setInput(I input) {
        this.setInput(input, false);
    }

    protected void setInput(I input, boolean quiet) {
        if (quiet) {
            this.input_ = input;
        } else if (!this.isLocked()) {
            this.input_ = input;
            this.clear();
            DocumentManager.instance.notify(new DocumentEvent(this, DocumentEvent.Change.Input));
        }
    }

    protected abstract R recalc(S var1, I var2);

    protected void results(R r) {
        this.results_ = r;
        this.status_ = this.results_ == null ? IProcessing.Status.Invalid : IProcessing.Status.Valid;
    }

    public boolean update() {
        boolean rslt = this.internalUpdate();
        DocumentManager.instance.update(this);
        return rslt;
    }

    private boolean internalUpdate() {
        if (this.status_ != IProcessing.Status.Unprocessed) {
            return false;
        }
        if (this.spec_ == null || this.input_ == null) {
            this.status_ = IProcessing.Status.Invalid;
            return false;
        }
        this.results_ = this.recalc(this.spec_, this.input_);
        if (this.results_ == null) {
            this.status_ = IProcessing.Status.Invalid;
            return false;
        }
        this.status_ = IProcessing.Status.Valid;
        return true;
    }

    public String getDescription() {
        return this.desc_;
    }

    public R getResults() {
        if (this.status_ == IProcessing.Status.Unprocessed) {
            this.update();
        }
        return this.results_;
    }

    public void clear() {
        this.dirty_ = true;
        this.status_ = IProcessing.Status.Unprocessed;
        this.results_ = null;
    }

    public boolean isDirty() {
        return this.dirty_ || super.isDirty();
    }

    public void resetDirty() {
        this.dirty_ = false;
        super.resetDirty();
    }

    protected void setDirty() {
        this.dirty_ = true;
    }
}

