/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.documents;

import ec.tss.Ts;
import ec.tss.TsCollection;
import ec.tss.TsFactory;
import ec.tss.TsMoniker;
import ec.tss.documents.ActiveDocument;
import ec.tss.documents.DocumentEvent;
import ec.tstoolkit.MetaData;
import ec.tstoolkit.algorithm.IProcDocument;
import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.design.Singleton;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.modelling.SeriesInfo;
import ec.tstoolkit.timeseries.Day;
import ec.tstoolkit.timeseries.simplets.TsData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;

@Singleton
public final class DocumentManager
extends Observable {
    public static final String COMPONENT = "@component";
    public static final String INFO = "@info";
    public static final String COMPOSITE = "@composite@";
    public static final DocumentManager instance;
    private final HashMap<Long, HashMap<String, TsMoniker>> tsMap_ = new HashMap();
    private final HashMap<Long, HashMap<String, CompositeTs>> xtsMap_ = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(long id) {
        HashMap<Long, HashMap<String, TsMoniker>> hashMap = this.tsMap_;
        synchronized (hashMap) {
            this.tsMap_.remove(id);
        }
    }

    private DocumentManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(ActiveDocument<?, ?, ?> doc) {
        Object r;
        Ts s;
        HashMap<String, Object> tmp;
        HashMap<String, Object> map;
        HashMap<Long, HashMap<String, Object>> hashMap = this.tsMap_;
        synchronized (hashMap) {
            map = this.tsMap_.get(doc.getKey());
            if (map != null) {
                tmp = new HashMap<String, Object>();
                for (Map.Entry<String, TsMoniker> kv : map.entrySet()) {
                    s = TsFactory.instance.getTs(kv.getValue());
                    if (s == null) continue;
                    tmp.put(kv.getKey(), kv.getValue());
                    r = doc.getResults();
                    if (r != null) {
                        s.set((TsData)r.getData(kv.getKey(), TsData.class));
                        continue;
                    }
                    s.set((TsData)null);
                }
                if (tmp.isEmpty()) {
                    this.tsMap_.remove(doc.getKey());
                } else {
                    this.tsMap_.put(doc.getKey(), tmp);
                }
            }
        }
        hashMap = this.xtsMap_;
        synchronized (hashMap) {
            map = this.xtsMap_.get(doc.getKey());
            if (map != null) {
                tmp = new HashMap();
                for (Map.Entry<String, Object> item : map.entrySet()) {
                    s = TsFactory.instance.getTs(((CompositeTs)item.getValue()).moniker);
                    if (s == null) continue;
                    tmp.put(item.getKey(), (CompositeTs)item.getValue());
                    r = doc.getResults();
                    this.fillComposite(s, (IProcDocument<?, ?, ?>)doc, (CompositeTs)item.getValue());
                }
                if (tmp.isEmpty()) {
                    this.xtsMap_.remove(doc.getKey());
                } else {
                    this.xtsMap_.put(doc.getKey(), tmp);
                }
            }
        }
    }

    private void fillComposite(Ts s, IProcDocument<?, ?, ?> doc, CompositeTs item) {
        MetaData md;
        TsData data = null;
        IProcResults rslts = doc.getResults();
        Day beg = null;
        Day end = null;
        if (rslts != null) {
            TsData b = null;
            TsData n = null;
            TsData f = null;
            if (item.back != null) {
                b = (TsData)rslts.getData(item.back, TsData.class);
            }
            if (item.now != null && (n = (TsData)rslts.getData(item.now, TsData.class)) != null) {
                beg = n.getStart().firstday();
                end = n.getLastPeriod().lastday();
            }
            if (item.fore != null) {
                f = (TsData)rslts.getData(item.fore, TsData.class);
            }
            data = TsData.concatenate((TsData)b, n);
            data = TsData.concatenate((TsData)data, (TsData)f);
        }
        if ((md = s.getMetaData()) == null) {
            md = new MetaData();
        }
        if (beg != null) {
            md.put("@beg", beg.toString());
        } else {
            md.remove((Object)"@beg");
        }
        if (end != null) {
            md.put("@end", end.toString());
        } else {
            md.remove((Object)"@end");
        }
        s.set(data, md);
    }

    void notify(DocumentEvent event) {
        this.setChanged();
        this.notifyObservers(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Ts getCompositeTs(IProcDocument<?, ?, ?> doc, String name) {
        HashMap<Long, HashMap<String, CompositeTs>> hashMap = this.xtsMap_;
        synchronized (hashMap) {
            CompositeTs cmp = CompositeTs.decode(name);
            if (cmp == null) {
                return null;
            }
            String cid = cmp.toString();
            HashMap<String, CompositeTs> map = this.xtsMap_.get(doc.getKey());
            if (map != null) {
                Ts ts;
                CompositeTs mts = map.get(cid);
                if (mts != null && (ts = TsFactory.instance.getTs(mts.moniker)) != null) {
                    return ts;
                }
            } else {
                map = new HashMap();
                this.xtsMap_.put(doc.getKey(), map);
            }
            TsMoniker m = TsMoniker.createDynamicMoniker();
            MetaData md = new MetaData();
            md.put("@algorithm", doc.getDescription());
            Ts ts = TsFactory.instance.createTs(cmp.name, m, md, null);
            cmp.moniker = ts.getMoniker();
            this.fillComposite(ts, doc, cmp);
            map.put(cid, cmp);
            return ts;
        }
    }

    public Ts getTs(IProcDocument<?, ?, ?> doc, String id) {
        return this.getTs(doc, id, false);
    }

    public Ts getTs(IProcDocument<?, ?, ?> doc, String id, boolean fullName) {
        if (id.startsWith(COMPOSITE)) {
            return this.getCompositeTs(doc, id.substring(COMPOSITE.length()));
        }
        if (doc instanceof ActiveDocument) {
            return this.getActiveTs((ActiveDocument)doc, id, fullName);
        }
        return this.getStaticTs(doc, id, fullName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Ts getActiveTs(ActiveDocument<?, ?, ?> doc, String id, boolean fullName) {
        HashMap<Long, HashMap<String, TsMoniker>> hashMap = this.tsMap_;
        synchronized (hashMap) {
            HashMap<String, TsMoniker> map = this.tsMap_.get(doc.getKey());
            if (map != null) {
                Ts ts;
                TsMoniker mts = map.get(id);
                if (mts != null && (ts = TsFactory.instance.getTs(mts)) != null) {
                    return ts;
                }
            } else {
                map = new HashMap();
                this.tsMap_.put(doc.getKey(), map);
            }
            Ts ts = this.getStaticTs((IProcDocument<?, ?, ?>)doc, id, fullName);
            map.put(id, ts.getMoniker());
            return ts;
        }
    }

    private Ts getStaticTs(IProcDocument<?, ?, ?> doc, String id, boolean fullName) {
        TsData data = null;
        IProcResults rslts = doc.getResults();
        if (rslts != null) {
            data = (TsData)rslts.getData(id, TsData.class);
        }
        String[] ids = InformationSet.split((String)id);
        TsMoniker m = TsMoniker.createDynamicMoniker();
        MetaData md = new MetaData();
        md.put("@algorithm", doc.getDescription());
        String name = fullName ? id : ids[ids.length - 1];
        Ts ts = TsFactory.instance.createTs(name, m, md, data);
        return ts;
    }

    public static TsCollection create(List<SeriesInfo> items, IProcDocument doc, String prefix, boolean desc) {
        TsCollection collection = TsFactory.instance.createTsCollection();
        for (SeriesInfo item : items) {
            Ts s = instance.getTs(doc, InformationSet.item((String)prefix, (String)item.getCode()));
            if (desc && s.getMetaData() == null) {
                MetaData md = new MetaData();
                md.put(COMPONENT, item.component.toString());
                md.put(INFO, item.info.toString());
                if (!desc) {
                    md.put("@description", item.toString());
                }
                s.set(md);
            }
            collection.quietAdd(s);
        }
        return collection;
    }

    public static TsCollection create(List<String> items, IProcDocument doc) {
        TsCollection collection = TsFactory.instance.createTsCollection();
        for (String item : items) {
            Ts s = instance.getTs(doc, item);
            collection.quietAdd(s);
        }
        return collection;
    }

    static {
        DocumentManager mgr;
        instance = mgr = new DocumentManager();
    }

    static class CompositeTs {
        String back;
        String now;
        String fore;
        String name;
        TsMoniker moniker;

        CompositeTs() {
        }

        static CompositeTs decode(String str) {
            CompositeTs cmp = new CompositeTs();
            int cur = 0;
            int pos = str.indexOf(61);
            if (pos < 0) {
                return null;
            }
            if (pos > cur) {
                cmp.name = str.substring(cur, pos);
            }
            if ((pos = str.indexOf(44, cur = pos + 1)) < 0) {
                return null;
            }
            if (pos > cur) {
                cmp.back = str.substring(cur, pos);
            }
            if ((pos = str.indexOf(44, cur = pos + 1)) < 0) {
                return null;
            }
            if (pos > cur) {
                cmp.now = str.substring(cur, pos);
            }
            if ((cur = pos + 1) < str.length()) {
                cmp.fore = str.substring(cur);
            }
            return cmp;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.name).append('=');
            if (this.back != null) {
                builder.append(this.back);
            }
            builder.append(',');
            if (this.now != null) {
                builder.append(this.now);
            }
            builder.append(',');
            if (this.fore != null) {
                builder.append(this.fore);
            }
            return builder.toString();
        }
    }
}

