/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.documents;

import ec.tss.Ts;
import ec.tss.TsFactory;
import ec.tss.TsInformation;
import ec.tss.TsInformationType;
import ec.tss.TsMoniker;
import ec.tss.TsStatus;
import ec.tss.documents.ActiveDocument;
import ec.tss.documents.TsDocument;
import ec.tstoolkit.algorithm.AlgorithmDescriptor;
import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.algorithm.IProcSpecification;
import ec.tstoolkit.algorithm.IProcessing;
import ec.tstoolkit.algorithm.IProcessingFactory;
import ec.tstoolkit.algorithm.ProcessingContext;
import ec.tstoolkit.information.Information;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.timeseries.TsException;
import ec.tstoolkit.timeseries.simplets.TsData;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public abstract class MultiTsDocument<S extends IProcSpecification, R extends IProcResults>
extends ActiveDocument<S, Ts[], R> {
    public static final String SERIES = "series";
    protected IProcessingFactory<S, TsData[], R> factory_;

    public MultiTsDocument(IProcessingFactory<S, TsData[], R> factory) {
        super(factory.getInformation().name);
        this.factory_ = factory;
    }

    public MultiTsDocument(IProcessingFactory<S, TsData[], R> factory, ProcessingContext context) {
        super(factory.getInformation().name, context);
        this.factory_ = factory;
    }

    @Deprecated
    public Ts[] getTs() {
        return (Ts[])this.getInput();
    }

    @Deprecated
    void setTs(Ts[] ts) {
        this.setInput(ts);
    }

    @Override
    public void setInput(Ts[] s) {
        if (this.isLocked() || Arrays.equals(MultiTsDocument.getMonikers((Ts[])this.getInput()), MultiTsDocument.getMonikers(s))) {
            return;
        }
        Ts[] frozen = new Ts[s.length];
        for (int i = 0; i < s.length; ++i) {
            if (s[i] == null) continue;
            frozen[i] = s[i].freeze();
        }
        super.setInput(frozen);
    }

    @Override
    protected R recalc(S spec, Ts[] input) {
        if (input == null) {
            return null;
        }
        TsData[] dinput = new TsData[input.length];
        for (int i = 0; i < input.length; ++i) {
            Ts s = input[i];
            if (s != null) {
                TsData d;
                if (s.hasData() == TsStatus.Undefined) {
                    s.load(TsInformationType.Data);
                }
                if ((d = s.getTsData()) == null) {
                    throw new TsException(s.getRawName() + ": No data");
                }
                dinput[i] = d;
                continue;
            }
            dinput[i] = null;
        }
        IProcessing processing = this.factory_.generateProcessing(spec, this.getContext());
        return (R)processing.process((Object)dinput);
    }

    @Override
    public MultiTsDocument<S, R> clone() {
        MultiTsDocument cl = (MultiTsDocument)super.clone();
        cl.setInput(MultiTsDocument.clone((Ts[])this.getInput()), true);
        return cl;
    }

    public IProcessingFactory<S, TsData[], R> getProcessor() {
        return this.factory_;
    }

    public TsMoniker[] getMonikers() {
        return MultiTsDocument.getMonikers((Ts[])this.getInput());
    }

    private static TsMoniker[] getMonikers(Ts[] ts) {
        if (ts == null) {
            return null;
        }
        TsMoniker[] monikers = new TsMoniker[ts.length];
        for (int i = 0; i < ts.length; ++i) {
            monikers[i] = ts[i] != null ? ts[i].getMoniker() : null;
        }
        return monikers;
    }

    public boolean isTsFrozen() {
        Ts[] ts = (Ts[])this.getInput();
        if (ts == null) {
            return false;
        }
        for (int i = 0; i < ts.length; ++i) {
            if (ts[i] == null || !ts[i].isFrozen()) continue;
            return true;
        }
        return false;
    }

    public void freezeTs() {
        Ts[] ts = (Ts[])this.getInput();
        if (ts == null) {
            return;
        }
        boolean changed = false;
        for (int i = 0; i < ts.length; ++i) {
            if (ts[i] == null || ts[i].isFrozen()) continue;
            ts[i] = ts[i].freeze();
            changed = true;
        }
        if (changed) {
            super.setInput(ts, true);
        }
    }

    public void unfreezeTs() {
        Ts[] ts = (Ts[])this.getInput();
        if (ts == null) {
            return;
        }
        boolean changed = false;
        for (int i = 0; i < ts.length; ++i) {
            if (!ts[i].isFrozen()) continue;
            ts[i] = ts[i].unfreeze();
            changed = true;
        }
        if (changed) {
            super.setInput(ts, false);
            this.getMetaData().put("@timestamp", new Date().toString());
        }
    }

    @Override
    public void setSpecification(S spec) {
        super.setSpecification(spec);
    }

    public InformationSet write(boolean verbose) {
        Object spec;
        Ts[] ts = (Ts[])this.getInput();
        InformationSet info = super.write(verbose);
        info.add("algorithm", (Object)this.factory_.getInformation());
        if (ts != null) {
            for (int i = 0; i < ts.length; ++i) {
                TsInformation tsinfo = ts[i].getMoniker().isAnonymous() ? ts[i].toInfo(TsInformationType.All) : ts[i].freeze().toInfo(TsInformationType.All);
                info.subSet("input").add(SERIES + i, (Object)tsinfo);
            }
        }
        if ((spec = this.getSpecification()) != null) {
            info.set("specification", (Object)spec.write(verbose));
        }
        return info;
    }

    public boolean read(InformationSet info) {
        InformationSet ispec;
        if (!super.read(info)) {
            return false;
        }
        AlgorithmDescriptor algorithm = (AlgorithmDescriptor)info.get("algorithm", AlgorithmDescriptor.class);
        if (algorithm == null || !this.factory_.getInformation().isCompatible(algorithm)) {
            return false;
        }
        InformationSet input = info.getSubSet("input");
        if (input != null) {
            List sel = input.select("series*", TsInformation.class);
            Collections.sort(sel, new Information.IndexedNameSorter(SERIES));
            Ts[] s = new Ts[sel.size()];
            for (int i = 0; i < s.length; ++i) {
                TsInformation tsinfo = (TsInformation)((Information)sel.get((int)i)).value;
                s[i] = TsFactory.instance.createTs(tsinfo.name, tsinfo.moniker, tsinfo.metaData, tsinfo.data);
            }
            this.setInput(s, true);
        }
        if ((ispec = info.getSubSet("specification")) != null) {
            Object spec = this.getSpecification();
            if (spec == null) {
                return false;
            }
            return spec.read(ispec);
        }
        return true;
    }

    @Override
    public String getDescription() {
        return this.factory_.getInformation().name;
    }

    public static Ts[] clone(Ts[] s) {
        if (s == null || s.length == 0) {
            return s;
        }
        Ts[] ns = (Ts[])s.clone();
        for (int i = 0; i < ns.length; ++i) {
            ns[i] = TsDocument.clone(s[i]);
        }
        return ns;
    }
}

