/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.documents;

import ec.tss.Ts;
import ec.tss.TsFactory;
import ec.tss.TsInformation;
import ec.tss.TsInformationType;
import ec.tss.TsMoniker;
import ec.tss.TsStatus;
import ec.tss.documents.ActiveDocument;
import ec.tss.documents.DocumentManager;
import ec.tstoolkit.algorithm.AlgorithmDescriptor;
import ec.tstoolkit.algorithm.CompositeResults;
import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.algorithm.IProcSpecification;
import ec.tstoolkit.algorithm.IProcessing;
import ec.tstoolkit.algorithm.IProcessingFactory;
import ec.tstoolkit.algorithm.ProcessingContext;
import ec.tstoolkit.algorithm.SingleTsData;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.timeseries.TsException;
import ec.tstoolkit.timeseries.simplets.TsData;
import java.util.Date;

public class TsDocument<S extends IProcSpecification, R extends IProcResults>
extends ActiveDocument<S, Ts, R> {
    public static final String SERIES = "series";
    private final IProcessingFactory<S, TsData, R> factory_;

    public TsDocument(IProcessingFactory<S, TsData, R> factory) {
        super(factory.getInformation().name);
        this.factory_ = factory;
    }

    public TsDocument(IProcessingFactory<S, TsData, R> factory, ProcessingContext context) {
        super(factory.getInformation().name, context);
        this.factory_ = factory;
    }

    @Override
    protected R recalc(S spec, Ts s) {
        TsData d;
        if (s.hasData() == TsStatus.Undefined) {
            s.load(TsInformationType.Data);
        }
        if ((d = s.getTsData()) == null) {
            throw new TsException(s.getRawName() + ": No data");
        }
        IProcessing processing = this.factory_.generateProcessing(spec, this.getContext());
        return (R)processing.process((Object)d);
    }

    public IProcessingFactory<S, TsData, R> getProcessor() {
        return this.factory_;
    }

    @Deprecated
    public void setTs(Ts s) {
        this.setInput(s);
    }

    @Override
    public void setInput(Ts s) {
        if (this.getInput() != null && ((Ts)this.getInput()).getMoniker().equals((Object)s.getMoniker())) {
            return;
        }
        super.setInput(s.freeze());
    }

    public boolean isTsFrozen() {
        if (this.getInput() == null) {
            return false;
        }
        return ((Ts)this.getInput()).isFrozen();
    }

    public void unfreezeTs() {
        Ts ts = (Ts)this.getInput();
        if (ts == null || !ts.isFrozen()) {
            return;
        }
        ts = ts.unfreeze();
        this.setInput(ts);
        this.getMetaData().put("@timestamp", new Date().toString());
    }

    public TsData getSeries() {
        Object rslts;
        Ts ts = (Ts)this.getInput();
        if (ts == null) {
            return null;
        }
        if (ts.hasData() == TsStatus.Undefined) {
            ts.load(TsInformationType.Data);
        }
        if ((rslts = this.getResults()) instanceof CompositeResults) {
            CompositeResults crslts = (CompositeResults)rslts;
            SingleTsData input = (SingleTsData)crslts.get("input", SingleTsData.class);
            if (input != null) {
                return input.getSeries();
            }
            return ((Ts)this.getInput()).getTsData();
        }
        return ts.getTsData();
    }

    @Deprecated
    public Ts getTs() {
        return (Ts)this.getInput();
    }

    public TsMoniker getMoniker() {
        Ts ts = (Ts)this.getInput();
        return ts == null ? null : ts.getMoniker();
    }

    @Override
    public TsDocument<S, R> clone() {
        TsDocument cl = (TsDocument)super.clone();
        cl.setInput(TsDocument.clone((Ts)this.getInput()), true);
        return cl;
    }

    @Override
    public void setSpecification(S spec) {
        super.setSpecification(spec);
    }

    public InformationSet write(boolean verbose) {
        Object spec;
        InformationSet info = super.write(verbose);
        info.add("algorithm", (Object)this.factory_.getInformation());
        Ts ts = (Ts)this.getInput();
        if (ts != null) {
            TsInformation tsinfo = ts.getMoniker().isAnonymous() ? ts.toInfo(TsInformationType.All) : ts.freeze().toInfo(TsInformationType.All);
            info.subSet("input").add(SERIES, (Object)tsinfo);
        }
        if ((spec = this.getSpecification()) != null) {
            info.set("specification", (Object)spec.write(verbose));
        }
        return info;
    }

    public boolean read(InformationSet info) {
        InformationSet ispec;
        TsInformation tsinfo;
        if (!super.read(info)) {
            return false;
        }
        AlgorithmDescriptor algorithm = (AlgorithmDescriptor)info.get("algorithm", AlgorithmDescriptor.class);
        if (algorithm == null || !this.factory_.getInformation().isCompatible(algorithm)) {
            return false;
        }
        InformationSet input = info.getSubSet("input");
        if (input != null && (tsinfo = (TsInformation)input.get(SERIES, TsInformation.class)) != null) {
            super.setInput(TsFactory.instance.createTs(tsinfo.name, tsinfo.moniker, tsinfo.metaData, tsinfo.data), true);
        }
        if ((ispec = info.getSubSet("specification")) != null) {
            Object spec = this.getSpecification();
            if (spec == null) {
                return false;
            }
            return spec.read(ispec);
        }
        return true;
    }

    protected void updateLinks() {
        DocumentManager.instance.update(this);
    }

    @Override
    public String getDescription() {
        return this.factory_.getInformation().name;
    }

    public static Ts clone(Ts s) {
        if (!s.isFrozen()) {
            return s;
        }
        return TsFactory.instance.createTs(s.getRawName(), s.getMetaData().clone(), s.getTsData());
    }
}

