/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.documents;

import ec.tstoolkit.MetaData;
import ec.tstoolkit.algorithm.IActiveProcDocument;
import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.algorithm.IProcSpecification;
import ec.tstoolkit.information.Information;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.utilities.IModifiable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class VersionedDocument<S extends IProcSpecification, I, R extends IProcResults, D extends IActiveProcDocument<S, I, R>>
implements IModifiable,
IActiveProcDocument<S, I, R> {
    public static final String CDOC = "cdoc";
    public static final String VDOC = "vdoc";
    public static final String VDOCS = "vdoc*";
    private List<D> versions = new ArrayList<D>();
    private D current;
    private boolean dirty;

    protected abstract D newDocument(D var1);

    protected abstract D restore(D var1);

    protected abstract D archive(D var1);

    protected VersionedDocument(D doc) {
        this.current = doc;
    }

    protected void addAll(Collection<D> docs) {
        this.versions.addAll(docs);
        this.dirty = true;
    }

    protected void add(D doc) {
        this.versions.add(doc);
        this.dirty = true;
    }

    public void removeVersion(int ver) {
        this.versions.remove(ver);
        this.dirty = true;
    }

    protected VersionedDocument<S, I, R, D> clone() throws CloneNotSupportedException {
        VersionedDocument vd = (VersionedDocument)super.clone();
        vd.versions = new ArrayList<D>();
        return vd;
    }

    public int getVersionCount() {
        return this.versions.size();
    }

    public D getVersion(int idx) {
        return (D)((IActiveProcDocument)this.versions.get(idx));
    }

    public D getLastVersion() {
        int n = this.versions.size();
        return (D)(n == 0 ? null : (IActiveProcDocument)this.versions.get(n - 1));
    }

    public void clearVersions(int ver) {
        if (ver >= this.versions.size()) {
            return;
        }
        if (ver == 0) {
            this.versions.clear();
        } else {
            for (int i = this.versions.size() - 1; i >= ver; --i) {
                this.versions.remove(i);
            }
        }
        this.dirty = true;
    }

    public D getCurrent() {
        return this.current;
    }

    public boolean isDirty() {
        if (this.dirty) {
            return true;
        }
        if (this.current instanceof IModifiable) {
            return ((IModifiable)this.current).isDirty();
        }
        return false;
    }

    public void setCurrent(D current) {
        this.current = current;
        this.dirty = true;
    }

    public void archive() {
        D ndoc = this.newDocument(this.current);
        this.versions.add(this.archive(this.current));
        this.current = ndoc;
        this.dirty = true;
    }

    public boolean restore(int version) {
        if (version >= this.versions.size()) {
            return false;
        }
        IActiveProcDocument rdoc = this.restore((IActiveProcDocument)this.versions.get(version));
        if (rdoc == null) {
            return false;
        }
        this.current = rdoc;
        for (int i = this.versions.size() - 1; i >= version; --i) {
            this.versions.remove(i);
        }
        this.dirty = true;
        return true;
    }

    public InformationSet write(boolean verbose) {
        InformationSet info = new InformationSet();
        info.add(CDOC, (Object)this.current.write(verbose));
        for (int i = 0; i < this.versions.size(); ++i) {
            info.add(VDOC + i, (Object)((IActiveProcDocument)this.versions.get(i)).write(verbose));
        }
        return info;
    }

    public boolean read(InformationSet info) {
        this.versions.clear();
        List v = info.select(VDOCS, InformationSet.class);
        for (Information vinfo : v) {
            D d = this.newDocument(null);
            if (!d.read((InformationSet)vinfo.value)) continue;
            this.versions.add(this.archive(d));
        }
        this.current = this.newDocument(null);
        InformationSet cur = info.getSubSet(CDOC);
        return !(cur != null ? !this.current.read(cur) : !this.current.read(info));
    }

    public void resetDirty() {
        this.dirty = false;
        if (this.current instanceof IModifiable) {
            ((IModifiable)this.current).resetDirty();
        }
    }

    protected void setDirty() {
        this.dirty = true;
    }

    public I getInput() {
        return (I)this.current.getInput();
    }

    public S getSpecification() {
        return (S)this.current.getSpecification();
    }

    public R getResults() {
        return (R)this.current.getResults();
    }

    public long getKey() {
        return this.current.getKey();
    }

    public String getDescription() {
        return this.current.getDescription();
    }

    public MetaData getMetaData() {
        return this.current.getMetaData();
    }

    public void setInput(I input) {
        this.current.setInput(input);
    }

    public void setSpecification(S spec) {
        this.current.setSpecification(spec);
    }

    public void setDescription(String desc) {
        this.current.setDescription(desc);
    }
}

