/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.formatters;

import ec.tss.formatters.IStringFormatter;
import ec.tstoolkit.maths.Complex;
import java.text.DecimalFormat;

public class ComplexFormatter
implements IStringFormatter {
    private static final DecimalFormat df4 = new DecimalFormat();
    private final DecimalFormat fmt;

    public ComplexFormatter() {
        this.fmt = df4;
    }

    public ComplexFormatter(DecimalFormat fmt) {
        this.fmt = fmt;
    }

    @Override
    public int getDefaultRepresentationLength() {
        return 2;
    }

    @Override
    public String format(Object obj, int item) {
        Complex c = (Complex)obj;
        if (item == 0) {
            return c.toString();
        }
        switch (Math.abs(item)) {
            case 1: {
                return this.fmt.format(c.abs());
            }
            case 2: {
                double arg = c.arg();
                if (arg == 0.0) {
                    return "";
                }
                double period = Math.PI * 2 / arg;
                if (period < -1.999999 && period > -2.000001) {
                    return "2";
                }
                return this.fmt.format(period);
            }
        }
        return "";
    }

    static {
        df4.setMaximumFractionDigits(4);
        df4.setGroupingUsed(false);
    }
}

