/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.formatters;

import ec.tss.TsMoniker;
import ec.tss.formatters.BooleanFormatter;
import ec.tss.formatters.ComplexFormatter;
import ec.tss.formatters.DiagnosticFormatter;
import ec.tss.formatters.DoubleFormatter;
import ec.tss.formatters.IStringFormatter;
import ec.tss.formatters.IntegerFormatter;
import ec.tss.formatters.LongFormatter;
import ec.tss.formatters.MonikerFormatter;
import ec.tss.formatters.ParameterFormatter;
import ec.tss.formatters.ParameterInfoFormatter;
import ec.tss.formatters.PeriodFormatter;
import ec.tss.formatters.RegressionItemFormatter;
import ec.tss.formatters.SarimaFormatter;
import ec.tss.formatters.StatisticalTestFormatter;
import ec.tss.formatters.StringFormatter;
import ec.tss.sa.output.BasicConfiguration;
import ec.tss.tsproviders.utils.MultiLineNameUtil;
import ec.tstoolkit.Parameter;
import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.algorithm.ProcDiagnostic;
import ec.tstoolkit.information.Information;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.information.ParameterInfo;
import ec.tstoolkit.information.RegressionItem;
import ec.tstoolkit.information.StatisticalTest;
import ec.tstoolkit.maths.Complex;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import ec.tstoolkit.utilities.NamedObject;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Type;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CsvInformationFormatter {
    private static final HashMap<Type, IStringFormatter> DICTIONARY = new HashMap();
    private static final String NEWLINE = System.lineSeparator();
    private final char comma = BasicConfiguration.getCsvSeparator();
    private boolean fullName;

    public void setFullName(boolean fullName) {
        this.fullName = fullName;
    }

    public CsvInformationFormatter() {
        DecimalFormat fmt = (DecimalFormat)DecimalFormat.getNumberInstance();
        fmt.setMaximumFractionDigits(BasicConfiguration.getFractionDigits());
        fmt.setGroupingUsed(false);
        DICTIONARY.put(Double.TYPE, new DoubleFormatter());
        DICTIONARY.put(Integer.TYPE, new IntegerFormatter());
        DICTIONARY.put(Long.TYPE, new LongFormatter());
        DICTIONARY.put(Boolean.TYPE, new BooleanFormatter("1", "0"));
        DICTIONARY.put((Type)((Object)Double.class), new DoubleFormatter());
        DICTIONARY.put((Type)((Object)Integer.class), new IntegerFormatter());
        DICTIONARY.put((Type)((Object)Long.class), new LongFormatter());
        DICTIONARY.put((Type)((Object)Boolean.class), new BooleanFormatter("1", "0"));
        DICTIONARY.put((Type)((Object)String.class), new StringFormatter());
        DICTIONARY.put((Type)((Object)SarimaModel.class), new SarimaFormatter());
        DICTIONARY.put((Type)((Object)ParameterInfo.class), new ParameterInfoFormatter());
        DICTIONARY.put((Type)((Object)Parameter.class), new ParameterFormatter());
        DICTIONARY.put((Type)((Object)TsMoniker.class), new MonikerFormatter());
        DICTIONARY.put((Type)((Object)TsPeriod.class), new PeriodFormatter());
        DICTIONARY.put((Type)((Object)RegressionItem.class), new RegressionItemFormatter(true));
        DICTIONARY.put((Type)((Object)StatisticalTest.class), new StatisticalTestFormatter());
        DICTIONARY.put((Type)((Object)ProcDiagnostic.class), new DiagnosticFormatter());
        DICTIONARY.put((Type)((Object)Complex.class), new ComplexFormatter());
    }

    public void format(Writer writer, List<InformationSet> records, List<String> names, boolean shortname) {
        ArrayList<MatrixItem[]> items = new ArrayList<MatrixItem[]>();
        LinkedHashSet dic = new LinkedHashSet();
        records.forEach(record -> {
            MatrixItem[] m = new MatrixItem[names.size()];
            for (int i = 0; i < m.length; ++i) {
                m[i] = new MatrixItem();
                m[i].fill((String)names.get(i), (InformationSet)record, shortname);
                m[i].fillDictionary(dic);
                items.add(m);
            }
        });
        this.format(writer, items, names.size(), null);
    }

    private void format(Writer writer, List<MatrixItem[]> items, int nnames, List<String> rowheaders) {
        int cur;
        ArrayList<LinkedHashMap<String, Integer>> wnames = new ArrayList<LinkedHashMap<String, Integer>>();
        for (cur = 0; cur < nnames; ++cur) {
            LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
            for (MatrixItem[] mis : items) {
                MatrixItem m = mis[cur];
                if (m.items == null) continue;
                for (int j = 0; j < m.items.length; ++j) {
                    Integer l = (Integer)map.get(m.items[j]);
                    if (l != null && l >= m.length) continue;
                    map.put(m.items[j], m.length);
                }
            }
            wnames.add(map);
        }
        try {
            if (rowheaders != null) {
                writer.write(this.comma);
            }
            this.writeColumnsHeaders(writer, wnames, nnames);
            cur = 0;
            for (MatrixItem[] item : items) {
                if (rowheaders != null) {
                    String rh;
                    if ((rh = rowheaders.get(cur++)) != null) {
                        this.writeHeader(writer, rh);
                    }
                    writer.write(this.comma);
                }
                this.writeLine(writer, item, wnames);
            }
            writer.close();
        }
        catch (IOException ex) {
            String string = ex.getMessage();
        }
    }

    private void writeLine(Writer writer, MatrixItem[] item, List<LinkedHashMap<String, Integer>> wnames) throws IOException {
        int k = 0;
        while (k < item.length) {
            MatrixItem citem = item[k];
            LinkedHashMap<String, Integer> map = wnames.get(k);
            int nmax = map.size();
            int i = 0;
            for (Map.Entry<String, Integer> ccur : map.entrySet()) {
                int j;
                String c = ccur.getKey();
                int n = ccur.getValue();
                Object obj = citem.search(c);
                if (obj != null) {
                    if (n == 1) {
                        this.write(writer, this.format(obj, 0));
                    } else {
                        for (j = 1; j <= n; ++j) {
                            this.write(writer, this.format(obj, j));
                            if (j >= n) continue;
                            writer.write(this.comma);
                        }
                    }
                } else {
                    for (j = 1; j < n; ++j) {
                        writer.write(this.comma);
                    }
                }
                if (++i >= nmax) continue;
                writer.write(this.comma);
            }
            if (++k < item.length) {
                writer.write(this.comma);
                continue;
            }
            writer.write(NEWLINE);
        }
    }

    private void writeColumnsHeaders(Writer writer, List<LinkedHashMap<String, Integer>> wnames, int n) throws IOException {
        int cur = 0;
        for (LinkedHashMap<String, Integer> map : wnames) {
            int ncur = 0;
            int nmax = map.size();
            for (Map.Entry<String, Integer> entry : map.entrySet()) {
                String c = entry.getKey();
                int i = entry.getValue();
                try {
                    this.write(writer, c);
                    for (int j = 1; j < i; ++j) {
                        writer.write(this.comma);
                    }
                    if (++ncur >= nmax) continue;
                    writer.write(this.comma);
                }
                catch (IOException iOException) {}
            }
            if (++cur < n) {
                writer.write(this.comma);
                continue;
            }
            writer.write(NEWLINE);
        }
    }

    public void formatResults(Writer writer, List<NamedObject<IProcResults>> records, List<String> names, boolean shortname) {
        ArrayList<MatrixItem[]> items = new ArrayList<MatrixItem[]>();
        LinkedHashSet dic = new LinkedHashSet();
        ArrayList<String> rowheaders = new ArrayList<String>();
        records.forEach(record -> {
            MatrixItem[] m = new MatrixItem[names.size()];
            for (int i = 0; i < m.length; ++i) {
                m[i] = new MatrixItem();
                m[i].fill((String)names.get(i), (IProcResults)record.object, shortname);
                m[i].fillDictionary(dic);
            }
            items.add(m);
            rowheaders.add(record.name);
        });
        this.format(writer, items, names.size(), rowheaders);
    }

    private String format(Object obj, int item) {
        try {
            IStringFormatter fmt = DICTIONARY.get(obj.getClass());
            if (fmt != null) {
                return fmt.format(obj, item);
            }
            if (item == 0) {
                return obj.toString();
            }
            return "";
        }
        catch (Exception ex) {
            String msg = ex.getMessage();
            return "";
        }
    }

    private void writeHeader(Writer writer, String txt) throws IOException {
        if (txt == null) {
            return;
        }
        txt = this.fullName ? MultiLineNameUtil.join(txt, " * ") : MultiLineNameUtil.last(txt);
        if ((txt = StringFormatter.cleanup(txt)).indexOf(this.comma) >= 0) {
            if (txt.indexOf(34) >= 0) {
                writer.write("\"\"");
                writer.write(txt);
                writer.write("\"\"");
            } else {
                writer.write(34);
                writer.write(txt);
                writer.write(34);
            }
        } else if (txt.indexOf(34) >= 0) {
            writer.write("\"\"");
            writer.write(txt);
            writer.write("\"\"");
        } else {
            writer.write(txt);
        }
    }

    private void write(Writer writer, String txt) throws IOException {
        if (txt == null) {
            return;
        }
        if (txt.indexOf(this.comma) >= 0) {
            if (txt.indexOf(34) >= 0) {
                writer.write("\"\"");
                writer.write(txt);
                writer.write("\"\"");
            } else {
                writer.write(34);
                writer.write(txt);
                writer.write(34);
            }
        } else if (txt.indexOf(34) >= 0) {
            writer.write("\"\"");
            writer.write(txt);
            writer.write("\"\"");
        } else {
            writer.write(txt);
        }
    }

    private static class MatrixItem {
        private static final Object[] EMPTY = new Object[0];
        private static final String[] SEMPTY = new String[0];
        int length;
        String[] items;
        Object[] results = EMPTY;

        private MatrixItem() {
        }

        boolean isHomogeneous() {
            if (this.results.length <= 1) {
                return true;
            }
            Class<?> c = null;
            for (int i = 0; i < this.results.length; ++i) {
                if (this.results[i] == null) continue;
                if (c == null) {
                    c = this.results[i].getClass();
                    continue;
                }
                if (this.results[i].getClass().equals(c)) continue;
                return false;
            }
            return true;
        }

        void fill(String id, InformationSet record, boolean shortname) {
            int l = id.indexOf(58);
            String sid = id;
            if (l >= 0) {
                sid = id.substring(0, l);
                String s1 = id.substring(l + 1);
                try {
                    this.length = Integer.parseInt(s1);
                }
                catch (Exception ex) {
                    this.length = 1;
                }
            }
            if (InformationSet.hasWildCards((String)sid)) {
                List sel = record.select(sid);
                if (!sel.isEmpty()) {
                    int n = sel.size();
                    this.results = new Object[n];
                    this.items = new String[n];
                    for (int i = 0; i < n; ++i) {
                        Information cur = (Information)sel.get(i);
                        this.results[i] = record.search(cur.name, Object.class);
                        this.items[i] = this.shortId(cur.name, shortname);
                    }
                    if (this.length == 0 && this.isHomogeneous()) {
                        this.updateLength();
                    }
                } else {
                    this.results = EMPTY;
                    this.items = SEMPTY;
                }
            } else {
                this.results = new Object[]{record.search(sid, Object.class)};
                this.items = new String[]{this.shortId(sid, shortname)};
                if (this.length == 0 && this.results[0] != null) {
                    this.updateLength();
                }
            }
        }

        void fill(String id, IProcResults record, boolean shortname) {
            if (record == null) {
                this.results = EMPTY;
                this.items = SEMPTY;
                return;
            }
            int l = id.indexOf(58);
            String sid = id;
            if (l >= 0) {
                sid = id.substring(0, l);
                String s1 = id.substring(l + 1);
                try {
                    this.length = Integer.parseInt(s1);
                }
                catch (Exception ex) {
                    this.length = 1;
                }
            }
            if (InformationSet.hasWildCards((String)sid)) {
                Map sel = record.searchAll(sid, Object.class);
                ArrayList ids = new ArrayList();
                ArrayList objs = new ArrayList();
                if (!sel.isEmpty()) {
                    sel.forEach((s, o) -> {
                        if (o != null) {
                            ids.add(this.shortId((String)s, shortname));
                            objs.add(o);
                        }
                    });
                    int n = ids.size();
                    this.results = objs.toArray(EMPTY);
                    this.items = ids.toArray(SEMPTY);
                    if (this.length == 0 && this.isHomogeneous()) {
                        this.updateLength();
                    }
                } else {
                    this.results = EMPTY;
                    this.items = SEMPTY;
                }
            } else {
                this.results = new Object[]{record.getData(sid, Object.class)};
                this.items = new String[]{this.shortId(sid, shortname)};
                if (this.length == 0 && this.results[0] != null) {
                    this.updateLength();
                }
            }
        }

        void updateLength() {
            if (this.results.length == 0) {
                return;
            }
            IStringFormatter fmt = (IStringFormatter)DICTIONARY.get(this.results[0].getClass());
            this.length = fmt != null ? fmt.getDefaultRepresentationLength() : 1;
        }

        String shortId(String id, boolean shortname) {
            if (!shortname) {
                return id;
            }
            int last = id.lastIndexOf(46);
            if (last < 0) {
                return id;
            }
            return id.substring(last + 1);
        }

        void fillDictionary(Set<String> ids) {
            for (int i = 0; i < this.items.length; ++i) {
                ids.add(this.items[i]);
            }
        }

        Object search(String id) {
            for (int i = 0; i < this.items.length; ++i) {
                if (!this.items[i].equals(id)) continue;
                return this.results[i];
            }
            return null;
        }
    }
}

