/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.formatters;

import ec.tss.TsMoniker;
import ec.tss.formatters.BooleanFormatter;
import ec.tss.formatters.ComplexFormatter;
import ec.tss.formatters.DiagnosticFormatter;
import ec.tss.formatters.DoubleFormatter;
import ec.tss.formatters.IStringFormatter;
import ec.tss.formatters.IntegerFormatter;
import ec.tss.formatters.LongFormatter;
import ec.tss.formatters.MonikerFormatter;
import ec.tss.formatters.ParameterFormatter;
import ec.tss.formatters.ParameterInfoFormatter;
import ec.tss.formatters.PeriodFormatter;
import ec.tss.formatters.RegressionItemFormatter;
import ec.tss.formatters.SarimaFormatter;
import ec.tss.formatters.StatisticalTestFormatter;
import ec.tss.formatters.StringFormatter;
import ec.tstoolkit.Parameter;
import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.algorithm.ProcDiagnostic;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.information.ParameterInfo;
import ec.tstoolkit.information.RegressionItem;
import ec.tstoolkit.information.StatisticalTest;
import ec.tstoolkit.maths.Complex;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class MatrixFormatter {
    private static final HashMap<Class, IStringFormatter> DICTIONARY = new HashMap();

    public static boolean canProcess(Class cl) {
        return DICTIONARY.containsKey(cl);
    }

    public String[] formatInformation(List<InformationSet> records, List<String> names, boolean shortname) {
        ArrayList<String[]> snames = new ArrayList<String[]>();
        for (String name : names) {
            snames.add(InformationSet.split((String)name));
        }
        int[] witems = new int[snames.size()];
        int icur = 0;
        for (String[] sname : snames) {
            Iterator<InformationSet> slast = sname[sname.length - 1];
            int l = ((String)((Object)slast)).indexOf(58);
            witems[icur] = 1;
            if (l >= 0) {
                String s0 = ((String)((Object)slast)).substring(0, l);
                String s1 = ((String)((Object)slast)).substring(l + 1);
                int w = 0;
                try {
                    w = Integer.parseInt(s1);
                    sname[sname.length - 1] = s0;
                    witems[icur] = w;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++icur;
        }
        ArrayList<String> rslt = new ArrayList<String>();
        int i = 0;
        for (String[] cnames : snames) {
            if (shortname) {
                rslt.add(cnames[cnames.length - 1]);
            } else {
                rslt.add(names.get(i));
            }
            for (int j = 1; j < witems[i]; ++j) {
                rslt.add("");
            }
        }
        for (InformationSet record : records) {
            i = 0;
            for (String[] cnames : snames) {
                int j;
                int n = witems[i];
                Object obj = record.search(cnames, Object.class);
                if (obj != null) {
                    if (n == 1) {
                        rslt.add(this.format(obj, 0));
                        continue;
                    }
                    if (n < 0) {
                        rslt.add(this.format(obj, -n));
                        continue;
                    }
                    for (j = 1; j <= n; ++j) {
                        rslt.add(this.format(obj, j));
                    }
                    continue;
                }
                for (j = 0; j < n; ++j) {
                    rslt.add("");
                }
            }
        }
        String[] srslt = new String[rslt.size()];
        return rslt.toArray(srslt);
    }

    public String[] formatProcResults(List<IProcResults> records, List<String> names, boolean shortname) {
        ArrayList<String[]> snames = new ArrayList<String[]>();
        for (String name : names) {
            snames.add(InformationSet.split((String)name));
        }
        int[] witems = new int[snames.size()];
        int icur = 0;
        for (String[] sname : snames) {
            Iterator<IProcResults> slast = sname[sname.length - 1];
            int l = ((String)((Object)slast)).indexOf(58);
            witems[icur] = 1;
            if (l >= 0) {
                String s0 = ((String)((Object)slast)).substring(0, l);
                String s1 = ((String)((Object)slast)).substring(l + 1);
                int w = 0;
                try {
                    w = Integer.parseInt(s1);
                    sname[sname.length - 1] = s0;
                    witems[icur] = w;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++icur;
        }
        ArrayList<String> rslt = new ArrayList<String>();
        int i = 0;
        for (String[] cnames : snames) {
            if (shortname) {
                rslt.add(cnames[cnames.length - 1]);
            } else {
                rslt.add(names.get(i));
            }
            for (int j = 1; j < witems[i]; ++j) {
                rslt.add("");
            }
        }
        for (IProcResults record : records) {
            i = 0;
            for (String[] cnames : snames) {
                int j;
                int n = witems[i];
                Object obj = record.getData(InformationSet.concatenate((String[])cnames), Object.class);
                if (obj != null) {
                    if (n == 1) {
                        rslt.add(this.format(obj, 0));
                        continue;
                    }
                    for (j = 1; j <= n; ++j) {
                        rslt.add(this.format(obj, j));
                    }
                    continue;
                }
                for (j = 0; j < n; ++j) {
                    rslt.add("");
                }
            }
        }
        String[] srslt = new String[rslt.size()];
        return rslt.toArray(srslt);
    }

    private String format(Object obj, int item) {
        try {
            IStringFormatter fmt = DICTIONARY.get(obj.getClass());
            return fmt.format(obj, item);
        }
        catch (Exception ex) {
            String string = ex.getMessage();
            if (item == 0) {
                return obj.toString();
            }
            return "";
        }
    }

    static {
        DICTIONARY.put(Double.TYPE, new DoubleFormatter());
        DICTIONARY.put(Integer.TYPE, new IntegerFormatter());
        DICTIONARY.put(Long.TYPE, new LongFormatter());
        DICTIONARY.put(Boolean.TYPE, new BooleanFormatter("1", "0"));
        DICTIONARY.put(Double.class, new DoubleFormatter());
        DICTIONARY.put(Integer.class, new IntegerFormatter());
        DICTIONARY.put(Long.class, new LongFormatter());
        DICTIONARY.put(Boolean.class, new BooleanFormatter("1", "0"));
        DICTIONARY.put(String.class, new StringFormatter());
        DICTIONARY.put(SarimaModel.class, new SarimaFormatter());
        DICTIONARY.put(Parameter.class, new ParameterFormatter());
        DICTIONARY.put(ParameterInfo.class, new ParameterInfoFormatter());
        DICTIONARY.put(TsMoniker.class, new MonikerFormatter());
        DICTIONARY.put(TsPeriod.class, new PeriodFormatter());
        DICTIONARY.put(RegressionItem.class, new RegressionItemFormatter());
        DICTIONARY.put(StatisticalTest.class, new StatisticalTestFormatter());
        DICTIONARY.put(ProcDiagnostic.class, new DiagnosticFormatter());
        DICTIONARY.put(Complex.class, new ComplexFormatter());
    }
}

