/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.formatters;

import com.google.common.base.Strings;
import ec.tss.formatters.IStringFormatter;
import ec.tss.formatters.StringFormatter;
import ec.tstoolkit.information.RegressionItem;
import java.text.DecimalFormat;

public class RegressionItemFormatter
implements IStringFormatter {
    private static final DecimalFormat df6 = new DecimalFormat();
    private static final DecimalFormat df4 = new DecimalFormat();
    private final DecimalFormat fmt;
    private final boolean showDesc_;

    public RegressionItemFormatter() {
        this.fmt = df6;
        this.showDesc_ = false;
    }

    public RegressionItemFormatter(boolean showdesc) {
        this.fmt = df6;
        this.showDesc_ = showdesc;
    }

    public RegressionItemFormatter(DecimalFormat fmt, boolean showdesc) {
        this.fmt = fmt;
        this.showDesc_ = showdesc;
    }

    @Override
    public int getDefaultRepresentationLength() {
        return 3;
    }

    @Override
    public String format(Object obj, int item) {
        RegressionItem reg = (RegressionItem)obj;
        if (item == 0) {
            return this.format(reg);
        }
        if (Strings.isNullOrEmpty((String)reg.description) || !this.showDesc_) {
            ++item;
        }
        switch (Math.abs(item)) {
            case 1: {
                return StringFormatter.cleanup(reg.description);
            }
            case 2: {
                return this.fmt.format(reg.coefficient);
            }
            case 3: {
                if (reg.stdError == 0.0) {
                    return "";
                }
                return df4.format(reg.coefficient / reg.stdError);
            }
            case 4: {
                return this.fmt.format(reg.stdError);
            }
            case 5: {
                return df4.format(reg.pValue);
            }
        }
        return "";
    }

    private String format(RegressionItem reg) {
        StringBuilder builder = new StringBuilder();
        if (reg.description != null) {
            builder.append(reg.description).append(':');
        }
        builder.append(df4.format(reg.coefficient));
        if (reg.stdError != 0.0) {
            builder.append('[').append(df4.format(reg.coefficient / reg.stdError)).append(']');
        }
        return builder.toString();
    }

    static {
        df6.setMaximumFractionDigits(6);
        df4.setMaximumFractionDigits(4);
        df6.setGroupingUsed(false);
        df4.setGroupingUsed(false);
    }
}

