/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.formatters;

import com.google.common.base.Strings;
import ec.tss.formatters.IStringFormatter;
import ec.tstoolkit.information.StatisticalTest;
import java.text.DecimalFormat;

public class StatisticalTestFormatter
implements IStringFormatter {
    private static final DecimalFormat df6 = new DecimalFormat();
    private static final DecimalFormat df4 = new DecimalFormat();
    private final DecimalFormat fmt;

    public StatisticalTestFormatter() {
        this.fmt = df6;
    }

    public StatisticalTestFormatter(DecimalFormat fmt) {
        this.fmt = fmt;
    }

    @Override
    public String format(Object obj, int item) {
        StatisticalTest test = (StatisticalTest)obj;
        if (item == 0) {
            return this.fmt.format(test.value);
        }
        if (Strings.isNullOrEmpty((String)test.description)) {
            ++item;
        }
        switch (Math.abs(item)) {
            case 1: {
                return test.description;
            }
            case 2: {
                return this.fmt.format(test.value);
            }
            case 3: {
                return df4.format(test.pvalue);
            }
        }
        return "";
    }

    static {
        df6.setMaximumFractionDigits(6);
        df4.setMaximumFractionDigits(4);
        df6.setGroupingUsed(false);
        df4.setGroupingUsed(false);
    }
}

