/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.formatters;

import ec.tss.TsMoniker;
import ec.tss.formatters.BooleanFormatter;
import ec.tss.formatters.DiagnosticFormatter;
import ec.tss.formatters.DoubleFormatter;
import ec.tss.formatters.IStringFormatter;
import ec.tss.formatters.IntegerFormatter;
import ec.tss.formatters.LongFormatter;
import ec.tss.formatters.MonikerFormatter;
import ec.tss.formatters.ParameterFormatter;
import ec.tss.formatters.ParameterInfoFormatter;
import ec.tss.formatters.PeriodFormatter;
import ec.tss.formatters.RegressionItemFormatter;
import ec.tss.formatters.SarimaFormatter;
import ec.tss.formatters.StatisticalTestFormatter;
import ec.tss.formatters.StringFormatter;
import ec.tstoolkit.Parameter;
import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.algorithm.ProcDiagnostic;
import ec.tstoolkit.data.Table;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.information.ParameterInfo;
import ec.tstoolkit.information.RegressionItem;
import ec.tstoolkit.information.StatisticalTest;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class TableFormatter {
    private static HashMap<Class, IStringFormatter> dictionary = new HashMap();

    public TableFormatter() {
        dictionary.put(Double.TYPE, new DoubleFormatter());
        dictionary.put(Integer.TYPE, new IntegerFormatter());
        dictionary.put(Long.TYPE, new LongFormatter());
        dictionary.put(Boolean.TYPE, new BooleanFormatter("1", "0"));
        dictionary.put(Double.class, new DoubleFormatter());
        dictionary.put(Integer.class, new IntegerFormatter());
        dictionary.put(Long.class, new LongFormatter());
        dictionary.put(Boolean.class, new BooleanFormatter("1", "0"));
        dictionary.put(String.class, new StringFormatter());
        dictionary.put(SarimaModel.class, new SarimaFormatter());
        dictionary.put(Parameter.class, new ParameterFormatter());
        dictionary.put(ParameterInfo.class, new ParameterInfoFormatter());
        dictionary.put(TsMoniker.class, new MonikerFormatter());
        dictionary.put(TsPeriod.class, new PeriodFormatter());
        dictionary.put(RegressionItem.class, new RegressionItemFormatter());
        dictionary.put(StatisticalTest.class, new StatisticalTestFormatter());
        dictionary.put(ProcDiagnostic.class, new DiagnosticFormatter());
    }

    public Table<String> formatInformation(List<InformationSet> records, List<String> names, boolean shortname) {
        ArrayList<String[]> snames = new ArrayList<String[]>();
        for (String name : names) {
            snames.add(InformationSet.split((String)name));
        }
        int[] witems = new int[snames.size()];
        int ncols = 0;
        int icur = 0;
        for (String[] sname : snames) {
            String slast = sname[sname.length - 1];
            int l = slast.indexOf(58);
            int w = 1;
            if (l >= 0) {
                String s0 = slast.substring(0, l);
                String s1 = slast.substring(l + 1);
                try {
                    w = Integer.parseInt(s1);
                    sname[sname.length - 1] = s0;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            witems[icur] = w;
            ncols = w < 0 ? ++ncols : (ncols += w);
            ++icur;
        }
        Table rslt = new Table(records.size(), ncols);
        int row = 0;
        for (InformationSet record : records) {
            if (record == null) continue;
            int c = 0;
            int col = 0;
            for (String[] cnames : snames) {
                int n = witems[c++];
                Object obj = record.search(cnames, Object.class);
                if (obj != null) {
                    if (n == 1) {
                        rslt.set(row, col++, (Object)this.format(obj, 0));
                        continue;
                    }
                    if (n < 0) {
                        rslt.set(row, col++, (Object)this.format(obj, n));
                        continue;
                    }
                    for (int j = 1; j <= n; ++j) {
                        rslt.set(row, col++, (Object)this.format(obj, j));
                    }
                    continue;
                }
                if (n < 0) {
                    ++col;
                    continue;
                }
                col += n;
            }
            ++row;
        }
        return rslt;
    }

    public Table<String> formatProcResults(List<IProcResults> records, List<String> names, boolean shortname) {
        ArrayList<String[]> snames = new ArrayList<String[]>();
        for (String name : names) {
            snames.add(InformationSet.split((String)name));
        }
        int[] witems = new int[snames.size()];
        int ncols = 0;
        int icur = 0;
        for (String[] sname : snames) {
            String slast = sname[sname.length - 1];
            int l = slast.indexOf(58);
            int w = 1;
            if (l >= 0) {
                String s0 = slast.substring(0, l);
                String s1 = slast.substring(l + 1);
                try {
                    w = Integer.parseInt(s1);
                    sname[sname.length - 1] = s0;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            witems[icur] = w;
            ncols = w < 0 ? ++ncols : (ncols += w);
            ++icur;
        }
        Table rslt = new Table(records.size(), ncols);
        int row = 0;
        for (IProcResults record : records) {
            if (record == null) continue;
            int c = 0;
            int col = 0;
            for (String[] cnames : snames) {
                int n = witems[c++];
                Object obj = record.getData(InformationSet.concatenate((String[])cnames), Object.class);
                if (obj != null) {
                    if (n == 1) {
                        rslt.set(row, col++, (Object)this.format(obj, 0));
                        continue;
                    }
                    if (n < 0) {
                        rslt.set(row, col++, (Object)this.format(obj, n));
                        continue;
                    }
                    if (n <= 1) continue;
                    for (int j = 1; j <= n; ++j) {
                        rslt.set(row, col++, (Object)this.format(obj, j));
                    }
                    continue;
                }
                if (n < 0) {
                    ++col;
                    continue;
                }
                col += n;
            }
            ++row;
        }
        return rslt;
    }

    private String format(Object obj, int item) {
        try {
            if (obj != null && obj.getClass().isArray()) {
                Object[] array = (Object[])obj;
                IStringFormatter fmt = dictionary.get(array[0].getClass());
                Object[] rslt = Arrays.stream(array).map(i -> fmt.format(i, item)).toArray();
                return Arrays.toString(rslt);
            }
            IStringFormatter fmt = dictionary.get(obj.getClass());
            return fmt.format(obj, item);
        }
        catch (Exception ex) {
            String string = ex.getMessage();
            if (item == 0) {
                return obj.toString();
            }
            return "";
        }
    }
}

