/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.formatters.sa;

import ec.satoolkit.seats.SeatsSpecification;
import ec.satoolkit.tramoseats.TramoSeatsSpecification;
import ec.tstoolkit.Parameter;
import ec.tstoolkit.modelling.arima.tramo.ArimaSpec;
import ec.tstoolkit.modelling.arima.tramo.AutoModelSpec;
import ec.tstoolkit.modelling.arima.tramo.CalendarSpec;
import ec.tstoolkit.modelling.arima.tramo.EasterSpec;
import ec.tstoolkit.modelling.arima.tramo.EstimateSpec;
import ec.tstoolkit.modelling.arima.tramo.OutlierSpec;
import ec.tstoolkit.modelling.arima.tramo.RegressionSpec;
import ec.tstoolkit.modelling.arima.tramo.TransformSpec;
import ec.tstoolkit.timeseries.PeriodSelectorType;
import ec.tstoolkit.timeseries.regression.OutlierDefinition;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import java.util.Formatter;
import java.util.Locale;

public class TramoSeatsConverter {
    private Format m_fmt;
    private static final String DM_INPUT = "TRAMO/SEATS SAIP:";
    private static final String TS_INPUT = "INPUT ";
    private static final String DM_REG = "REG:";
    private static final String TS_REG = "REG ";
    private static final String DFMT = "%6g";
    private char m_sep;
    private boolean m_closed;
    private StringBuilder m_builder;

    private void openDocument() {
        this.m_builder = new StringBuilder();
        this.m_closed = false;
        if (this.m_fmt == Format.Demetra) {
            this.openSection(DM_INPUT);
        } else {
            this.openSection(TS_INPUT);
        }
    }

    private void openReg() {
        if (this.m_fmt == Format.Demetra) {
            this.openSection(DM_REG);
        } else {
            this.openSection(TS_REG);
        }
    }

    private void openSection(String section) {
        if (this.m_fmt == Format.Demetra) {
            this.m_builder.append('[').append(section);
        } else {
            if (!this.m_closed) {
                this.m_builder.append('$');
            }
            this.m_builder.append(section);
        }
        this.m_closed = false;
    }

    void closeSection() {
        if (this.m_fmt == Format.Demetra) {
            this.m_builder.append(']');
        } else if (!this.m_closed) {
            this.m_builder.append('$');
        }
        this.m_closed = true;
    }

    public TramoSeatsConverter(Format fmt) {
        this.m_fmt = fmt;
        this.m_sep = (char)(fmt == Format.TramoSeats ? 32 : 44);
    }

    public String encode(TsDomain domain, TramoSeatsSpecification tspec) {
        this.openDocument();
        this.m_builder.append((Object)Item.SEATS).append("=2").append(this.m_sep);
        this.write(tspec.getTramoSpecification().getTransform());
        this.write(tspec.getTramoSpecification().getArima());
        this.write(tspec.getTramoSpecification().getAutoModel());
        this.write(tspec.getTramoSpecification().getRegression());
        this.write(domain, tspec.getTramoSpecification().getOutliers());
        this.writeMissingSpec();
        this.write(tspec.getTramoSpecification().getEstimate());
        this.write(tspec.getSeatsSpecification());
        int nregs = this.regsCount(tspec.getTramoSpecification().getRegression());
        if (nregs > 0) {
            this.write(Item.IREG, nregs);
            this.closeSection();
            this.write(domain, tspec.getTramoSpecification().getRegression());
        } else {
            this.closeSection();
        }
        return this.m_builder.toString();
    }

    private int regsCount(RegressionSpec spec) {
        if (spec == null) {
            return 0;
        }
        int n = 0;
        n += spec.getRampsCount();
        n += spec.getOutliersCount();
        return n += spec.getUserDefinedVariablesCount();
    }

    private void write(Item item, int value) {
        this.m_builder.append((Object)item).append('=').append(value).append(this.m_sep);
    }

    private void write(Item item, int idx, int value) {
        this.m_builder.append((Object)item).append('(').append(idx).append(")=").append(value).append(this.m_sep);
    }

    private void write(Item item, int idx, double value) {
        this.m_builder.append((Object)item).append('(').append(idx).append(")=").append(new Formatter().format(DFMT, Locale.ROOT, value)).append(this.m_sep);
    }

    private void write(Item item, double value) {
        this.m_builder.append((Object)item).append('=').append(new Formatter().format(DFMT, Locale.ROOT, value)).append(this.m_sep);
    }

    private void write(Item item, double value, String fmt) {
        this.m_builder.append((Object)item).append('=').append(new Formatter().format(fmt, Locale.ROOT, value)).append(this.m_sep);
    }

    private void write(Item item, TsPeriod p) {
        this.m_builder.append((Object)item).append('=').append(p.getYear()).append('.').append(new Formatter().format("D2", p.getPosition() + 1)).append(this.m_sep);
    }

    private void write(Item item, int idx, TsPeriod p) {
        this.m_builder.append((Object)item).append('(').append(idx).append(")=").append(p.getYear()).append('.').append(new Formatter().format("D2", p.getPosition() + 1));
    }

    private void write(SeatsSpecification spec) {
        if (spec == null) {
            return;
        }
        if (spec.getApproximationMode() != SeatsSpecification.ApproximationMode.None) {
            this.write(Item.NOADMISS, 1);
        }
        if (spec.getTrendBoundary() != 0.5) {
            this.write(Item.RMOD, spec.getTrendBoundary());
        }
        if (spec.getSeasTolerance() != 2.0) {
            this.write(Item.EPSPHI, spec.getSeasTolerance());
        }
    }

    private void write(EstimateSpec spec) {
        if (spec == null) {
            return;
        }
        if (spec.getTol() != 1.0E-7) {
            this.write(Item.TOL, spec.getTol());
        }
        if (spec.getUbp() != 0.96) {
            this.write(Item.UBP, spec.getUbp());
        }
    }

    private void writeMissingSpec() {
        this.write(Item.INTERP, 2);
    }

    private void write(TsDomain domain, OutlierSpec spec) {
        if (spec == null || !spec.isUsed()) {
            return;
        }
        this.write(Item.IATIP, 1);
        this.write(Item.AIO, spec.getAIO());
        if (spec.getCriticalValue() != 0.0) {
            this.write(Item.VA, spec.getCriticalValue());
        }
        if (spec.isEML()) {
            this.write(Item.IMVX, 1);
        }
        if (spec.getSpan().getType() != PeriodSelectorType.All) {
            TsDomain ndom = domain.select(spec.getSpan());
            if (!ndom.isEmpty()) {
                if (this.m_fmt == Format.TramoSeats) {
                    this.write(Item.INT1, domain.getLength() + 1);
                } else {
                    this.write(Item.INT1, ndom.getEnd());
                }
            } else if (this.m_fmt == Format.TramoSeats) {
                this.write(Item.INT1, 1 + ndom.getStart().minus(domain.getStart()));
                this.write(Item.INT2, ndom.getEnd().minus(domain.getStart()));
            } else {
                this.write(Item.INT1, ndom.getStart());
                this.write(Item.INT2, ndom.getLast());
            }
        }
    }

    private void write(TsDomain domain, RegressionSpec spec) {
        if (spec == null) {
            return;
        }
        this.write(spec.getCalendar());
        this.write(domain, spec.getOutliers());
    }

    private void write(RegressionSpec spec) {
        if (spec == null) {
            return;
        }
        this.write(spec.getCalendar());
    }

    private void write(CalendarSpec spec) {
        int idur;
        int ieast;
        if (spec == null) {
            return;
        }
        int itrad = spec.getTradingDays().getTradingDaysType().getVariablesCount();
        if (itrad != 0 && spec.getTradingDays().isTest()) {
            itrad = -itrad;
        }
        if (itrad != 0) {
            this.write(Item.ITRAD, itrad);
        }
        int n = ieast = spec.getEaster().getOption() != EasterSpec.Type.Unused ? 1 : 0;
        if (ieast != 0 && spec.getEaster().isTest()) {
            ieast = -ieast;
        }
        if (ieast != 0) {
            this.write(Item.IEAST, ieast);
        }
        if ((idur = spec.getEaster().getDuration()) != 6) {
            this.write(Item.IDUR, idur);
        }
    }

    private void write(TsDomain domain, OutlierDefinition[] spec) {
        if (spec == null || spec.length == 0) {
            return;
        }
        this.openReg();
        this.write(Item.IUSER, 2);
        this.write(Item.NSER, spec.length);
        if (this.m_fmt == Format.TramoSeats) {
            for (int i = 0; i < spec.length; ++i) {
                this.m_builder.append(new TsPeriod(domain.getFrequency(), spec[i].getPosition()).minus(domain.getStart()) + 1).append(this.m_sep).append(spec[i].getType());
                if (i >= spec.length - 1) continue;
                this.m_builder.append(this.m_sep);
            }
        } else {
            for (int i = 0; i < spec.length; ++i) {
                TsPeriod p = new TsPeriod(domain.getFrequency(), spec[i].getPosition());
                this.m_builder.append((Object)Item.pos).append('(').append(i + 1).append(")=").append(p.getYear()).append('.').append(new Formatter().format("D2", p.getPosition() + 1));
                this.m_builder.append(this.m_sep).append((Object)Item.type).append('(').append(i + 1).append(")=").append(spec[i].getCode().toLowerCase());
                if (i >= spec.length - 1) continue;
                this.m_builder.append(this.m_sep);
            }
        }
        this.closeSection();
    }

    private void write(AutoModelSpec spec) {
        if (spec == null || !spec.isEnabled()) {
            return;
        }
        this.write(Item.INIC, 3);
        this.write(Item.IDIF, 3);
        if (spec.getCancel() != 0.05) {
            this.write(Item.CANCEL, spec.getCancel());
        }
        if (spec.getUb1() != 0.97) {
            this.write(Item.UB1, spec.getUb1());
        }
        if (spec.getUb2() != 0.91) {
            this.write(Item.UB2, spec.getUb2());
        }
        if (spec.getTsig() != 1.0) {
            this.write(Item.TSIG, spec.getTsig());
        }
        if (spec.getPc() != 0.12) {
            this.write(Item.PC, spec.getPc());
        }
        if (spec.getPcr() != 0.95) {
            this.write(Item.PCR, spec.getPcr());
        }
    }

    private void write(ArimaSpec spec) {
        if (spec == null) {
            return;
        }
        this.write(Item.IMEAN, spec.isMean() ? 1 : 0);
        this.write(Item.P, spec.getP());
        this.write(Item.D, spec.getD());
        this.write(Item.Q, spec.getQ());
        this.write(Item.BP, spec.getBP());
        this.write(Item.BD, spec.getBD());
        this.write(Item.BQ, spec.getBQ());
        if (spec.hasFreeParameters()) {
            this.write(Item.PHI, Item.JPR, spec.getPhi());
            this.write(Item.BPHI, Item.JPS, spec.getBPhi());
            this.write(Item.TH, Item.JQR, spec.getTheta());
            this.write(Item.BTH, Item.JQS, spec.getBTheta());
        } else {
            this.write(Item.INIT, 2);
            this.write(Item.PHI, spec.getPhi());
            this.write(Item.BPHI, spec.getBPhi());
            this.write(Item.TH, spec.getTheta());
            this.write(Item.BTH, spec.getBTheta());
        }
    }

    private void write(Item p, Parameter[] parameter) {
        if (parameter == null || parameter.length == 0) {
            return;
        }
        for (int i = 0; i < parameter.length; ++i) {
            this.write(p, i + 1, parameter[i].getValue());
        }
    }

    private void write(Item p, Item f, Parameter[] parameter) {
        int i;
        if (parameter == null || parameter.length == 0) {
            return;
        }
        for (i = 0; i < parameter.length; ++i) {
            this.write(p, i + 1, parameter[i].getValue());
        }
        for (i = 0; i < parameter.length; ++i) {
            this.write(f, i + 1, 1);
        }
    }

    private void write(TransformSpec spec) {
        if (spec == null) {
            return;
        }
        int lam = 0;
        switch (spec.getFunction()) {
            case Auto: {
                lam = -1;
                break;
            }
            case None: {
                lam = 1;
            }
        }
        this.m_builder.append((Object)Item.LAM).append('=').append(lam).append(this.m_sep);
        if (spec.getFct() != 0.95) {
            this.write(Item.FCT, spec.getFct());
        }
    }

    public static enum Format {
        Demetra,
        TramoSeats;

    }

    private static enum Item {
        MQ,
        LAM,
        FCT,
        INIT,
        IMEAN,
        P,
        D,
        Q,
        BP,
        BD,
        BQ,
        PHI,
        BPHI,
        TH,
        BTH,
        JPR,
        JPS,
        JQR,
        JQS,
        INIC,
        IDIF,
        CANCEL,
        UB1,
        UB2,
        TSIG,
        PC,
        PCR,
        ITRAD,
        IEAST,
        IDUR,
        IATIP,
        AIO,
        VA,
        IMVX,
        INT1,
        INT2,
        TOL,
        UBP,
        SEATS,
        NOADMISS,
        EPSPHI,
        RMOD,
        IREG,
        IUSER,
        NSER,
        INTERP,
        pos,
        type;

    }
}

