/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.html;

import ec.tss.Ts;
import ec.tss.html.HtmlFragment;
import ec.tss.html.IHtmlElement;
import ec.tss.html.implementation.HtmlArima;
import ec.tss.html.implementation.HtmlLikelihood;
import ec.tss.html.implementation.HtmlModelStatistics;
import ec.tss.html.implementation.HtmlSarimaModel;
import ec.tss.html.implementation.HtmlSingleTsData;
import ec.tstoolkit.arima.IArimaModel;
import ec.tstoolkit.arima.estimation.LikelihoodStatistics;
import ec.tstoolkit.modelling.arima.ModelStatistics;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.timeseries.simplets.TsData;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class HtmlConverters {
    private static HtmlConverters instance_ = DefaultHtmlConverters.access$000();

    public abstract <T> void register(Class<T> var1, IHtmlConverter<T> var2);

    public abstract <T> void unregister(Class<T> var1);

    public abstract IHtmlElement convert(Object var1);

    public static HtmlConverters getDefault() {
        return instance_;
    }

    public static void setDefault(HtmlConverters cv) {
        instance_ = cv;
    }

    private static class DefaultHtmlConverters
    extends HtmlConverters {
        private static final Map<Class, IHtmlConverter> converters = new LinkedHashMap<Class, IHtmlConverter>();

        private DefaultHtmlConverters() {
        }

        private static HtmlConverters create() {
            DefaultHtmlConverters cv = new DefaultHtmlConverters();
            cv.register(TsData.class, obj -> new HtmlSingleTsData((TsData)obj, null));
            cv.register(Ts.class, obj -> {
                String name = obj.getName();
                TsData s = obj.getTsData();
                if (s != null) {
                    return new HtmlSingleTsData(s, name);
                }
                return new HtmlFragment(name + ": no data");
            });
            cv.register(IArimaModel.class, HtmlArima::new);
            cv.register(SarimaModel.class, HtmlSarimaModel::new);
            cv.register(LikelihoodStatistics.class, HtmlLikelihood::new);
            cv.register(ModelStatistics.class, HtmlModelStatistics::new);
            return cv;
        }

        @Override
        public <T> void register(Class<T> tclass, IHtmlConverter<T> converter) {
            converters.put(tclass, converter);
        }

        @Override
        public <T> void unregister(Class<T> tclass) {
            converters.remove(tclass);
        }

        @Override
        public IHtmlElement convert(Object obj) {
            if (obj == null) {
                return new HtmlFragment("");
            }
            IHtmlConverter cv = converters.get(obj.getClass());
            if (cv == null) {
                for (Class c : converters.keySet()) {
                    if (!c.isInstance(obj)) continue;
                    cv = converters.get(c);
                    break;
                }
            }
            if (cv != null) {
                return cv.convert(obj);
            }
            return new HtmlFragment(obj.toString());
        }

        static /* synthetic */ HtmlConverters access$000() {
            return DefaultHtmlConverters.create();
        }
    }

    @FunctionalInterface
    public static interface IHtmlConverter<T> {
        public IHtmlElement convert(T var1);
    }
}

