/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.html;

import com.google.common.base.Strings;
import ec.tss.html.CssStyle;
import ec.tss.html.HtmlClass;
import ec.tss.html.HtmlStyle;
import ec.tss.html.HtmlTable;
import ec.tss.html.HtmlTableCell;
import ec.tss.html.HtmlTableHeader;
import ec.tss.html.HtmlTag;
import ec.tss.html.IHtmlElement;
import ec.tstoolkit.utilities.Arrays2;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;

public class HtmlStream
implements Closeable {
    public final Writer writer;
    private static final String CLASS_ATTR = "class";
    private static final String STYLE_ATTR = "style";
    private static final String WIDTH_ATTR = "width";
    private static final String BORDER_ATTR = "border";
    private static final String COLSPAN_ATTR = "colspan";
    private static final String ROWSPAN_ATTR = "rowspan";
    private static final String BGCOLOR_ATTR = "bgcolor";

    public HtmlStream(Writer writer) {
        this.writer = writer;
    }

    public void open() throws IOException {
        this.writer.append("<html><body>");
    }

    @Override
    public void close() throws IOException {
        this.writer.append("</body></html>");
    }

    public HtmlStream newLine() throws IOException {
        this.writer.write("<br/>");
        return this;
    }

    public HtmlStream newLines(int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            this.newLine();
        }
        return this;
    }

    public HtmlStream open(HtmlTag tag) throws IOException {
        return this.open(tag, HtmlClass.NO_CLASS);
    }

    public HtmlStream open(HtmlTag tag, HtmlClass classNames) throws IOException {
        this.writeBeg();
        this.writeTag(tag);
        this.writeAttr(CLASS_ATTR, classNames, HtmlClass::isEmpty);
        this.writeEnd();
        return this;
    }

    public HtmlStream close(HtmlTag tag) throws IOException {
        this.writeBeg();
        this.writeSlash();
        this.writeTag(tag);
        this.writeEnd();
        return this;
    }

    public HtmlStream write(HtmlTag tag) throws IOException {
        this.writeBeg();
        this.writeTag(tag);
        this.writeSlash();
        this.writeEnd();
        return this;
    }

    public HtmlStream write(HtmlTag tag, String text) throws IOException {
        return this.open(tag).write(text).close(tag);
    }

    public HtmlStream write(HtmlTag tag, String text, HtmlClass classNames) throws IOException {
        return this.open(tag, classNames).write(text).close(tag);
    }

    public HtmlStream write(String text, HtmlClass classNames) throws IOException {
        return classNames.isEmpty() ? this.write(text) : this.write(HtmlTag.SPAN, text, classNames);
    }

    public HtmlStream write(char c) throws IOException {
        this.writer.write(c);
        return this;
    }

    public HtmlStream write(double d) throws IOException {
        this.writeText(Double.toString(d));
        return this;
    }

    public HtmlStream write(int i) throws IOException {
        this.writeText(Integer.toString(i));
        return this;
    }

    public HtmlStream write(String txt) throws IOException {
        this.writeText(txt);
        return this;
    }

    public HtmlStream open(HtmlTable table) throws IOException {
        this.writeBeg();
        this.writeTag(HtmlTag.TABLE);
        this.writeEnd();
        return this;
    }

    public HtmlStream write(HtmlTableCell cell) throws IOException {
        this.writeBeg();
        this.writeTag(HtmlTag.TABLECELL);
        this.writeAttr(COLSPAN_ATTR, cell.colspan, HtmlStream::isDefaultSpan);
        this.writeAttr(ROWSPAN_ATTR, cell.rowspan, HtmlStream::isDefaultSpan);
        this.writeAttr(CLASS_ATTR, cell.getClassnames(), HtmlClass::isEmpty);
        this.writeStyleAttribute(cell.styles);
        this.writeEnd();
        cell.core.write(this);
        this.writeBeg();
        this.writeSlash();
        this.writeTag(HtmlTag.TABLECELL);
        this.writeEnd();
        return this;
    }

    public HtmlStream write(HtmlTableHeader header) throws IOException {
        this.writeBeg();
        this.writeTag(HtmlTag.TABLEHEADER);
        this.writeAttr(COLSPAN_ATTR, header.colspan, HtmlStream::isDefaultSpan);
        this.writeAttr(ROWSPAN_ATTR, header.rowspan, HtmlStream::isDefaultSpan);
        this.writeAttr(CLASS_ATTR, header.getClassnames(), HtmlClass::isEmpty);
        this.writeStyleAttribute(header.styles);
        this.writeEnd();
        header.core.write(this);
        this.writeBeg();
        this.writeSlash();
        this.writeTag(HtmlTag.TABLEHEADER);
        this.writeEnd();
        return this;
    }

    public HtmlStream write(IHtmlElement obj) throws IOException {
        obj.write(this);
        return this;
    }

    @Deprecated
    public HtmlStream write(String text, HtmlStyle ... styles) throws IOException {
        if (Arrays2.isNullOrEmpty((Object[])styles)) {
            return this.write(text);
        }
        this.writer.write("<span");
        this.writeStyleAttribute(styles);
        this.writer.write(">");
        this.writeText(text);
        this.writer.write("</span>");
        return this;
    }

    @Deprecated
    public HtmlStream open(HtmlTag tag, String attrName, String attrValue) throws IOException {
        this.writeBeg();
        this.writeTag(tag);
        this.writeAttr(attrName, attrValue, String::isEmpty);
        this.writeEnd();
        return this;
    }

    @Deprecated
    public HtmlStream open(HtmlTag tag, CssStyle style) throws IOException {
        this.writeBeg();
        this.writeTag(tag);
        this.writeStyle(style);
        this.writeEnd();
        return this;
    }

    @Deprecated
    public HtmlStream open(HtmlTag tag, CssStyle style, String attrName, String attrValue) throws IOException {
        this.writeBeg();
        this.writeTag(tag);
        this.writeStyle(style);
        this.writeAttr(attrName, attrValue, String::isEmpty);
        this.writeEnd();
        return this;
    }

    @Deprecated
    public HtmlStream open(HtmlTag tag, Map<String, String> attributes) throws IOException {
        this.writeBeg();
        this.writeTag(tag);
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            this.writeAttr(entry.getKey(), entry.getValue(), String::isEmpty);
        }
        this.writeEnd();
        return this;
    }

    @Deprecated
    public HtmlStream write(HtmlTag tag, CssStyle style, String text) throws IOException {
        this.open(tag, style);
        this.writeText(text);
        this.close(tag);
        return this;
    }

    @Deprecated
    public HtmlStream write(HtmlTableCell cell, String cellBg) throws IOException {
        this.writeBeg();
        this.writeTag(HtmlTag.TABLECELL);
        this.writeAttr(COLSPAN_ATTR, cell.colspan, o -> o <= 1);
        this.writeAttr(ROWSPAN_ATTR, cell.rowspan, o -> o <= 1);
        this.writeAttr(BGCOLOR_ATTR, cellBg, Strings::isNullOrEmpty);
        this.writeAttr(CLASS_ATTR, cell.getClassnames(), HtmlClass::isEmpty);
        this.writeStyleAttribute(cell.styles);
        this.writeEnd();
        cell.core.write(this);
        this.writeBeg();
        this.writeSlash();
        this.writeTag(HtmlTag.TABLECELL);
        this.writeEnd();
        return this;
    }

    private void writeBeg() throws IOException {
        this.writer.append('<');
    }

    private void writeEnd() throws IOException {
        this.writer.append('>');
    }

    private void writeSlash() throws IOException {
        this.writer.append('/');
    }

    private void writeTag(HtmlTag tag) throws IOException {
        this.writer.append(tag.tag);
    }

    private void writeText(String text) throws IOException {
        this.writer.append(text);
    }

    private void writeStyle(CssStyle style) throws IOException {
        style.write(this);
    }

    private void writeStyleAttribute(@Nullable HtmlStyle[] styles) throws IOException {
        if (styles != null && styles.length > 0) {
            this.writeAttr(STYLE_ATTR, Stream.of(styles).map(o -> o.tag).collect(Collectors.joining("; ")), String::isEmpty);
        }
    }

    private <T> void writeAttr(String name, T value, Predicate<? super T> isDefaultValue) throws IOException {
        if (isDefaultValue.test(value)) {
            return;
        }
        this.writer.write(32);
        this.writer.write(name);
        this.writer.write("=\"");
        this.writer.write(value.toString());
        this.writer.write("\"");
    }

    private static boolean isDefaultSpan(int span) {
        return span <= 1;
    }
}

