/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.html.implementation;

import ec.tss.html.AbstractHtmlElement;
import ec.tss.html.HtmlStream;
import ec.tss.html.HtmlTable;
import ec.tss.html.HtmlTableCell;
import ec.tss.html.HtmlTag;
import ec.tstoolkit.stats.Anova;
import ec.tstoolkit.stats.StatisticalTest;
import java.io.IOException;
import java.util.List;

public class HtmlAnova
extends AbstractHtmlElement {
    private final Anova anova;
    private final String[] titles;

    public HtmlAnova(Anova anova, String[] titles) {
        this.anova = anova;
        this.titles = titles;
    }

    @Override
    public void write(HtmlStream stream) throws IOException {
        stream.open(new HtmlTable().withWidth(600));
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell("").withWidth(100));
        stream.write(new HtmlTableCell("Degrees of freedom").withWidth(100));
        stream.write(new HtmlTableCell("Sum of squares").withWidth(100));
        stream.write(new HtmlTableCell("Mean square").withWidth(100));
        stream.write(new HtmlTableCell("F value").withWidth(100));
        stream.write(new HtmlTableCell("Pr(>F)").withWidth(100));
        stream.close(HtmlTag.TABLEROW);
        List rows = this.anova.getRows();
        int idx = 0;
        for (Anova.Row row : rows) {
            stream.open(HtmlTag.TABLEROW);
            stream.write(new HtmlTableCell(this.titles != null && idx < this.titles.length ? this.titles[idx] : "").withWidth(100));
            stream.write(new HtmlTableCell(Integer.toString(row.df)).withWidth(100));
            stream.write(new HtmlTableCell(df2.format(row.ssq)).withWidth(100));
            stream.write(new HtmlTableCell(df2.format(row.mssq())).withWidth(100));
            StatisticalTest ftest = row.ftest();
            stream.write(new HtmlTableCell(df2.format(ftest.getValue())).withWidth(100));
            stream.write(new HtmlTableCell(df4.format(ftest.getPValue())).withWidth(100));
            stream.close(HtmlTag.TABLEROW);
            ++idx;
        }
        stream.close(HtmlTag.TABLE);
    }
}

