/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.html.implementation;

import ec.tss.html.AbstractHtmlElement;
import ec.tss.html.HtmlStream;
import ec.tss.html.HtmlTag;
import ec.tss.html.IHtmlElement;
import ec.tstoolkit.arima.IArimaModel;
import java.io.IOException;
import java.util.Formatter;

public class HtmlArima
extends AbstractHtmlElement
implements IHtmlElement {
    private IArimaModel m_model;
    static final String AR = "AR:   ";
    static final String D = "D:   ";
    static final String MA = "MA:   ";
    static final String VAR = "Innovation variance: ";
    static final double EPS = 1.0E-6;

    public HtmlArima(IArimaModel model) {
        this.m_model = model;
    }

    @Override
    public void write(HtmlStream stream) throws IOException {
        this.writeModel(stream);
    }

    public void writeModel(HtmlStream stream) throws IOException {
        double var;
        if (this.m_model.getStationaryARCount() > 0) {
            stream.write(AR).write(this.m_model.getStationaryAR().toString()).newLine();
        }
        if (this.m_model.getNonStationaryARCount() > 0) {
            stream.write(D).write(this.m_model.getNonStationaryAR().toString()).newLine();
        }
        if (this.m_model.getMACount() > 0) {
            stream.write(MA).write(this.m_model.getMA().toString()).newLine();
        }
        if (Math.abs((var = this.m_model.getInnovationVariance()) - 1.0) > 1.0E-6) {
            String val = new Formatter().format("%.5f", var).toString();
            stream.write(VAR).write(HtmlTag.IMPORTANT_TEXT, val).newLine();
        }
    }

    public void writeShortModel(HtmlStream stream) throws IOException {
        double var = this.m_model.getInnovationVariance();
        if (Math.abs(var - 1.0) > 1.0E-6) {
            String val = new Formatter().format("%.5f", var).toString();
            stream.write(". Innovation variance: ").write(val);
        }
    }
}

