/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.html.implementation;

import ec.satoolkit.special.StmEstimation;
import ec.tss.html.AbstractHtmlElement;
import ec.tss.html.Bootstrap4;
import ec.tss.html.HtmlStream;
import ec.tss.html.HtmlTable;
import ec.tss.html.HtmlTableCell;
import ec.tss.html.HtmlTag;
import ec.tss.html.IHtmlElement;
import ec.tstoolkit.dstats.T;
import ec.tstoolkit.eco.DiffuseConcentratedLikelihood;
import ec.tstoolkit.modelling.arima.JointRegressionTest;
import ec.tstoolkit.structural.BasicStructuralModel;
import ec.tstoolkit.structural.Component;
import ec.tstoolkit.structural.ComponentUse;
import ec.tstoolkit.structural.ModelSpecification;
import ec.tstoolkit.structural.SeasonalModel;
import ec.tstoolkit.timeseries.regression.ILengthOfPeriodVariable;
import ec.tstoolkit.timeseries.regression.IMovingHolidayVariable;
import ec.tstoolkit.timeseries.regression.IOutlierVariable;
import ec.tstoolkit.timeseries.regression.ITradingDaysVariable;
import ec.tstoolkit.timeseries.regression.ITsVariable;
import ec.tstoolkit.timeseries.regression.IUserTsVariable;
import ec.tstoolkit.timeseries.regression.InterventionVariable;
import ec.tstoolkit.timeseries.regression.Ramp;
import ec.tstoolkit.timeseries.regression.TsVariableList;
import ec.tstoolkit.timeseries.regression.TsVariableSelection;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import java.io.IOException;
import java.util.Formatter;

public class HtmlBsm
extends AbstractHtmlElement
implements IHtmlElement {
    final BasicStructuralModel bsm;
    final StmEstimation rslts;
    final TsVariableList x;

    private static boolean write(HtmlStream stream, boolean first, String cmp, ComponentUse use) throws IOException {
        if (use == ComponentUse.Unused) {
            return false;
        }
        if (!first) {
            stream.write(" + ");
        }
        if (use == ComponentUse.Free) {
            stream.write(cmp);
        } else {
            stream.write(cmp).write("(fixed)");
        }
        return true;
    }

    private static boolean write(HtmlStream stream, boolean first, String cmp, SeasonalModel use) throws IOException {
        if (use == SeasonalModel.Unused) {
            return false;
        }
        if (!first) {
            stream.write(" + ");
        }
        if (use != SeasonalModel.Fixed) {
            stream.write(cmp);
        } else {
            stream.write(cmp).write("(fixed)");
        }
        return true;
    }

    public static void writeSpec(HtmlStream stream, ModelSpecification spec) throws IOException {
        stream.write(HtmlTag.HEADER1, "Model");
        stream.newLine();
        boolean first = true;
        first = !HtmlBsm.write(stream, first, "level", spec.getLevelUse());
        first = !HtmlBsm.write(stream, first, "slope", spec.getSlopeUse()) && first;
        first = !HtmlBsm.write(stream, first, "cycle", spec.getCycleUse()) && first;
        first = !HtmlBsm.write(stream, first, "seasonal", spec.getSeasonalModel()) && first;
        HtmlBsm.write(stream, first, "noise", spec.getNoiseUse());
        stream.newLines(2);
    }

    public HtmlBsm(StmEstimation stm) {
        this.rslts = stm;
        this.bsm = stm.getModel();
        this.x = stm.getX();
    }

    @Override
    public void write(HtmlStream stream) throws IOException {
        ModelSpecification spec = this.bsm.getSpecification();
        HtmlBsm.writeSpec(stream, spec);
        this.writeLikelihood(stream);
        this.writeModel(stream);
        this.writeRegressionModel(stream);
    }

    private void writeModel(HtmlStream stream) throws IOException {
        stream.write(HtmlTag.HEADER2, "Estimated variance of the components");
        Component[] cmp = this.bsm.getComponents();
        stream.open(new HtmlTable().withWidth(300));
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell("Component").withWidth(100).withClass(Bootstrap4.FONT_WEIGHT_BOLD));
        stream.write(new HtmlTableCell("Variance").withWidth(100).withClass(Bootstrap4.FONT_WEIGHT_BOLD));
        stream.write(new HtmlTableCell("Q-Ratio").withWidth(100).withClass(Bootstrap4.FONT_WEIGHT_BOLD));
        stream.close(HtmlTag.TABLEROW);
        double sig = this.rslts.getLikelihood().getSigma();
        String fmt = sig > 10000.0 ? "%.1f" : (sig > 100.0 ? "%.2f" : (sig > 1.0 ? "%.4f" : "%.6f"));
        for (int i = 0; i < cmp.length; ++i) {
            double var = this.bsm.getVariance(cmp[i]);
            stream.open(HtmlTag.TABLEROW);
            stream.write(new HtmlTableCell(cmp[i].name()));
            stream.write(new HtmlTableCell(new Formatter().format(fmt, sig * var).toString()));
            stream.write(new HtmlTableCell(new Formatter().format("%.4f", var).toString()));
            stream.close(HtmlTag.TABLEROW);
        }
        stream.close(HtmlTag.TABLE);
        if (this.bsm.getSpecification().hasCycle()) {
            stream.newLine();
            stream.write(HtmlTag.HEADER3, "Cycle");
            stream.write("Average length (in years): ");
            double len = this.bsm.getCyclicalPeriod() / (double)this.bsm.freq;
            stream.write(new Formatter().format("%.1f", len).toString());
            stream.newLine();
            stream.write("Dumping factor: ");
            stream.write(new Formatter().format("%.3f", this.bsm.getCyclicalDumpingFactor()).toString());
        }
        stream.write(HtmlTag.LINEBREAK);
    }

    private void writeLikelihood(HtmlStream stream) throws IOException {
        stream.write(HtmlTag.HEADER2, "Diffuse likelihood statistics");
        DiffuseConcentratedLikelihood ll = this.rslts.getLikelihood();
        stream.write("Number of effective observations = ").write(ll.getN() - ll.getD()).newLine();
        int np = this.bsm.getSpecification().getParametersCount();
        stream.write("Number of estimated parameters = ").write(np + 1 + (ll.getB() != null ? ll.getB().length : 0)).newLines(2);
        stream.write("Diffuse likelihood = ").write(ll.getLogLikelihood()).newLine();
        stream.write("\"Uncorrected\" likelihood = ").write(ll.getUncorrectedLogLikelihood()).newLine();
        stream.write("AIC = ").write(ll.AIC(np)).newLine();
        stream.newLines(2);
        stream.write(HtmlTag.LINEBREAK);
    }

    private void writeRegressionModel(HtmlStream stream) throws IOException {
        if (!this.x.isEmpty()) {
            stream.write(HtmlTag.HEADER2, "Regression model");
            stream.newLine();
            this.writeRegressionItems(stream, "Trading days", ITradingDaysVariable.class);
            this.writeRegressionItems(stream, "Leap year", ILengthOfPeriodVariable.class);
            this.writeRegressionItems(stream, "Moving holidays", IMovingHolidayVariable.class);
            this.writeRegressionItems(stream, "Outliers", IOutlierVariable.class);
            this.writeRegressionItems(stream, "Ramps", Ramp.class);
            this.writeRegressionItems(stream, "Intervention variables", InterventionVariable.class);
            this.writeRegressionItems(stream, "User variables", IUserTsVariable.class);
            stream.write(HtmlTag.LINEBREAK);
        }
    }

    private <V extends ITsVariable> void writeRegressionItems(HtmlStream stream, String title, Class<V> tclass) throws IOException {
        TsFrequency context = TsFrequency.valueOf((int)this.bsm.freq);
        TsVariableSelection regs = this.x.selectCompatible(tclass);
        if (regs.isEmpty()) {
            return;
        }
        T t = new T();
        DiffuseConcentratedLikelihood ll = this.rslts.getLikelihood();
        int nhp = this.bsm.getCmpsCount();
        t.setDegreesofFreedom(ll.getDegreesOfFreedom(true, nhp));
        double[] b = ll.getB();
        boolean simple = true;
        for (TsVariableSelection.Item reg : regs.elements()) {
            if (reg.variable.getDim() <= 1) continue;
            simple = false;
            break;
        }
        if (!simple) {
            for (TsVariableSelection.Item reg : regs.elements()) {
                stream.write(HtmlTag.HEADER3, reg.variable.getDescription(context));
                stream.open(new HtmlTable().withWidth(400));
                stream.open(HtmlTag.TABLEROW);
                stream.write(new HtmlTableCell("").withWidth(100));
                stream.write(new HtmlTableCell("Coefficients").withWidth(100).withClass(Bootstrap4.FONT_WEIGHT_BOLD));
                stream.write(new HtmlTableCell("T-Stat").withWidth(100).withClass(Bootstrap4.FONT_WEIGHT_BOLD));
                stream.write(new HtmlTableCell("P[|T| &gt t]").withWidth(100).withClass(Bootstrap4.FONT_WEIGHT_BOLD));
                stream.close(HtmlTag.TABLEROW);
                for (int j = 0; j < reg.variable.getDim(); ++j) {
                    stream.open(HtmlTag.TABLEROW);
                    if (reg.variable.getDim() > 1) {
                        stream.write(new HtmlTableCell(reg.variable.getItemDescription(j, context)).withWidth(100));
                    } else {
                        stream.write(new HtmlTableCell("").withWidth(100));
                    }
                    stream.write(new HtmlTableCell(df4.format(b[j + reg.position])).withWidth(100));
                    double tval = ll.getTStat(j + reg.position, true, nhp);
                    stream.write(new HtmlTableCell(HtmlBsm.formatT(tval)).withWidth(100));
                    double prob = 1.0 - t.getProbabilityForInterval(-tval, tval);
                    stream.write(new HtmlTableCell(df4.format(prob)).withWidth(100));
                    stream.close(HtmlTag.TABLEROW);
                }
                stream.close(HtmlTag.TABLE);
                stream.newLine();
                int nvars = reg.variable.getDim();
                if (nvars <= 1) continue;
                JointRegressionTest jtest = new JointRegressionTest(0.05);
                boolean ok = jtest.accept(ll, nhp, reg.position, nvars, null);
                StringBuilder builder = new StringBuilder();
                builder.append("Joint F-Test = ").append(df2.format(jtest.getTest().getValue())).append(" (").append(df4.format(jtest.getTest().getPValue())).append(')');
                if (!ok) {
                    stream.write(HtmlTag.IMPORTANT_TEXT, builder.toString(), Bootstrap4.TEXT_DANGER);
                } else {
                    stream.write(HtmlTag.EMPHASIZED_TEXT, builder.toString());
                }
                stream.newLines(2);
            }
        } else {
            stream.write(HtmlTag.HEADER3, title);
            stream.open(new HtmlTable().withWidth(400));
            stream.open(HtmlTag.TABLEROW);
            stream.write(new HtmlTableCell("").withWidth(100));
            stream.write(new HtmlTableCell("Coefficients").withWidth(100).withClass(Bootstrap4.FONT_WEIGHT_BOLD));
            stream.write(new HtmlTableCell("T-Stat").withWidth(100).withClass(Bootstrap4.FONT_WEIGHT_BOLD));
            stream.write(new HtmlTableCell("P[|T| &gt t]").withWidth(100).withClass(Bootstrap4.FONT_WEIGHT_BOLD));
            stream.close(HtmlTag.TABLEROW);
            for (TsVariableSelection.Item reg : regs.elements()) {
                stream.open(HtmlTag.TABLEROW);
                stream.write(new HtmlTableCell(reg.variable.getDescription(context)).withWidth(100));
                stream.write(new HtmlTableCell(df4.format(b[reg.position])).withWidth(100));
                double tval = ll.getTStat(reg.position, true, nhp);
                stream.write(new HtmlTableCell(HtmlBsm.formatT(tval)).withWidth(100));
                double prob = 1.0 - t.getProbabilityForInterval(-tval, tval);
                stream.write(new HtmlTableCell(df4.format(prob)).withWidth(100));
                stream.close(HtmlTag.TABLEROW);
            }
            stream.close(HtmlTag.TABLE);
            stream.newLines(2);
        }
    }
}

