/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.html.implementation;

import ec.tss.html.AbstractHtmlElement;
import ec.tss.html.HtmlStream;
import ec.tss.html.HtmlTag;
import ec.tstoolkit.data.DescriptiveStatistics;
import java.io.IOException;

public class HtmlDescriptiveStatistics
extends AbstractHtmlElement {
    private final String header;
    private final DescriptiveStatistics stats;
    private final boolean summary;

    public HtmlDescriptiveStatistics(DescriptiveStatistics stats, String header, boolean summary) {
        this.stats = stats;
        this.header = header;
        this.summary = summary;
    }

    @Override
    public void write(HtmlStream stream) throws IOException {
        if (this.header != null) {
            stream.write(HtmlTag.HEADER1, this.header).newLine();
        }
        if (this.summary) {
            this.writeSummary(stream);
        } else {
            this.writeComplete(stream);
        }
    }

    private void writeSummary(HtmlStream stream) throws IOException {
        stream.write("Average: ").write(df4.format(this.stats.getAverage())).newLine();
        stream.write("Standard deviation: ").write(df4.format(this.stats.getStdev())).newLine();
        stream.write("Min: ").write(df4.format(this.stats.getMin())).newLine();
        stream.write("Max: ").write(df4.format(this.stats.getMax())).newLine();
    }

    private void writeComplete(HtmlStream stream) throws IOException {
        this.writeSummary(stream);
    }
}

