/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.html.implementation;

import ec.tss.html.AbstractHtmlElement;
import ec.tss.html.Bootstrap4;
import ec.tss.html.HtmlStream;
import ec.tss.html.HtmlTag;
import ec.tss.html.IHtmlElement;
import ec.tstoolkit.algorithm.ProcDiagnostic;
import ec.tstoolkit.algorithm.ProcQuality;
import ec.tstoolkit.information.Information;
import ec.tstoolkit.information.InformationSet;
import java.io.IOException;
import java.util.List;

public class HtmlDiagnosticSummary
extends AbstractHtmlElement
implements IHtmlElement {
    private InformationSet diags_;

    public HtmlDiagnosticSummary(InformationSet diags) {
        this.diags_ = diags;
    }

    @Override
    public void write(HtmlStream stream) throws IOException {
        if (this.diags_ != null) {
            this.writeSummary(stream);
        }
    }

    public void writeSummary(HtmlStream stream) throws IOException {
        stream.write(HtmlTag.IMPORTANT_TEXT, "summary").newLine();
        this.writeQuality(stream, null, ProcDiagnostic.summary((InformationSet)this.diags_), Double.NaN);
        stream.newLine().newLine();
        List subsets = this.diags_.select(InformationSet.class);
        for (Information subset : subsets) {
            this.writeDiagnostic(stream, subset.name, (InformationSet)subset.value);
        }
    }

    private void writeDiagnostic(HtmlStream stream, String name, InformationSet diags) throws IOException {
        stream.write(HtmlTag.IMPORTANT_TEXT, name).newLine();
        List items = diags.select(ProcDiagnostic.class);
        for (Information item : items) {
            ProcDiagnostic diag = (ProcDiagnostic)item.value;
            this.writeQuality(stream, item.name, diag.quality, diag.value);
            stream.newLine();
        }
        stream.newLine();
    }

    private void writeQuality(HtmlStream stream, String test, ProcQuality q, double val) throws IOException {
        if (q != ProcQuality.Undefined) {
            if (test != null) {
                stream.write("   " + test + ": ");
            }
            switch (q) {
                case Error: {
                    stream.write(HtmlTag.IMPORTANT_TEXT, "Error" + (!Double.isNaN(val) ? " (" + df3.format(val) + ")" : ""), Bootstrap4.TEXT_INFO);
                    break;
                }
                case Severe: {
                    stream.write(HtmlTag.IMPORTANT_TEXT, "Severe" + (!Double.isNaN(val) ? " (" + df3.format(val) + ")" : ""), Bootstrap4.TEXT_DANGER);
                    break;
                }
                case Bad: {
                    stream.write("Bad" + (!Double.isNaN(val) ? " (" + df3.format(val) + ")" : ""), Bootstrap4.TEXT_DANGER);
                    break;
                }
                case Uncertain: {
                    stream.write("Uncertain" + (!Double.isNaN(val) ? " (" + df3.format(val) + ")" : ""), Bootstrap4.TEXT_WARNING);
                    break;
                }
                case Good: {
                    stream.write("Good" + (!Double.isNaN(val) ? " (" + df3.format(val) + ")" : ""), Bootstrap4.TEXT_SUCCESS);
                }
            }
        }
    }
}

