/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.html.implementation;

import ec.tss.html.AbstractHtmlElement;
import ec.tss.html.HtmlStream;
import ec.tss.html.HtmlTable;
import ec.tss.html.HtmlTableCell;
import ec.tss.html.HtmlTag;
import ec.tss.html.IHtmlElement;
import ec.tstoolkit.timeseries.analysis.Differenciation;
import ec.tstoolkit.timeseries.simplets.TsData;
import java.io.IOException;

public class HtmlDifference
extends AbstractHtmlElement
implements IHtmlElement {
    private String[] names_ = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};
    private Differenciation diff_;
    private Differenciation.DifferentiationType type_;
    private int years_;
    private double limit_;

    public HtmlDifference(Differenciation diff, Differenciation.DifferentiationType type, int years, double limit) {
        this.diff_ = diff;
        this.type_ = type;
        this.years_ = years;
        this.limit_ = limit;
    }

    @Override
    public void write(HtmlStream stream) throws IOException {
        this.writeDifference(stream);
    }

    private void writeDifference(HtmlStream stream) throws IOException {
        stream.open(new HtmlTable().withWidth(630));
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell("").withWidth(150));
        for (String names_1 : this.names_) {
            stream.write(new HtmlTableCell(names_1).withWidth(40));
        }
        stream.close(HtmlTag.TABLEROW);
        TsData data = this.diff_.getDifference(this.type_);
        TsData new_ = this.diff_.getNew();
        TsData old_ = this.diff_.getOld();
        int year = data.getDomain().getEnd().getYear() - this.years_;
        for (int i = 0; i < this.years_; ++i) {
            int j;
            stream.open(HtmlTag.TABLEROW);
            stream.write(new HtmlTableCell(Integer.toString(year + i) + " new"));
            for (j = 0; j < 12; ++j) {
                stream.write(new HtmlTableCell(Double.toString(new_.get(j + i * 12))));
            }
            stream.close(HtmlTag.TABLEROW);
            stream.open(HtmlTag.TABLEROW);
            stream.write(new HtmlTableCell(Integer.toString(year + i) + " old"));
            for (j = 0; j < 12; ++j) {
                stream.write(new HtmlTableCell(Double.toString(old_.get(j + i * 12))));
            }
            stream.close(HtmlTag.TABLEROW);
            stream.open(HtmlTag.TABLEROW);
            stream.write(new HtmlTableCell(Integer.toString(year + i) + " diff"));
            block8: for (j = 0; j < 12; ++j) {
                switch (this.type_) {
                    case Difference: {
                        stream.write(new HtmlTableCell(dg2.format(data.get(j + i * 12))).withWidth(100));
                        continue block8;
                    }
                    case Percentage: {
                        stream.write(new HtmlTableCell(df2.format(data.get(j + i * 12)) + "%").withWidth(100));
                    }
                }
            }
            stream.close(HtmlTag.TABLEROW);
        }
    }
}

