/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.html.implementation;

import ec.tss.html.AbstractHtmlElement;
import ec.tss.html.Bootstrap4;
import ec.tss.html.HtmlClass;
import ec.tss.html.HtmlStream;
import ec.tss.html.HtmlTable;
import ec.tss.html.HtmlTableCell;
import ec.tss.html.HtmlTableHeader;
import ec.tss.html.HtmlTag;
import ec.tss.html.IHtmlElement;
import ec.tstoolkit.arima.estimation.RegArimaEstimation;
import ec.tstoolkit.arima.special.GeneralizedAirlineModel;
import java.io.IOException;

public class HtmlGeneralizedAirline
extends AbstractHtmlElement
implements IHtmlElement {
    private final RegArimaEstimation<GeneralizedAirlineModel>[] models;
    private final int best;
    private final boolean decomp;

    public HtmlGeneralizedAirline(RegArimaEstimation<GeneralizedAirlineModel>[] models, int best, boolean decomp) {
        this.models = models;
        this.best = best;
        this.decomp = decomp;
    }

    @Override
    public void write(HtmlStream stream) throws IOException {
        stream.open(new HtmlTable().withWidth(500));
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableHeader("Model").withWidth(100));
        stream.write(new HtmlTableHeader("LogLikelihood").withWidth(80));
        int freq = ((GeneralizedAirlineModel)this.models[0].model.getArima()).getFrequency();
        for (int i = 0; i < 4; ++i) {
            StringBuilder builder = new StringBuilder();
            builder.append("p(").append(i + 1).append(')');
            stream.write(new HtmlTableHeader(builder.toString()).withWidth(80));
        }
        stream.close(HtmlTag.TABLEROW);
        int icur = 0;
        for (int i = 0; i < this.models.length; ++i) {
            stream.open(HtmlTag.TABLEROW);
            HtmlClass style = icur++ == this.best ? Bootstrap4.FONT_WEIGHT_BOLD : HtmlClass.NO_CLASS;
            stream.write(new HtmlTableCell(((GeneralizedAirlineModel)this.models[i].model.getArima()).getModelType()).withWidth(100).withClass(style));
            stream.write(new HtmlTableCell(df4.format(this.models[i].likelihood.getLogLikelihood())).withWidth(80).withClass(style));
            double[] p = ((GeneralizedAirlineModel)this.models[i].model.getArima()).getCoefficients();
            for (int j = 0; j < p.length; ++j) {
                stream.write(new HtmlTableCell(df4.format(j > 0 ? Math.pow(p[j], freq) : p[j])).withWidth(80).withClass(style));
            }
            stream.close(HtmlTag.TABLEROW);
        }
        stream.close(HtmlTag.TABLE).newLine();
        if (!this.decomp) {
            stream.write(HtmlTag.IMPORTANT_TEXT, "Non decomposable model", Bootstrap4.TEXT_DANGER);
            stream.newLine();
        }
    }
}

