/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.html.implementation;

import ec.tss.html.AbstractHtmlElement;
import ec.tss.html.Bootstrap4;
import ec.tss.html.HtmlFragment;
import ec.tss.html.HtmlStream;
import ec.tss.html.HtmlTable;
import ec.tss.html.HtmlTableCell;
import ec.tss.html.HtmlTag;
import ec.tss.html.IHtmlElement;
import ec.tstoolkit.Parameter;
import ec.tstoolkit.information.InformationSet;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class HtmlInformationSet
extends AbstractHtmlElement {
    public static final Map<Class, IHtmlFormatter> map_ = new HashMap<Class, IHtmlFormatter>();
    public static final IHtmlFormatter defFormatter = new IHtmlFormatter(){

        public IHtmlElement format(Object t) {
            if (t instanceof Object[]) {
                Object[] a = (Object[])t;
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < a.length; ++i) {
                    builder.append(a[i]);
                    if (i == a.length - 1) continue;
                    builder.append(", ");
                }
                return new HtmlFragment(builder.toString());
            }
            return new HtmlFragment(t.toString());
        }
    };
    private final InformationSet info_;

    public static synchronized <T> void register(Class<T> tclass, IHtmlFormatter<T> fmt) {
        map_.put(tclass, fmt);
    }

    public HtmlInformationSet(InformationSet info) {
        this.info_ = info;
    }

    @Override
    public void write(HtmlStream stream) throws IOException {
        LinkedHashMap dictionary = new LinkedHashMap();
        this.info_.fillDictionary(null, dictionary);
        stream.open(new HtmlTable().withWidth(600));
        for (Map.Entry entry : dictionary.entrySet()) {
            IHtmlFormatter fmt = map_.get(entry.getValue());
            if (fmt == null) {
                fmt = defFormatter;
            }
            String s = (String)entry.getKey();
            IHtmlElement item = fmt.format(this.info_.search(s, Object.class));
            stream.open(HtmlTag.TABLEROW);
            stream.write(new HtmlTableCell(s).withWidth(200).withClass(Bootstrap4.TEXT_LEFT));
            stream.write(new HtmlTableCell(item).withWidth(400).withClass(Bootstrap4.TEXT_LEFT));
            stream.close(HtmlTag.TABLEROW);
        }
        stream.close(HtmlTag.TABLE).newLine();
    }

    static {
        HtmlInformationSet.register(String[].class, new IHtmlFormatter<String[]>(){

            @Override
            public IHtmlElement format(String[] t) {
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < t.length; ++i) {
                    builder.append(t[i]);
                    if (i == t.length - 1) continue;
                    builder.append(", ");
                }
                return new HtmlFragment(builder.toString());
            }
        });
        HtmlInformationSet.register(int[].class, new IHtmlFormatter<int[]>(){

            @Override
            public IHtmlElement format(int[] t) {
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < t.length; ++i) {
                    builder.append(t[i]);
                    if (i == t.length - 1) continue;
                    builder.append(", ");
                }
                return new HtmlFragment(builder.toString());
            }
        });
        HtmlInformationSet.register(double[].class, new IHtmlFormatter<double[]>(){

            @Override
            public IHtmlElement format(double[] t) {
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < t.length; ++i) {
                    builder.append(t[i]);
                    if (i == t.length - 1) continue;
                    builder.append(", ");
                }
                return new HtmlFragment(builder.toString());
            }
        });
        HtmlInformationSet.register(Parameter[].class, new IHtmlFormatter<Parameter[]>(){

            @Override
            public IHtmlElement format(Parameter[] t) {
                StringBuilder builder = new StringBuilder();
                if (Parameter.isDefault((Parameter[])t)) {
                    builder.append(t.length).append(" coeff.");
                } else {
                    for (int i = 0; i < t.length; ++i) {
                        builder.append(t[i]);
                        if (i == t.length - 1) continue;
                        builder.append(", ");
                    }
                }
                return new HtmlFragment(builder.toString());
            }
        });
    }

    public static interface IHtmlFormatter<T> {
        public IHtmlElement format(T var1);
    }
}

