/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.html.implementation;

import ec.tss.html.AbstractHtmlElement;
import ec.tss.html.HtmlStream;
import ec.tss.html.IHtmlElement;
import ec.tstoolkit.arima.estimation.LikelihoodStatistics;
import java.io.IOException;

public class HtmlLikelihood
extends AbstractHtmlElement
implements IHtmlElement {
    private final LikelihoodStatistics stats;

    public HtmlLikelihood(LikelihoodStatistics stats) {
        this.stats = stats;
    }

    @Override
    public void write(HtmlStream stream) throws IOException {
        if (this.stats.missingCount > 0) {
            stream.write("Number of missing observations = ").write(this.stats.missingCount).newLine();
        }
        stream.write("Number of effective observations = ").write(this.stats.effectiveObservationsCount).newLine();
        stream.write("Number of estimated parameters = ").write(this.stats.estimatedParametersCount).newLines(2);
        stream.write("Loglikelihood = ").write(this.stats.logLikelihood).newLine();
        if (this.stats.transformationAdjustment != 0.0 && !Double.isNaN(this.stats.transformationAdjustment)) {
            stream.write("Transformation adjustment = ").write(this.stats.transformationAdjustment).newLine();
            stream.write("Adjusted loglikelihood = ").write(this.stats.adjustedLogLikelihood).newLines(2);
        }
        double stde = Math.sqrt(this.stats.SsqErr / (double)this.stats.effectiveObservationsCount);
        stream.write("Standard error of the regression (ML estimate) = ").write(stde).newLine();
        stream.write("AIC = ").write(this.stats.AIC).newLine();
        stream.write("AICC = ").write(this.stats.AICC).newLine();
        stream.write("BIC (corrected for length) = ").write(this.stats.BICC).newLine();
    }
}

