/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.html.implementation;

import ec.tss.html.AbstractHtmlElement;
import ec.tss.html.Bootstrap4;
import ec.tss.html.HtmlClass;
import ec.tss.html.HtmlStream;
import ec.tss.html.HtmlTable;
import ec.tss.html.HtmlTableCell;
import ec.tss.html.HtmlTableHeader;
import ec.tss.html.HtmlTag;
import ec.tss.html.IHtmlElement;
import ec.tstoolkit.arima.special.MixedAirlineMonitor;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.List;

public class HtmlMixedAirline
extends AbstractHtmlElement
implements IHtmlElement {
    private List<MixedAirlineMonitor.MixedEstimation> models;
    private int best;
    private DecimalFormat df4 = new DecimalFormat("0.0000");

    public HtmlMixedAirline(List<MixedAirlineMonitor.MixedEstimation> models, int best) {
        this.models = models;
        this.best = best;
    }

    @Override
    public void write(HtmlStream stream) throws IOException {
        stream.open(new HtmlTable().withWidth(500));
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableHeader("Model"));
        stream.write(new HtmlTableHeader("LogLikelihood"));
        stream.write(new HtmlTableHeader("Theta"));
        stream.write(new HtmlTableHeader("BTheta"));
        stream.write(new HtmlTableHeader("Noise"));
        stream.close(HtmlTag.TABLEROW);
        int icur = 0;
        for (MixedAirlineMonitor.MixedEstimation cur : this.models) {
            stream.open(HtmlTag.TABLEROW);
            HtmlClass style = icur++ == this.best ? Bootstrap4.FONT_WEIGHT_BOLD : HtmlClass.NO_CLASS;
            stream.write(new HtmlTableCell(cur.model.toString()).withWidth(100).withClass(style));
            stream.write(new HtmlTableCell(this.df4.format(cur.ll.getLogLikelihood())).withWidth(100).withClass(style));
            stream.write(new HtmlTableCell(this.df4.format(cur.model.getTheta())).withWidth(100).withClass(style));
            stream.write(new HtmlTableCell(this.df4.format(cur.model.getBTheta())).withWidth(100).withClass(style));
            stream.write(new HtmlTableCell(this.df4.format(cur.model.getNoisyPeriodsVariance())).withWidth(100).withClass(style));
            stream.close(HtmlTag.TABLEROW);
        }
        stream.close(HtmlTag.TABLE).newLine();
    }
}

