/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.html.implementation;

import ec.satoolkit.ComponentDescriptor;
import ec.tss.html.AbstractHtmlElement;
import ec.tss.html.HtmlStream;
import ec.tss.html.HtmlTable;
import ec.tss.html.HtmlTableCell;
import ec.tss.html.HtmlTableHeader;
import ec.tss.html.HtmlTag;
import ec.tstoolkit.arima.ArimaException;
import ec.tstoolkit.arima.ArimaModel;
import ec.tstoolkit.arima.LinearModel;
import ec.tstoolkit.maths.matrices.MatrixException;
import ec.tstoolkit.ucarima.WienerKolmogorovEstimators;
import java.io.IOException;

public class HtmlModelBasedRevisionsAnalysis
extends AbstractHtmlElement {
    private final WienerKolmogorovEstimators estimators_;
    private final ComponentDescriptor[] cmps_;
    private final int freq_;

    public HtmlModelBasedRevisionsAnalysis(int freq, WienerKolmogorovEstimators estimators, ComponentDescriptor[] cmps) {
        this.freq_ = freq;
        this.estimators_ = estimators;
        this.cmps_ = cmps;
    }

    @Override
    public void write(HtmlStream stream) throws IOException {
        this.errorAutocorrelations(stream);
        this.revisionErrorVariance(stream);
    }

    private void revisionErrorVariance(HtmlStream stream) throws IOException {
        int i;
        stream.write(HtmlTag.HEADER1, "Revision errors").newLine();
        stream.write(HtmlTag.EMPHASIZED_TEXT, "Percentage reduction in the standard error of the revision after additional years (comparison with concurrent estimators)").newLine();
        stream.open(new HtmlTable().withWidth(600));
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableHeader("After..."));
        for (i = 1; i <= 5; ++i) {
            stream.write(new HtmlTableHeader(Integer.toString(i) + (i == 1 ? " year" : " years")));
        }
        stream.close(HtmlTag.TABLEROW);
        for (i = 0; i < this.cmps_.length; ++i) {
            ComponentDescriptor desc = this.cmps_[i];
            if (!desc.lowFrequency || this.estimators_.getUcarimaModel().getComponent(desc.cmp).isNull()) continue;
            try {
                double[] v = this.estimators_.revisionVariance(desc.cmp, desc.signal, 0, this.freq_ * 5 + 1);
                stream.open(HtmlTag.TABLEROW);
                stream.write(new HtmlTableCell(desc.name).withWidth(100));
                for (int j = 1; j <= 5; ++j) {
                    stream.write(new HtmlTableCell(pc2.format(1.0 - Math.sqrt(v[this.freq_ * j] / v[0]))).withWidth(100));
                }
                stream.close(HtmlTag.TABLEROW);
                continue;
            }
            catch (ArimaException | MatrixException | IOException throwable) {
                // empty catch block
            }
        }
        stream.close(HtmlTag.TABLE);
        stream.newLine();
        stream.write(HtmlTag.LINEBREAK);
    }

    private void errorAutocorrelations(HtmlStream stream) throws IOException {
        stream.write(HtmlTag.HEADER1, "Auto-correlations of the errors").newLine();
        for (int i = 0; i < this.cmps_.length; ++i) {
            if (!this.cmps_[i].lowFrequency) continue;
            if (!this.estimators_.getUcarimaModel().getComponent(this.cmps_[i].cmp).isNull()) {
                try {
                    stream.write(HtmlTag.HEADER2, this.cmps_[i].name).newLine();
                    ArimaModel finalError = this.estimators_.finalErrorModel(this.cmps_[i].cmp);
                    LinearModel revisionModel = this.estimators_.revisionModel(this.cmps_[i].cmp, 0);
                    stream.open(new HtmlTable().withWidth(500));
                    stream.open(HtmlTag.TABLEROW);
                    stream.write(new HtmlTableHeader("Lag"));
                    stream.write(new HtmlTableHeader("Final error"));
                    stream.write(new HtmlTableHeader("Revision error (concurrent estimator)"));
                    stream.write(new HtmlTableHeader("Total error (concurrent estimator)"));
                    stream.close(HtmlTag.TABLEROW);
                    double vf = finalError.getAutoCovarianceFunction().get(0);
                    double vr = revisionModel.getAutoCovarianceFunction().get(0);
                    stream.open(HtmlTag.TABLEROW);
                    stream.write(new HtmlTableCell("Variance").withWidth(50));
                    stream.write(new HtmlTableCell(df4.format(vf)).withWidth(150));
                    stream.write(new HtmlTableCell(df4.format(vr)).withWidth(150));
                    stream.write(new HtmlTableCell(df4.format(vf + vr)).withWidth(150));
                    stream.close(HtmlTag.TABLEROW);
                    for (int j = 1; j <= this.freq_; ++j) {
                        stream.open(HtmlTag.TABLEROW);
                        stream.write(new HtmlTableCell(Integer.toString(j)).withWidth(50));
                        double f = finalError.getAutoCovarianceFunction().get(j);
                        double r = revisionModel.getAutoCovarianceFunction().get(j);
                        stream.write(new HtmlTableCell(df4.format(f / vf)).withWidth(150));
                        stream.write(new HtmlTableCell(df4.format(r / vr)).withWidth(150));
                        stream.write(new HtmlTableCell(df4.format((f + r) / (vf + vr))).withWidth(150));
                        stream.close(HtmlTag.TABLEROW);
                    }
                }
                catch (ArimaException | MatrixException | IOException throwable) {
                    // empty catch block
                }
            }
            stream.close(HtmlTag.TABLE);
            stream.newLine();
        }
        stream.write(HtmlTag.LINEBREAK);
    }
}

