/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.html.implementation;

import ec.satoolkit.x11.Mstatistics;
import ec.tss.html.AbstractHtmlElement;
import ec.tss.html.Bootstrap4;
import ec.tss.html.HtmlStream;
import ec.tss.html.HtmlTable;
import ec.tss.html.HtmlTableCell;
import ec.tss.html.HtmlTag;
import java.io.IOException;

public class HtmlMstatistics
extends AbstractHtmlElement {
    Mstatistics stats_;
    private static final String[] M_DESC = new String[]{"The relative contribution of the irregular over three months span", "The relative contribution of the irregular component to the stationary portion of the variance", "The amount of period to period change in the irregular component as compared to the amount of period to period change in the trend", "The amount of autocorrelation in the irregular as described by the average duration of run", "The number of periods it takes the change in the trend to surpass the amount of change in the irregular", "The amount of year to year change in the irregular as compared to the amount of year to year change in the seasonal", "The amount of moving seasonality present relative to the amount of stable seasonality", "The size of the fluctuations in the seasonal component throughout the whole series", "The average linear movement in the seasonal component throughout the whole series", "The size of the fluctuations in the seasonal component in the recent years", "The average linear movement in the seasonal component in the recent years"};

    public HtmlMstatistics(Mstatistics mstats) {
        this.stats_ = mstats;
    }

    @Override
    public void write(HtmlStream stream) throws IOException {
        this.writeSummary(stream);
    }

    public void writeSummary(HtmlStream stream) throws IOException {
        stream.write(HtmlTag.HEADER2, "Monitoring and Quality Assessment Statistics").newLine();
        if (this.stats_.getCIc().getFrequency().intValue() == 2) {
            stream.write("These statistics are not available for half yearly data").newLine();
        } else {
            stream.open(new HtmlTable().withWidth(800));
            for (int i = 1; i <= this.stats_.getMCount(); ++i) {
                if (!this.stats_.isUsedM(i)) continue;
                stream.open(HtmlTag.TABLEROW);
                stream.write(new HtmlTableCell("M-" + Integer.toString(i)).withWidth(50));
                double m = this.stats_.getM(i);
                HtmlTableCell cell = new HtmlTableCell(df3.format(m)).withWidth(50);
                if (m > 1.0) {
                    cell.withClass(Bootstrap4.TEXT_DANGER);
                }
                stream.write(cell);
                stream.write(new HtmlTableCell(M_DESC[i - 1]).withWidth(700).withClass(Bootstrap4.TEXT_LEFT));
                stream.close(HtmlTag.TABLEROW);
            }
            stream.open(HtmlTag.TABLEROW);
            stream.write(new HtmlTableCell("Q").withWidth(50));
            double q = this.stats_.getQ();
            HtmlTableCell cell = new HtmlTableCell(df3.format(q)).withWidth(50);
            cell.withClass(Bootstrap4.FONT_WEIGHT_BOLD).withClass(q > 1.0 ? Bootstrap4.TEXT_DANGER : Bootstrap4.TEXT_SUCCESS);
            stream.write(cell);
            stream.close(HtmlTag.TABLEROW);
            stream.open(HtmlTag.TABLEROW);
            stream.write(new HtmlTableCell("Q-m2").withWidth(50));
            double qm2 = this.stats_.getQm2();
            cell = new HtmlTableCell(df3.format(qm2)).withWidth(50);
            cell.withClass(Bootstrap4.FONT_WEIGHT_BOLD).withClass(qm2 > 1.0 ? Bootstrap4.TEXT_DANGER : Bootstrap4.TEXT_SUCCESS);
            stream.write(cell);
            stream.close(HtmlTag.TABLEROW);
            stream.close(HtmlTag.TABLE);
        }
    }
}

