/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.html.implementation;

import ec.tss.html.AbstractHtmlElement;
import ec.tss.html.Bootstrap4;
import ec.tss.html.HtmlClass;
import ec.tss.html.HtmlStream;
import ec.tss.html.HtmlTable;
import ec.tss.html.HtmlTableCell;
import ec.tss.html.HtmlTableHeader;
import ec.tss.html.HtmlTag;
import ec.tss.html.IHtmlElement;
import ec.tstoolkit.modelling.arima.diagnostics.IOneStepAheadForecastingTest;
import ec.tstoolkit.stats.MeanTest;
import ec.tstoolkit.stats.StatisticalTest;
import java.io.IOException;

public class HtmlOneStepAheadForecastingTest
extends AbstractHtmlElement
implements IHtmlElement {
    private final IOneStepAheadForecastingTest test_;
    private double badthreshold_ = 0.01;
    private double goodthreshold_ = 0.1;

    public HtmlOneStepAheadForecastingTest(IOneStepAheadForecastingTest test) {
        this.test_ = test;
    }

    private void writeHeader(HtmlStream stream) throws IOException {
        stream.write(HtmlTag.HEADER1, "Out of sample test").newLine();
        int nin = this.test_.getInSampleLength();
        int nout = this.test_.getOutOfSampleLength();
        stream.write(HtmlTag.EMPHASIZED_TEXT, "Model re-estimated on Linearized series for first ").write(nin);
        stream.write(HtmlTag.EMPHASIZED_TEXT, " observations and ").write(nout);
        stream.write(HtmlTag.EMPHASIZED_TEXT, " One-Period-Ahead Forecasts computed with model fixed.").newLines(2);
    }

    private void writeMeanTest(HtmlStream stream) throws IOException {
        stream.write(HtmlTag.HEADER2, "Mean").newLine();
        int nout = this.test_.getOutOfSampleLength();
        MeanTest tin = this.test_.inSampleMeanTest();
        MeanTest tout = this.test_.outOfSampleMeanTest();
        stream.write(HtmlTag.EMPHASIZED_TEXT, "Comparison between forecast errors (last ").write(nout).write(" observations)");
        stream.write(HtmlTag.EMPHASIZED_TEXT, " and residuals (in-sample)").newLine();
        stream.write(HtmlTag.EMPHASIZED_TEXT, "In sample standard eror of the residuals is ").write(HtmlTag.EMPHASIZED_TEXT, df4.format(Math.sqrt(this.test_.getInSampleMSE()))).newLines(2);
        stream.open(new HtmlTable().withWidth(300));
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableHeader(""));
        stream.write(new HtmlTableHeader("Mean"));
        stream.write(new HtmlTableHeader("P-Value"));
        stream.close(HtmlTag.TABLEROW);
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell("In sample").withWidth(100));
        stream.write(new HtmlTableCell(df4.format(tin.getMean())).withWidth(100));
        stream.write(new HtmlTableCell(df4.format(tin.getPValue())).withWidth(100).withClass(this.getPValueClass(tin.getPValue())));
        stream.close(HtmlTag.TABLEROW);
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell("Out of sample").withWidth(100));
        stream.write(new HtmlTableCell(df4.format(tout.getMean())).withWidth(100));
        stream.write(new HtmlTableCell(df4.format(tout.getPValue())).withWidth(100).withClass(this.getPValueClass(tout.getPValue())));
        stream.close(HtmlTag.TABLEROW);
        stream.close(HtmlTag.TABLE).newLine();
        if (tout.getPValue() < this.badthreshold_) {
            stream.write(HtmlTag.IMPORTANT_TEXT, "Mean of forecast errors cannot be assumed zero", Bootstrap4.TEXT_DANGER);
        } else {
            stream.write(HtmlTag.IMPORTANT_TEXT, "Mean of forecast errors can be assumed zero", Bootstrap4.TEXT_SUCCESS);
        }
        stream.newLines(2);
    }

    private void writeMSETest(HtmlStream stream) throws IOException {
        stream.write(HtmlTag.HEADER2, "MSE").newLine();
        int nout = this.test_.getOutOfSampleLength();
        StatisticalTest test = this.test_.mseTest();
        stream.write(HtmlTag.EMPHASIZED_TEXT, "Comparison between mean squared of forecast errors (last ").write(nout).write(" observations)");
        stream.write(HtmlTag.EMPHASIZED_TEXT, " and mean squared of residuals (in-sample)").newLine();
        stream.write(HtmlTag.EMPHASIZED_TEXT, "The test is strongly sensitive to the possible non-normality of the residuals.").newLines(2);
        stream.open(new HtmlTable().withWidth(200));
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableHeader(""));
        stream.write(new HtmlTableHeader("MSE"));
        stream.close(HtmlTag.TABLEROW);
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell("In sample").withWidth(100));
        stream.write(new HtmlTableCell(df4.format(this.test_.getInSampleMSE())).withWidth(100));
        stream.close(HtmlTag.TABLEROW);
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell("Out of sample").withWidth(100));
        stream.write(new HtmlTableCell(df4.format(this.test_.getOutOfSampleMSE())).withWidth(100));
        stream.close(HtmlTag.TABLEROW);
        stream.close(HtmlTag.TABLE).newLine();
        stream.write("Test for equality of MSE = " + df4.format(test.getValue())).newLine();
        stream.write("Distribution: " + test.getDistribution().toString()).newLine();
        stream.write("P-Value: ").write(df4.format(test.getPValue()), this.getPValueClass(test.getPValue())).newLines(2);
        if (test.getPValue() < this.badthreshold_) {
            stream.write(HtmlTag.IMPORTANT_TEXT, "Mean Squared of forecast errors cannot be assumed close to the Mean Squared of in sample residuals.", Bootstrap4.TEXT_DANGER);
        } else {
            stream.write(HtmlTag.IMPORTANT_TEXT, "Mean Squared of forecast errors can be assumed close to the Mean Squared of in sample residuals.", Bootstrap4.TEXT_SUCCESS);
        }
        stream.newLines(2);
    }

    @Override
    public void write(HtmlStream stream) throws IOException {
        this.writeHeader(stream);
        this.writeMeanTest(stream);
        this.writeMSETest(stream);
    }

    private HtmlClass getPValueClass(double val) {
        if (val < this.badthreshold_) {
            return Bootstrap4.TEXT_DANGER;
        }
        if (val < this.goodthreshold_) {
            return Bootstrap4.TEXT_WARNING;
        }
        return Bootstrap4.TEXT_SUCCESS;
    }
}

