/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.html.implementation;

import ec.tss.html.AbstractHtmlElement;
import ec.tss.html.Bootstrap4;
import ec.tss.html.HtmlConverters;
import ec.tss.html.HtmlStream;
import ec.tss.html.HtmlTag;
import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.algorithm.ProcessingInformation;
import java.io.IOException;
import java.util.List;

public class HtmlProcessingInformation
extends AbstractHtmlElement {
    private final List<ProcessingInformation> infos_;
    private boolean err = true;
    private boolean wrn = true;
    private boolean info = false;
    private boolean verbose = true;

    public HtmlProcessingInformation(IProcResults rslts) {
        this.infos_ = rslts.getProcessingInformation();
    }

    public HtmlProcessingInformation(List<ProcessingInformation> infos) {
        this.infos_ = infos;
    }

    public void displayErrors(boolean e) {
        this.err = e;
    }

    public void displayWarnings(boolean e) {
        this.wrn = e;
    }

    public void displayInfos(boolean e) {
        this.info = e;
    }

    public void setVerbose(boolean v) {
        this.verbose = v;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void write(HtmlStream stream) throws IOException {
        List msg;
        List errs;
        if (this.infos_.isEmpty()) {
            return;
        }
        if (this.err && !(errs = ProcessingInformation.getErrorMessages(this.infos_)).isEmpty()) {
            stream.write(HtmlTag.HEADER2, "Errors").newLine();
            for (String err : errs) {
                stream.write(HtmlTag.IMPORTANT_TEXT, err, Bootstrap4.TEXT_DANGER).newLine();
            }
            stream.newLine();
        }
        if (this.wrn && !(msg = ProcessingInformation.getWarningMessages(this.infos_)).isEmpty()) {
            stream.write(HtmlTag.HEADER2, "Warnings").newLine();
            for (String m : msg) {
                stream.write(m, Bootstrap4.TEXT_INFO).newLine();
            }
            stream.newLine();
        }
        if (this.info) {
            if (!this.verbose) {
                msg = ProcessingInformation.getMessages(this.infos_, (ProcessingInformation.InformationType)ProcessingInformation.InformationType.Info);
                if (!msg.isEmpty()) {
                    stream.write(HtmlTag.HEADER2, "Log").newLine();
                    for (String m : msg) {
                        stream.write(m).newLine();
                    }
                    stream.newLine();
                }
            } else {
                String prevStep = null;
                for (ProcessingInformation cinfo : this.infos_) {
                    if (cinfo.type != ProcessingInformation.InformationType.Info) continue;
                    String curStep = cinfo.name;
                    if (prevStep == null || !prevStep.equals(curStep)) {
                        if (prevStep != null) {
                            stream.write(HtmlTag.LINEBREAK);
                        }
                        stream.write(HtmlTag.IMPORTANT_TEXT, curStep, Bootstrap4.TEXT_INFO).newLines(2);
                        prevStep = curStep;
                    }
                    stream.write(HtmlTag.EMPHASIZED_TEXT, cinfo.msg).newLine();
                    if (cinfo.details != null) {
                        stream.write(HtmlConverters.getDefault().convert(cinfo.details));
                    }
                    stream.newLine();
                }
            }
        }
    }
}

