/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.html.implementation;

import ec.tss.html.AbstractHtmlElement;
import ec.tss.html.Bootstrap4;
import ec.tss.html.HtmlStream;
import ec.tss.html.HtmlTable;
import ec.tss.html.HtmlTableCell;
import ec.tss.html.HtmlTag;
import ec.tss.html.implementation.HtmlLikelihood;
import ec.tstoolkit.Parameter;
import ec.tstoolkit.algorithm.ProcessingContext;
import ec.tstoolkit.dstats.T;
import ec.tstoolkit.eco.ConcentratedLikelihood;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.modelling.DefaultTransformationType;
import ec.tstoolkit.modelling.PreadjustmentVariable;
import ec.tstoolkit.modelling.Variable;
import ec.tstoolkit.modelling.arima.JointRegressionTest;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import ec.tstoolkit.sarima.SarimaComponent;
import ec.tstoolkit.sarima.SarimaSpecification;
import ec.tstoolkit.timeseries.calendars.LengthOfPeriodType;
import ec.tstoolkit.timeseries.regression.GregorianCalendarVariables;
import ec.tstoolkit.timeseries.regression.ILengthOfPeriodVariable;
import ec.tstoolkit.timeseries.regression.IMovingHolidayVariable;
import ec.tstoolkit.timeseries.regression.IOutlierVariable;
import ec.tstoolkit.timeseries.regression.ITradingDaysVariable;
import ec.tstoolkit.timeseries.regression.ITsVariable;
import ec.tstoolkit.timeseries.regression.IUserTsVariable;
import ec.tstoolkit.timeseries.regression.InterventionVariable;
import ec.tstoolkit.timeseries.regression.MissingValueEstimation;
import ec.tstoolkit.timeseries.regression.Ramp;
import ec.tstoolkit.timeseries.regression.TsVariableList;
import ec.tstoolkit.timeseries.regression.TsVariableSelection;
import ec.tstoolkit.timeseries.regression.TsVariables;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.utilities.NameManager;
import java.io.IOException;
import java.util.List;
import java.util.function.Predicate;

public class HtmlRegArima
extends AbstractHtmlElement {
    private final PreprocessingModel model_;
    private final TsVariableList x_;
    private final ConcentratedLikelihood ll_;
    private final int nhp_;
    boolean summary_;
    private boolean ml_;

    public HtmlRegArima(PreprocessingModel model, boolean summary) {
        this.model_ = model;
        this.x_ = this.model_.description.buildRegressionVariables();
        this.ll_ = this.model_.estimation.getLikelihood();
        this.nhp_ = this.model_.description.getArimaComponent().getFreeParametersCount();
        this.summary_ = summary;
    }

    public boolean isML() {
        return this.ml_;
    }

    public void setML(boolean val) {
        this.ml_ = val;
    }

    @Override
    public void write(HtmlStream stream) throws IOException {
        this.writeSummary(stream);
        if (this.summary_) {
            return;
        }
        this.writeDetails(stream);
    }

    private void writeSummary(HtmlStream stream) throws IOException {
        TsFrequency context = this.model_.getFrequency();
        stream.write(HtmlTag.HEADER1, "Summary").newLine();
        stream.write("Estimation span: [").write(this.model_.description.getEstimationDomain().getStart().toString());
        stream.write(" - ").write(this.model_.description.getEstimationDomain().getLast().toString()).write(']').newLine();
        int nm = this.model_.estimation.getRegArima().getMissingsCount();
        if (nm > 0) {
            stream.write(Integer.toString(this.model_.description.getEstimationDomain().getLength())).write(" observations (including missing)").newLine();
        } else {
            stream.write(Integer.toString(this.model_.description.getEstimationDomain().getLength())).write(" observations").newLine();
        }
        if (this.model_.description.getTransformation() == DefaultTransformationType.Log) {
            stream.write("Series has been log-transformed").newLine();
        }
        if (this.model_.description.getLengthOfPeriodType() != LengthOfPeriodType.None) {
            stream.write("Series has been corrected for leap year").newLine();
        }
        int ntd = this.model_.description.countRegressors(var -> var.isCalendar() && var.status.isSelected());
        int nftd = this.model_.description.countFixedRegressors(var -> var.isCalendar());
        if (ntd == 0 && nftd == 0) {
            stream.write("No trading days effects").newLine();
        } else {
            if (ntd != 0) {
                stream.write("Trading days effects (").write(Integer.toString(ntd)).write(ntd > 1 ? " variables)" : " variable)").newLine();
            }
            if (nftd != 0) {
                stream.write("Fixed Trading days effects (").write(Integer.toString(nftd)).write(nftd > 1 ? " variables)" : " variable)").newLine();
            }
        }
        List ee = this.model_.description.selectVariables(var -> var.isMovingHoliday() && var.status.isSelected());
        List fee = this.model_.description.selectPreadjustmentVariables(var -> var.isMovingHoliday());
        if (ee.isEmpty() && fee.isEmpty()) {
            stream.write("No easter effect").newLine();
        } else {
            if (!ee.isEmpty()) {
                stream.write(((Variable)ee.get(0)).getVariable().getDescription(context) + " detected").newLine();
            }
            if (!fee.isEmpty()) {
                stream.write("Fixed " + ((PreadjustmentVariable)fee.get(0)).getVariable().getDescription(context) + " effect").newLine();
            }
        }
        int no = this.model_.description.getOutliers().size();
        int npo = this.model_.description.getPrespecifiedOutliers().size();
        int nfo = this.model_.description.countFixedRegressors(var -> var.isOutlier());
        if (npo > 1) {
            stream.write(Integer.toString(npo)).write(" pre-specified outliers").newLine();
        } else if (npo == 1) {
            stream.write(Integer.toString(npo)).write(" pre-specified outlier").newLine();
        }
        if (no > 1) {
            stream.write(Integer.toString(no)).write(" detected outliers").newLine();
        } else if (no == 1) {
            stream.write(Integer.toString(no)).write(" detected outlier").newLine();
        }
        if (nfo > 1) {
            stream.write(Integer.toString(nfo)).write(" fixed outliers").newLine();
        } else if (nfo == 1) {
            stream.write(Integer.toString(nfo)).write(" fixed outlier").newLine();
        }
        stream.write(HtmlTag.LINEBREAK);
    }

    public void writeDetails(HtmlStream stream) throws IOException {
        this.writeDetails(stream, true);
    }

    public void writeDetails(HtmlStream stream, boolean outliers) throws IOException {
        stream.write(HtmlTag.HEADER1, "Final model");
        stream.newLine();
        stream.write(HtmlTag.HEADER2, "Likelihood statistics");
        stream.write(new HtmlLikelihood(this.model_.estimation.getStatistics()));
        this.writeScore(stream);
        stream.write(HtmlTag.LINEBREAK);
        stream.write(HtmlTag.HEADER2, "Arima model");
        this.writeArima(stream);
        stream.write(HtmlTag.LINEBREAK);
        stream.write(HtmlTag.HEADER2, "Regression model");
        this.writeRegression(stream, outliers);
        stream.write(HtmlTag.LINEBREAK);
    }

    public void writeArima(HtmlStream stream) throws IOException {
        SarimaComponent arima = this.model_.description.getArimaComponent();
        SarimaSpecification sspec = arima.getSpecification();
        stream.write('[').write(sspec.toString()).write(']').newLines(2);
        if (sspec.getParametersCount() == 0) {
            return;
        }
        stream.open(new HtmlTable().withWidth(400));
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell("").withWidth(100));
        stream.write(new HtmlTableCell("Coefficients").withWidth(100).withClass(Bootstrap4.FONT_WEIGHT_BOLD));
        stream.write(new HtmlTableCell("T-Stat").withWidth(100).withClass(Bootstrap4.FONT_WEIGHT_BOLD));
        stream.write(new HtmlTableCell("P[|T| &gt t]").withWidth(100).withClass(Bootstrap4.FONT_WEIGHT_BOLD));
        stream.close(HtmlTag.TABLEROW);
        int P = sspec.getP();
        Parameter[] p = arima.getPhi();
        T t = new T();
        t.setDegreesofFreedom(this.ll_.getDegreesOfFreedom(true, this.nhp_));
        for (int j = 0; j < P; ++j) {
            stream.open(HtmlTag.TABLEROW);
            StringBuilder header = new StringBuilder();
            header.append("Phi(").append(j + 1).append(')');
            stream.write(new HtmlTableCell(header.toString()).withWidth(100));
            double val = p[j].getValue();
            double stde = p[j].getStde();
            stream.write(new HtmlTableCell(df4.format(val)).withWidth(100));
            if (stde > 0.0) {
                double tval = val / stde;
                stream.write(new HtmlTableCell(HtmlRegArima.formatT(tval)).withWidth(100));
                double prob = 1.0 - t.getProbabilityForInterval(-tval, tval);
                stream.write(new HtmlTableCell(df4.format(prob)).withWidth(100));
            }
            stream.close(HtmlTag.TABLEROW);
        }
        int Q = sspec.getQ();
        p = arima.getTheta();
        for (int j = 0; j < Q; ++j) {
            stream.open(HtmlTag.TABLEROW);
            StringBuilder header = new StringBuilder();
            header.append("Theta(").append(j + 1).append(')');
            stream.write(new HtmlTableCell(header.toString()).withWidth(100));
            double val = p[j].getValue();
            double stde = p[j].getStde();
            stream.write(new HtmlTableCell(df4.format(val)).withWidth(100));
            if (stde > 0.0) {
                double tval = val / stde;
                stream.write(new HtmlTableCell(HtmlRegArima.formatT(tval)).withWidth(100));
                double prob = 1.0 - t.getProbabilityForInterval(-tval, tval);
                stream.write(new HtmlTableCell(df4.format(prob)).withWidth(100));
            }
            stream.close(HtmlTag.TABLEROW);
        }
        int BP = sspec.getBP();
        p = arima.getBPhi();
        for (int j = 0; j < BP; ++j) {
            stream.open(HtmlTag.TABLEROW);
            StringBuilder header = new StringBuilder();
            header.append("BPhi(").append(j + 1).append(')');
            stream.write(new HtmlTableCell(header.toString()).withWidth(100));
            double val = p[j].getValue();
            double stde = p[j].getStde();
            stream.write(new HtmlTableCell(df4.format(val)).withWidth(100));
            if (stde > 0.0) {
                double tval = val / stde;
                stream.write(new HtmlTableCell(HtmlRegArima.formatT(tval)).withWidth(100));
                double prob = 1.0 - t.getProbabilityForInterval(-tval, tval);
                stream.write(new HtmlTableCell(df4.format(prob)).withWidth(100));
            }
            stream.close(HtmlTag.TABLEROW);
        }
        int BQ = sspec.getBQ();
        p = arima.getBTheta();
        for (int j = 0; j < BQ; ++j) {
            stream.open(HtmlTag.TABLEROW);
            StringBuilder header = new StringBuilder();
            header.append("BTheta(").append(j + 1).append(')');
            stream.write(new HtmlTableCell(header.toString()).withWidth(100));
            double val = p[j].getValue();
            double stde = p[j].getStde();
            stream.write(new HtmlTableCell(df4.format(val)).withWidth(100));
            if (stde > 0.0) {
                double tval = val / stde;
                stream.write(new HtmlTableCell(HtmlRegArima.formatT(tval)).withWidth(100));
                double prob = 1.0 - t.getProbabilityForInterval(-tval, tval);
                stream.write(new HtmlTableCell(df4.format(prob)).withWidth(100));
            }
            stream.close(HtmlTag.TABLEROW);
        }
        stream.close(HtmlTag.TABLE);
        Matrix pcov = this.model_.estimation.getParametersCovariance();
        if (pcov != null && pcov.getRowsCount() > 1) {
            int i;
            int size = pcov.getColumnsCount();
            stream.newLines(2);
            stream.write(HtmlTag.HEADER3, "Correlation of the estimates").newLine();
            stream.open(HtmlTag.TABLE);
            stream.open(HtmlTag.TABLEROW);
            stream.write(new HtmlTableCell("").withWidth(100));
            for (i = 0; i < P; ++i) {
                StringBuilder header = new StringBuilder();
                header.append("Phi(").append(i + 1).append(")");
                stream.write(new HtmlTableCell(header.toString()).withWidth(100));
            }
            for (i = 0; i < Q; ++i) {
                StringBuilder header = new StringBuilder();
                header.append("Theta(").append(i + 1).append(")");
                stream.write(new HtmlTableCell(header.toString()).withWidth(100));
            }
            for (i = 0; i < BP; ++i) {
                StringBuilder header = new StringBuilder();
                header.append("BPhi(").append(i + 1).append(")");
                stream.write(new HtmlTableCell(header.toString()).withWidth(100));
            }
            for (i = 0; i < BQ; ++i) {
                StringBuilder header = new StringBuilder();
                header.append("BTheta(").append(i + 1).append(")");
                stream.write(new HtmlTableCell(header.toString()).withWidth(100));
            }
            stream.close(HtmlTag.TABLEROW);
            for (i = 0; i < size; ++i) {
                StringBuilder header = new StringBuilder();
                stream.open(HtmlTag.TABLEROW);
                if (i < P) {
                    header.append("Phi(").append(i + 1);
                } else if (i < P + Q) {
                    header.append("Theta(").append(i - P + 1);
                } else if (i < P + Q + BP) {
                    header.append("BPhi(").append(i - P - Q + 1);
                } else {
                    header.append("BTheta(").append(i - P - Q - BP + 1);
                }
                header.append(")");
                stream.write(new HtmlTableCell(header.toString()).withWidth(100));
                for (int j = 0; j < size; ++j) {
                    double vi = pcov.get(i, i);
                    double vj = pcov.get(j, j);
                    if (vi != 0.0 && vj != 0.0) {
                        double val = pcov.get(i, j) / Math.sqrt(vi * vj);
                        stream.write(new HtmlTableCell(df4.format(val)).withWidth(100));
                        continue;
                    }
                    stream.write(new HtmlTableCell("-").withWidth(100));
                }
                stream.close(HtmlTag.TABLEROW);
            }
            stream.close(HtmlTag.TABLE);
            stream.newLine();
        }
    }

    public void writeRegression(HtmlStream stream) throws IOException {
        this.writeRegression(stream, true);
    }

    public void writeRegression(HtmlStream stream, boolean outliers) throws IOException {
        this.writeMean(stream);
        TsFrequency context = this.context();
        this.writeRegressionItems(stream, context, true, var -> var instanceof ITradingDaysVariable);
        this.writeRegressionItems(stream, context, false, var -> var instanceof ILengthOfPeriodVariable);
        this.writeFixedRegressionItems(stream, "Fixed calendar effects", context, var -> var.isCalendar());
        this.writeRegressionItems(stream, context, false, var -> var instanceof IMovingHolidayVariable);
        this.writeFixedRegressionItems(stream, "Fixed moving holidays effects", context, var -> var.isMovingHoliday());
        if (outliers) {
            this.writeOutliers(stream, true, context);
            this.writeOutliers(stream, false, context);
            this.writeFixedRegressionItems(stream, "Fixed outliers", context, var -> var.isOutlier());
        }
        this.writeRegressionItems(stream, "Ramps", true, context, var -> var instanceof Ramp);
        this.writeRegressionItems(stream, "Intervention variables", true, context, var -> var instanceof InterventionVariable);
        this.writeRegressionItems(stream, "User variables", true, context, var -> var instanceof IUserTsVariable && !(var instanceof InterventionVariable) && !(var instanceof Ramp));
        this.writeFixedRegressionItems(stream, "Fixed other regression effects", context, var -> var.isUser());
        this.writeMissing(stream);
    }

    private void writeMean(HtmlStream stream) throws IOException {
        if (!this.model_.description.isMean()) {
            return;
        }
        if (this.model_.description.isEstimatedMean()) {
            this.writeEstimatedMean(stream);
        } else {
            this.writeFixedMean(stream);
        }
    }

    private void writeEstimatedMean(HtmlStream stream) throws IOException {
        double[] b = this.ll_.getB();
        stream.write(HtmlTag.HEADER3, "Mean");
        stream.open(new HtmlTable().withWidth(400));
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell("").withWidth(100));
        stream.write(new HtmlTableCell("Coefficient").withWidth(100).withClass(Bootstrap4.FONT_WEIGHT_BOLD));
        stream.write(new HtmlTableCell("T-Stat").withWidth(100).withClass(Bootstrap4.FONT_WEIGHT_BOLD));
        stream.write(new HtmlTableCell("P[|T| &gt t]").withWidth(100).withClass(Bootstrap4.FONT_WEIGHT_BOLD));
        stream.close(HtmlTag.TABLEROW);
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell("mu").withWidth(100));
        stream.write(new HtmlTableCell(df4.format(b[0])).withWidth(100));
        T t = new T();
        t.setDegreesofFreedom(this.ll_.getDegreesOfFreedom(true, this.nhp_));
        double tval = this.ll_.getTStat(0, true, this.nhp_);
        stream.write(new HtmlTableCell(HtmlRegArima.formatT(tval)).withWidth(100));
        double prob = 1.0 - t.getProbabilityForInterval(-tval, tval);
        stream.write(new HtmlTableCell(df4.format(prob)).withWidth(100));
        stream.close(HtmlTag.TABLEROW);
        stream.close(HtmlTag.TABLE);
        stream.newLine();
    }

    private void writeFixedMean(HtmlStream stream) throws IOException {
        stream.write(HtmlTag.HEADER3, "Fixed mean");
        stream.open(new HtmlTable().withWidth(200));
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell("").withWidth(100));
        stream.write(new HtmlTableCell("Coefficient").withWidth(100).withClass(Bootstrap4.FONT_WEIGHT_BOLD));
        stream.close(HtmlTag.TABLEROW);
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell("mu").withWidth(100));
        stream.write(new HtmlTableCell(df4.format(this.model_.description.getArimaComponent().getMeanCorrection())).withWidth(100));
        stream.close(HtmlTag.TABLEROW);
        stream.close(HtmlTag.TABLE);
        stream.newLine();
    }

    private void writeOutliers(HtmlStream stream, boolean prespecified, TsFrequency context) throws IOException {
        String header = prespecified ? "Prespecified outliers" : "Outliers";
        this.writeRegressionItems(stream, header, true, context, var -> var instanceof IOutlierVariable && this.model_.description.isPrespecified((IOutlierVariable)var) == prespecified);
    }

    private <V extends ITsVariable> void writeRegressionItems(HtmlStream stream, TsFrequency context, boolean jointest, Predicate<ITsVariable> predicate) throws IOException {
        TsVariableSelection regs = this.x_.select(predicate);
        if (regs.isEmpty()) {
            return;
        }
        T t = new T();
        t.setDegreesofFreedom(this.ll_.getDegreesOfFreedom(true, this.nhp_));
        double[] b = this.ll_.getB();
        int start = this.model_.description.getRegressionVariablesStartingPosition();
        for (TsVariableSelection.Item reg : regs.elements()) {
            stream.write(HtmlTag.HEADER3, reg.variable.getDescription(context));
            stream.open(new HtmlTable().withWidth(400));
            stream.open(HtmlTag.TABLEROW);
            stream.write(new HtmlTableCell("").withWidth(100));
            stream.write(new HtmlTableCell("Coefficients").withWidth(100).withClass(Bootstrap4.FONT_WEIGHT_BOLD));
            stream.write(new HtmlTableCell("T-Stat").withWidth(100).withClass(Bootstrap4.FONT_WEIGHT_BOLD));
            stream.write(new HtmlTableCell("P[|T| &gt t]").withWidth(100).withClass(Bootstrap4.FONT_WEIGHT_BOLD));
            stream.close(HtmlTag.TABLEROW);
            int ndim = reg.variable.getDim();
            for (int j = 0; j < reg.variable.getDim(); ++j) {
                stream.open(HtmlTag.TABLEROW);
                stream.write(new HtmlTableCell(reg.variable.getItemDescription(j, context)).withWidth(100));
                stream.write(new HtmlTableCell(df4.format(b[start + j + reg.position])).withWidth(100));
                double tval = this.ll_.getTStat(start + j + reg.position, true, this.nhp_);
                stream.write(new HtmlTableCell(HtmlRegArima.formatT(tval)).withWidth(100));
                double prob = 1.0 - t.getProbabilityForInterval(-tval, tval);
                stream.write(new HtmlTableCell(df4.format(prob)).withWidth(100));
                stream.close(HtmlTag.TABLEROW);
            }
            if (ndim > 1 && reg.variable instanceof GregorianCalendarVariables) {
                stream.open(HtmlTag.TABLEROW);
                stream.write(new HtmlTableCell("Sunday (derived)").withWidth(100));
                double bd = 0.0;
                int k0 = start + reg.position;
                int k1 = k0 + ndim;
                for (int k = k0; k < k1; ++k) {
                    bd -= b[k];
                }
                stream.write(new HtmlTableCell(df4.format(bd)).withWidth(100));
                double var = this.ll_.getBVar(true, this.nhp_).subMatrix(k0, k1, k0, k1).sum();
                double tval = bd / Math.sqrt(var);
                stream.write(new HtmlTableCell(HtmlRegArima.formatT(tval)).withWidth(100));
                double prob = 1.0 - t.getProbabilityForInterval(-tval, tval);
                stream.write(new HtmlTableCell(df4.format(prob)).withWidth(100));
                stream.close(HtmlTag.TABLEROW);
            }
            stream.close(HtmlTag.TABLE);
            stream.newLine();
        }
        int nvars = regs.getVariablesCount();
        if (jointest && regs.getItemsCount() == 1 && nvars > 1) {
            try {
                JointRegressionTest jtest = new JointRegressionTest(0.05);
                boolean ok = jtest.accept(this.ll_, this.nhp_, start + regs.get((int)0).position, nvars, null);
                StringBuilder builder = new StringBuilder();
                builder.append("Joint F-Test = ").append(df2.format(jtest.getTest().getValue())).append(" (").append(df4.format(jtest.getTest().getPValue())).append(')');
                if (!ok) {
                    stream.write(HtmlTag.IMPORTANT_TEXT, builder.toString(), Bootstrap4.TEXT_DANGER);
                } else {
                    stream.write(HtmlTag.EMPHASIZED_TEXT, builder.toString());
                }
                stream.newLines(2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private <V extends ITsVariable> void writeRegressionItems(HtmlStream stream, String header, boolean desc, TsFrequency context, Predicate<ITsVariable> predicate) throws IOException {
        TsVariableSelection regs = this.x_.select(predicate);
        if (regs.isEmpty()) {
            return;
        }
        if (header != null) {
            stream.write(HtmlTag.HEADER3, header);
        }
        T t = new T();
        stream.open(new HtmlTable().withWidth(400));
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell("").withWidth(100));
        stream.write(new HtmlTableCell("Coefficients").withWidth(100).withClass(Bootstrap4.FONT_WEIGHT_BOLD));
        stream.write(new HtmlTableCell("T-Stat").withWidth(100).withClass(Bootstrap4.FONT_WEIGHT_BOLD));
        stream.write(new HtmlTableCell("P[|T| &gt t]").withWidth(100).withClass(Bootstrap4.FONT_WEIGHT_BOLD));
        stream.close(HtmlTag.TABLEROW);
        t.setDegreesofFreedom(this.ll_.getDegreesOfFreedom(true, this.nhp_));
        double[] b = this.ll_.getB();
        int start = this.model_.description.getRegressionVariablesStartingPosition();
        for (TsVariableSelection.Item reg : regs.elements()) {
            int ndim = reg.variable.getDim();
            for (int j = 0; j < reg.variable.getDim(); ++j) {
                stream.open(HtmlTag.TABLEROW);
                if (ndim > 1 || desc) {
                    stream.write(new HtmlTableCell(reg.variable.getItemDescription(j, context)).withWidth(100));
                } else {
                    stream.write(new HtmlTableCell("").withWidth(100));
                }
                stream.write(new HtmlTableCell(df4.format(b[start + j + reg.position])).withWidth(100));
                double tval = this.ll_.getTStat(start + j + reg.position, true, this.nhp_);
                stream.write(new HtmlTableCell(HtmlRegArima.formatT(tval)).withWidth(100));
                double prob = 1.0 - t.getProbabilityForInterval(-tval, tval);
                stream.write(new HtmlTableCell(df4.format(prob)).withWidth(100));
                stream.close(HtmlTag.TABLEROW);
            }
        }
        stream.close(HtmlTag.TABLE);
        stream.newLine();
    }

    private <V extends ITsVariable> void writeFixedRegressionItems(HtmlStream stream, String header, TsFrequency context, Predicate<PreadjustmentVariable> predicate) throws IOException {
        List regs = this.model_.description.selectPreadjustmentVariables(predicate);
        if (regs.isEmpty()) {
            return;
        }
        if (header != null) {
            stream.write(HtmlTag.HEADER3, header);
        }
        stream.open(new HtmlTable().withWidth(200));
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell("").withWidth(100));
        stream.write(new HtmlTableCell("Coefficients").withWidth(100).withClass(Bootstrap4.FONT_WEIGHT_BOLD));
        stream.close(HtmlTag.TABLEROW);
        for (PreadjustmentVariable reg : regs) {
            ITsVariable cur = reg.getVariable();
            double[] c = reg.getCoefficients();
            for (int j = 0; j < cur.getDim(); ++j) {
                stream.open(HtmlTag.TABLEROW);
                String name = cur.getItemDescription(j, context);
                if (name.startsWith("td|")) {
                    String tsname;
                    TsVariables tss;
                    String prefix;
                    name = name.replace("td|", "");
                    ProcessingContext pc = ProcessingContext.getActiveContext();
                    NameManager tsVariableManagers = pc.getTsVariableManagers();
                    if (tsVariableManagers.contains(prefix = name.substring(0, name.indexOf(46))) && (tss = (TsVariables)tsVariableManagers.get(prefix)).contains(tsname = name.substring(name.indexOf(46) + 1, name.length()))) {
                        stream.write(new HtmlTableCell(((ITsVariable)tss.get(tsname)).getDescription(context)).withWidth(100));
                    }
                } else {
                    stream.write(new HtmlTableCell(cur.getItemDescription(j, context)).withWidth(100));
                }
                stream.write(new HtmlTableCell(df4.format(c[j])).withWidth(100));
                stream.close(HtmlTag.TABLEROW);
            }
        }
        stream.close(HtmlTag.TABLE);
        stream.newLine();
    }

    private <V extends ITsVariable> void writeFixedRegressionItems(HtmlStream stream, TsFrequency context, Predicate<PreadjustmentVariable> predicate) throws IOException {
        List regs = this.model_.description.selectPreadjustmentVariables(predicate);
        if (regs.isEmpty()) {
            return;
        }
        for (PreadjustmentVariable reg : regs) {
            ITsVariable cur = reg.getVariable();
            stream.write(HtmlTag.HEADER3, cur.getDescription(context));
            stream.open(new HtmlTable().withWidth(200));
            stream.open(HtmlTag.TABLEROW);
            stream.write(new HtmlTableCell("").withWidth(100));
            stream.write(new HtmlTableCell("Coefficients").withWidth(100).withClass(Bootstrap4.FONT_WEIGHT_BOLD));
            stream.close(HtmlTag.TABLEROW);
            double[] c = reg.getCoefficients();
            for (int j = 0; j < cur.getDim(); ++j) {
                stream.open(HtmlTag.TABLEROW);
                stream.write(new HtmlTableCell(cur.getItemDescription(j, context)).withWidth(100));
                stream.write(new HtmlTableCell(df4.format(c[j])).withWidth(100));
                stream.close(HtmlTag.TABLEROW);
            }
            stream.close(HtmlTag.TABLE);
            stream.newLine();
        }
    }

    private void writeMissing(HtmlStream stream) throws IOException {
        MissingValueEstimation[] missings = this.model_.missings(true);
        if (missings == null) {
            return;
        }
        stream.write(HtmlTag.HEADER3, "Missing values");
        stream.open(new HtmlTable().withWidth(400));
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell("Periods").withWidth(100).withClass(Bootstrap4.FONT_WEIGHT_BOLD));
        stream.write(new HtmlTableCell("Value").withWidth(100).withClass(Bootstrap4.FONT_WEIGHT_BOLD));
        stream.write(new HtmlTableCell("Standard error").withWidth(100).withClass(Bootstrap4.FONT_WEIGHT_BOLD));
        stream.write(new HtmlTableCell("Untransformed value").withWidth(100).withClass(Bootstrap4.FONT_WEIGHT_BOLD));
        stream.close(HtmlTag.TABLEROW);
        for (int i = 0; i < missings.length; ++i) {
            stream.open(HtmlTag.TABLEROW);
            stream.write(new HtmlTableCell(missings[i].getPosition().toString()).withWidth(100));
            stream.write(new HtmlTableCell(df4.format(missings[i].getValue())).withWidth(100));
            stream.write(new HtmlTableCell(df4.format(missings[i].getStdev())).withWidth(100));
            TsData tmp = new TsData(missings[i].getPosition(), new double[]{missings[i].getValue()}, false);
            this.model_.backTransform(tmp, true, true);
            stream.write(new HtmlTableCell(df4.format(tmp.get(0))).withWidth(100));
            stream.close(HtmlTag.TABLEROW);
        }
        stream.close(HtmlTag.TABLE);
        stream.newLines(2);
    }

    private TsFrequency context() {
        return this.model_.description.getEstimationDomain().getFrequency();
    }

    private void writeScore(HtmlStream stream) throws IOException {
        double[] score = (double[])this.model_.info_.deepSearch("score", double[].class);
        if (score == null) {
            return;
        }
        stream.newLine();
        stream.write(HtmlTag.HEADER3, "Scores at the solution");
        for (int i = 0; i < score.length; ++i) {
            stream.write(dg6.format(score[i]));
            stream.write("  ");
        }
    }
}

