/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.html.implementation;

import ec.tss.html.AbstractHtmlElement;
import ec.tss.html.HtmlStream;
import ec.tss.html.HtmlTag;
import ec.tss.html.IHtmlElement;
import ec.tss.sa.RegArimaReport;
import ec.tstoolkit.sarima.SarimaSpecification;
import java.io.IOException;

public class HtmlRegArimaReport
extends AbstractHtmlElement
implements IHtmlElement {
    private RegArimaReport report_;
    private String title_;

    public HtmlRegArimaReport(String title, RegArimaReport report) {
        this.title_ = title;
        this.report_ = report;
    }

    @Override
    public void write(HtmlStream stream) throws IOException {
        if (this.title_ != null) {
            this.writeSummary(stream);
        }
        this.writeTransform(stream);
        this.writeArima(stream);
        this.writeOutliers(stream);
        this.writeDetails(stream);
    }

    private void writeSummary(HtmlStream stream) throws IOException {
        stream.write(HtmlTag.HEADER1, this.title_).newLine();
        stream.write("number of series: ").write(this.report_.Total).newLines(2);
    }

    private void writeTransform(HtmlStream stream) throws IOException {
        stream.write(HtmlTag.HEADER1, "Transformation").newLine();
        double tot = this.report_.Total;
        int n = this.report_.LogCount;
        stream.write("Log transformations: ").write(n).write(" [").write(df2.format((double)(n * 100) / tot)).write(" %]").newLines(2);
    }

    private void writeArima(HtmlStream stream) throws IOException {
        stream.write(HtmlTag.HEADER1, "Arima models").newLine();
        double tot = this.report_.Total;
        SarimaSpecification[] specs = this.report_.getModels();
        for (int i = 0; i < specs.length; ++i) {
            int n = this.report_.getModelCount(specs[i]);
            stream.write(specs[i].toString()).write(": ").write(n).write(" [").write(df2.format((double)(n * 100) / tot)).write(" %]").newLine();
        }
        int m = this.report_.MeanCount;
        stream.newLine().write("Mean correction: ").write(m).write(" [").write(df2.format((double)(m * 100) / tot)).write(" %]").newLines(2);
    }

    private void writeOutliers(HtmlStream stream) throws IOException {
        stream.write(HtmlTag.HEADER1, "Outliers").newLine();
        double tot = this.report_.Total;
        int n = this.report_.AoCount + this.report_.LsCount + this.report_.TcCount + this.report_.SoCount;
        stream.write("All outliers: ").write(n).write(" [ average: ").write(df2.format((double)n / tot)).write(" ]").newLines(2);
        if (n > 0) {
            if (this.report_.AoCount > 0) {
                stream.write("Additive outliers: ").write(this.report_.AoCount).write(" [ average: ").write(df2.format((double)this.report_.AoCount / tot)).write(" ]").newLine();
            }
            if (this.report_.LsCount > 0) {
                stream.write("Level shifts: ").write(this.report_.LsCount).write(" [ average: ").write(df2.format((double)this.report_.LsCount / tot)).write(" ]").newLine();
            }
            if (this.report_.TcCount > 0) {
                stream.write("Transitory changes: ").write(this.report_.TcCount).write(" [ average: ").write(df2.format((double)this.report_.TcCount / tot)).write(" ]").newLine();
            }
            if (this.report_.SoCount > 0) {
                stream.write("Seasonal outliers: ").write(this.report_.SoCount).write(" [ average: ").write(df2.format((double)this.report_.SoCount / tot)).write(" ]").newLine();
            }
            stream.newLine();
        }
    }

    private void writeDetails(HtmlStream stream) throws IOException {
        stream.write(HtmlTag.HEADER1, "Calendar effects").newLine();
        double tot = this.report_.Total;
        int n = this.report_.TdCount;
        stream.write("Trading days corrections: ").write(n).write(" [").write(df2.format((double)(n * 100) / tot)).write(" %]").newLine();
        n = this.report_.LpCount;
        stream.write("Leap year corrections: ").write(n).write(" [").write(df2.format((double)(n * 100) / tot)).write(" %]").newLines(2);
        n = this.report_.EasterCount;
        stream.write("Easter corrections: ").write(n).write(" [").write(df2.format((double)(n * 100) / tot)).write(" %]").newLine();
    }
}

