/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.html.implementation;

import ec.satoolkit.diagnostics.ResidualSeasonalityDiagnostics;
import ec.satoolkit.diagnostics.SeasonalityTest;
import ec.tss.html.AbstractHtmlElement;
import ec.tss.html.Bootstrap4;
import ec.tss.html.HtmlStream;
import ec.tss.html.HtmlTag;
import ec.tstoolkit.timeseries.TsPeriodSelector;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import java.io.IOException;

public class HtmlResidualSeasonalityTest
extends AbstractHtmlElement {
    private TsData m_sa;
    private double m_badthreshold = 0.1;
    private double m_goodthresohold = 0.01;
    private ResidualSeasonalityDiagnostics.Configuration m_config = ResidualSeasonalityDiagnostics.defaultConfiguration.clone();

    public HtmlResidualSeasonalityTest(TsData sa) {
        this.m_sa = sa;
    }

    public void ResidualSeasonality(HtmlStream stream) throws IOException {
        stream.write(HtmlTag.HEADER1, "Residual seasonality test").newLine();
        if (this.m_sa == null || this.m_sa.getFrequency() == TsFrequency.Yearly) {
            stream.write("Series can't be tested");
            return;
        }
        int freq = this.m_sa.getFrequency().intValue();
        TsData s = this.m_sa.delta(Math.max(1, freq / 4));
        SeasonalityTest ftest = SeasonalityTest.stableSeasonality((TsData)s);
        double val = ftest.getPValue();
        if (val < this.m_config.getSASevere()) {
            stream.write(HtmlTag.IMPORTANT_TEXT, "Residual seasonality present in the entire series at the " + 100.0 * this.m_config.getSASevere() + " per cent level: F=" + df4.format(ftest.getValue()), Bootstrap4.TEXT_DANGER).newLine();
        } else if (val < this.m_config.getSABad()) {
            stream.write("Residual seasonality present in the entire series at the " + 100.0 * this.m_config.getSABad() + " per cent level: F=" + df4.format(ftest.getValue()), Bootstrap4.TEXT_DANGER).newLine();
        } else if (val < this.m_config.getSAUncertain()) {
            stream.write("Residual seasonality present in the entire series at the " + 100.0 * this.m_config.getSAUncertain() + " per cent level: F=" + df4.format(ftest.getValue()), Bootstrap4.TEXT_WARNING).newLine();
        } else {
            stream.write("No evidence of residual seasonality in the entire series at the " + 100.0 * this.m_config.getSAUncertain() + " per cent level: F=" + df4.format(ftest.getValue()), Bootstrap4.TEXT_SUCCESS).newLine();
        }
        TsPeriodSelector sel = new TsPeriodSelector();
        sel.last(freq * 3);
        ftest = SeasonalityTest.stableSeasonality((TsData)s.select(sel));
        val = ftest.getPValue();
        if (val < this.m_config.getSA3Severe()) {
            stream.write(HtmlTag.IMPORTANT_TEXT, "Residual seasonality present in the last 3 years at the " + 100.0 * this.m_config.getSA3Severe() + " per cent level: F=" + df4.format(ftest.getValue()), Bootstrap4.TEXT_DANGER).newLine();
        } else if (val < this.m_config.getSA3Bad()) {
            stream.write("Residual seasonality present in the last 3 years at the " + 100.0 * this.m_config.getSA3Bad() + " per cent level: F=" + df4.format(ftest.getValue()), Bootstrap4.TEXT_DANGER).newLine();
        } else if (val < this.m_config.getSA3Uncertain()) {
            stream.write("Residual seasonality present in the last 3 years at the " + 100.0 * this.m_config.getSA3Uncertain() + " per cent level: F=" + df4.format(ftest.getValue()), Bootstrap4.TEXT_WARNING).newLine();
        } else {
            stream.write("No evidence of residual seasonality in the last 3 years at the " + 100.0 * this.m_config.getSA3Uncertain() + " per cent level: F=" + df4.format(ftest.getValue()), Bootstrap4.TEXT_SUCCESS).newLine();
        }
        stream.newLine();
    }

    @Override
    public void write(HtmlStream stream) throws IOException {
        this.ResidualSeasonality(stream);
    }
}

