/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.html.implementation;

import ec.tss.html.AbstractHtmlElement;
import ec.tss.html.Bootstrap4;
import ec.tss.html.HtmlStream;
import ec.tss.html.HtmlTable;
import ec.tss.html.HtmlTableCell;
import ec.tss.html.HtmlTableHeader;
import ec.tss.html.HtmlTag;
import ec.tss.html.IHtmlElement;
import ec.tstoolkit.data.DescriptiveStatistics;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.timeseries.analysis.DiagnosticInfo;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import java.io.IOException;
import java.text.DecimalFormat;

public class HtmlRevisionsDocument
extends AbstractHtmlElement
implements IHtmlElement {
    private final TsData revisions_;
    private final DiagnosticInfo info_;
    private int threshold_ = 2;

    public HtmlRevisionsDocument(TsData revisions, DiagnosticInfo info) {
        this.revisions_ = revisions;
        this.info_ = info;
    }

    @Override
    public void write(HtmlStream stream) throws IOException {
        stream.write(HtmlTag.HEADER1, this.info_.toString());
        int y0 = this.revisions_.getDomain().getStart().getYear();
        int y1 = this.revisions_.getDomain().getLast().getYear();
        DescriptiveStatistics stats = new DescriptiveStatistics((IReadDataBlock)this.revisions_);
        double mean = stats.getAverage();
        double rmse = stats.getRmse();
        DecimalFormat format = new DecimalFormat("0.0000");
        stream.write(HtmlTag.EMPHASIZED_TEXT, "mean = " + format.format(mean)).newLine();
        stream.write(HtmlTag.EMPHASIZED_TEXT, "rmse = " + format.format(rmse)).newLines(2);
        int columnscount = 2 + y1 - y0;
        stream.open(new HtmlTable().withWidth(400));
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell(""));
        for (int i = y0; i <= y1; ++i) {
            stream.write(new HtmlTableHeader("" + i));
        }
        stream.close(HtmlTag.TABLEROW);
        format = new DecimalFormat("0.000");
        TsPeriod x = new TsPeriod(this.revisions_.getFrequency(), y0, 0);
        for (int i = 0; i < this.revisions_.getFrequency().intValue(); ++i) {
            stream.open(HtmlTag.TABLEROW);
            stream.write(new HtmlTableCell(x.getPeriodString()).withClass(Bootstrap4.FONT_WEIGHT_BOLD));
            for (int j = 1; j < columnscount; ++j) {
                String txt = "";
                boolean danger = false;
                int k = this.revisions_.getDomain().search(x.plus((j - 1) * this.revisions_.getFrequency().intValue()));
                if (k >= 0) {
                    double d = this.revisions_.get(k);
                    if (Math.abs(d) > (double)this.threshold_ * rmse) {
                        danger = true;
                    }
                    txt = format.format(this.revisions_.get(k));
                }
                if (danger) {
                    stream.write(new HtmlTableCell(txt).withClass(Bootstrap4.TEXT_DANGER));
                    continue;
                }
                stream.write(new HtmlTableCell(txt));
            }
            stream.close(HtmlTag.TABLEROW);
            x = x.plus(1);
        }
        stream.close(HtmlTag.TABLE);
    }

    public int getThreshold() {
        return this.threshold_;
    }

    public void setThreshold(int threshold) {
        this.threshold_ = threshold;
    }
}

