/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.html.implementation;

import ec.tss.html.AbstractHtmlElement;
import ec.tss.html.HtmlStream;
import ec.tss.html.IHtmlElement;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.SarimaSpecification;
import java.io.IOException;

public class HtmlSarimaModel
extends AbstractHtmlElement
implements IHtmlElement {
    private final SarimaModel model_;
    private final boolean diff_;

    public HtmlSarimaModel(SarimaModel model) {
        this.model_ = model;
        this.diff_ = false;
    }

    public HtmlSarimaModel(SarimaModel model, boolean showdiff) {
        this.model_ = model;
        this.diff_ = showdiff;
    }

    @Override
    public void write(HtmlStream stream) throws IOException {
        SarimaSpecification spec = this.model_.getSpecification();
        if (this.diff_) {
            stream.write("regular differencing order: " + Integer.toString(this.model_.getRegularDifferenceOrder())).newLine();
            stream.write("seasonal differencing order: " + Integer.toString(this.model_.getSeasonalDifferenceOrder())).newLines(2);
        }
        if (spec.getP() > 0) {
            stream.write("regular AR: " + this.model_.getRegularAR().toString('B', true)).newLine();
        }
        if (spec.getBP() > 0) {
            stream.write("seasonal AR: " + this.model_.getSeasonalAR().toString('S', true)).newLine();
        }
        if (spec.getQ() > 0) {
            stream.write("regular MA: " + this.model_.getRegularMA().toString('B', true)).newLine();
        }
        if (spec.getBQ() > 0) {
            stream.write("seasonal MA: " + this.model_.getSeasonalMA().toString('S', true)).newLine();
        }
    }
}

