/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.html.implementation;

import ec.tss.html.AbstractHtmlElement;
import ec.tss.html.Bootstrap4;
import ec.tss.html.HtmlStream;
import ec.tss.html.HtmlTag;
import ec.tss.html.IHtmlElement;
import ec.tstoolkit.data.Periodogram;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.SarimaSpecification;
import ec.tstoolkit.utilities.Arrays2;
import java.io.IOException;

public class HtmlSarimaPolynomials
extends AbstractHtmlElement
implements IHtmlElement {
    private final SarimaModel model_;
    private final boolean roots_;

    public HtmlSarimaPolynomials(SarimaModel model) {
        this.model_ = model;
        this.roots_ = true;
    }

    public HtmlSarimaPolynomials(SarimaModel model, boolean roots) {
        this.model_ = model;
        this.roots_ = roots;
    }

    @Override
    public void write(HtmlStream stream) throws IOException {
        Polynomial rar = this.model_.getRegularAR();
        SarimaSpecification spec = this.model_.getSpecification();
        stream.write(HtmlTag.IMPORTANT_TEXT, "Polynomials").newLines(2);
        if (spec.getP() > 0) {
            stream.write("regular AR: " + rar.toString('B', true)).newLine();
        }
        if (spec.getBP() > 0) {
            stream.write("seasonal AR: " + this.model_.getSeasonalAR().toString('S', true)).newLine();
        }
        if (spec.getQ() > 0) {
            stream.write("regular MA: " + this.model_.getRegularMA().toString('B', true)).newLine();
        }
        if (spec.getBQ() > 0) {
            stream.write("seasonal MA: " + this.model_.getSeasonalMA().toString('S', true)).newLine();
        }
        if (this.roots_) {
            Object[] roots = rar.roots();
            if (Arrays2.isNullOrEmpty((Object[])roots)) {
                return;
            }
            double[] arg = new double[roots.length];
            for (int i = 0; i < arg.length; ++i) {
                arg[i] = roots[i].arg();
            }
            stream.newLine().write(HtmlTag.IMPORTANT_TEXT, "Regular AR inverse roots").newLines(2);
            double[] td = Periodogram.getTradingDaysFrequencies((int)this.model_.getFrequency());
            for (int i = 0; i < arg.length; ++i) {
                boolean tdf = false;
                boolean sf = false;
                for (int j = 0; j < td.length; ++j) {
                    if (!(Math.abs(Math.abs(arg[i]) - td[j]) < 0.05235987755982988)) continue;
                    tdf = true;
                    break;
                }
                double sfreq = Math.PI * 2 / (double)this.model_.getFrequency();
                for (int j = 1; j <= this.model_.getFrequency() / 2; ++j) {
                    if (!(Math.abs(Math.abs(arg[i]) - (double)j * sfreq) < 0.05235987755982988)) continue;
                    sf = true;
                    break;
                }
                StringBuilder freq = new StringBuilder();
                freq.append("argument=").append(df4.format(arg[i])).append(", modulus=").append(df4.format(1.0 / roots[i].abs()));
                if (tdf) {
                    freq.append(" (td frequency)");
                } else if (sf) {
                    freq.append(" (seasonal frequency)");
                }
                stream.write(freq.toString(), tdf || sf ? Bootstrap4.TEXT_DANGER : Bootstrap4.TEXT_DARK).newLine();
            }
        }
    }
}

