/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.html.implementation;

import ec.satoolkit.diagnostics.FTest;
import ec.satoolkit.diagnostics.KruskalWallisTest;
import ec.tss.html.AbstractHtmlElement;
import ec.tss.html.Bootstrap4;
import ec.tss.html.HtmlClass;
import ec.tss.html.HtmlStream;
import ec.tss.html.HtmlTable;
import ec.tss.html.HtmlTableCell;
import ec.tss.html.HtmlTag;
import ec.tss.html.IHtmlElement;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.modelling.arima.tramo.SeasonalityTests;
import ec.tstoolkit.modelling.arima.tramo.SpectralPeaks;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.stats.AutoCorrelations;
import ec.tstoolkit.stats.StatisticalTest;
import ec.tstoolkit.timeseries.simplets.TsData;
import java.io.IOException;

public class HtmlSeasonalityDiagnostics
extends AbstractHtmlElement
implements IHtmlElement {
    private final SeasonalityTests tests;
    private final FTest ftest;
    private final FTest ftestAMI;
    private final boolean noSeasControl;
    private final KruskalWallisTest kwTest;

    public HtmlSeasonalityDiagnostics(SeasonalityTests tests) {
        this(tests, false);
    }

    public HtmlSeasonalityDiagnostics(SeasonalityTests tests, boolean noSeasControl) {
        this.tests = tests;
        this.noSeasControl = noSeasControl;
        if (tests != null) {
            this.ftest = new FTest();
            this.ftest.test(tests.getDifferencing().getRestrictedOriginal());
            this.ftestAMI = new FTest();
            this.ftestAMI.testAMI(tests.getDifferencing().getRestrictedOriginal());
            this.kwTest = new KruskalWallisTest(tests.getDifferencing().getDifferenced());
        } else {
            this.ftest = null;
            this.ftestAMI = null;
            this.kwTest = null;
        }
    }

    @Override
    public void write(HtmlStream stream) throws IOException {
        if (this.tests != null) {
            this.writeSummary(stream);
            this.writeQS(stream);
            this.writeFriedman(stream);
            this.writeKruskalWallis(stream);
            this.writeSpectrum(stream);
            this.writePeriodogram(stream);
            this.writeFTest(stream);
            this.writeFTestAMI(stream);
        } else {
            stream.write("Series can't be tested");
        }
    }

    public void writeTransformation(HtmlStream stream) throws IOException {
        if (this.tests.getDifferencing().isMean() && this.tests.getDifferencing().getDifferencingOrder() == 1) {
            stream.write(HtmlTag.EMPHASIZED_TEXT, "Data have been differenced and corrected for mean").newLines(2);
        } else if (this.tests.getDifferencing().getDifferencingOrder() > 0) {
            stream.write(HtmlTag.EMPHASIZED_TEXT, "Data have been differenced " + this.tests.getDifferencing().getDifferencingOrder() + " times").newLine();
            if (this.tests.getDifferencing().isMean()) {
                stream.write(HtmlTag.EMPHASIZED_TEXT, "Data have been corrected for mean").newLine();
            }
            stream.newLine();
        }
    }

    public void writeQS(HtmlStream stream) throws IOException {
        stream.write(HtmlTag.HEADER4, "1. Tests on autocorrelations at seasonal lags").newLine();
        this.writeSummary(stream, this.tests.getQs().getPValue());
        stream.newLines(2);
        AutoCorrelations ac = new AutoCorrelations((IReadDataBlock)this.tests.getDifferencing().getDifferenced());
        int ifreq = this.tests.getDifferencing().getOriginal().getFrequency().intValue();
        stream.write("ac(").write(ifreq).write(")=").write(df4.format(ac.autoCorrelation(ifreq))).newLine();
        stream.write("ac(").write(2 * ifreq).write(")=").write(df4.format(ac.autoCorrelation(2 * ifreq))).newLines(2);
        stream.write("Distribution: " + this.tests.getQs().getDistribution().getDescription()).newLine();
        stream.write("Value: " + df4.format(this.tests.getQs().getValue())).newLine();
        stream.write("PValue: " + df4.format(this.tests.getQs().getPValue()));
        stream.write(HtmlTag.LINEBREAK);
    }

    public void writeFTest(HtmlStream stream) throws IOException {
        stream.write(HtmlTag.HEADER4, "6. Tests on regression with fixed seasonal dummies ").newLine();
        stream.write(HtmlTag.EMPHASIZED_TEXT, "Regression model (on original series) with (0 1 1)(0 0 0) noises + mean").newLine();
        this.writeSummary(stream, this.ftest.getFTest().getPValue());
        stream.newLines(2);
        stream.write("Distribution: " + this.ftest.getFTest().getDistribution().getDescription()).newLine();
        stream.write("Value: " + df4.format(this.ftest.getFTest().getValue())).newLine();
        stream.write("PValue: " + df4.format(this.ftest.getFTest().getPValue()));
        stream.write(HtmlTag.LINEBREAK);
    }

    public void writeFTestAMI(HtmlStream stream) throws IOException {
        stream.write(HtmlTag.HEADER4, "6bis. Tests on regression with fixed seasonal dummies ").newLine();
        stream.write(HtmlTag.EMPHASIZED_TEXT, "Regression model (on original series) with ARIMA automatically identified").newLine();
        stream.write(HtmlTag.EMPHASIZED_TEXT, "model is: " + ((SarimaModel)this.ftestAMI.getEstimatedModel().model.getArima()).toString()).newLine();
        this.writeSummary(stream, this.ftestAMI.getFTest().getPValue());
        stream.newLines(2);
        stream.write("Distribution: " + this.ftestAMI.getFTest().getDistribution().getDescription()).newLine();
        stream.write("Value: " + df4.format(this.ftestAMI.getFTest().getValue())).newLine();
        stream.write("PValue: " + df4.format(this.ftestAMI.getFTest().getPValue()));
        stream.write(HtmlTag.LINEBREAK);
    }

    public void writeFriedman(HtmlStream stream) throws IOException {
        stream.write(HtmlTag.HEADER4, "2. Non parametric (Friedman) test");
        stream.write(HtmlTag.EMPHASIZED_TEXT, "Based on the rank of the observations in each year").newLines(2);
        this.writeSummary(stream, this.tests.getNonParametricTest().getPValue());
        stream.newLine();
        stream.write("Distribution: " + this.tests.getNonParametricTest().getDistribution().getDescription()).newLine();
        stream.write("Value: " + df4.format(this.tests.getNonParametricTest().getValue())).newLine();
        stream.write("PValue: " + df4.format(this.tests.getNonParametricTest().getPValue()));
        stream.write(HtmlTag.LINEBREAK);
    }

    public void writeKruskalWallis(HtmlStream stream) throws IOException {
        stream.write(HtmlTag.HEADER4, "3. Non parametric (Kruskal-Wallis) test");
        stream.write(HtmlTag.EMPHASIZED_TEXT, "Based on the rank of the observations").newLines(2);
        this.writeSummary(stream, this.kwTest.getPValue());
        stream.newLine();
        stream.write("Distribution: " + this.kwTest.getDistribution().getDescription()).newLine();
        stream.write("Value: " + df4.format(this.kwTest.getValue())).newLine();
        stream.write("PValue: " + df4.format(this.kwTest.getPValue()));
        stream.write(HtmlTag.LINEBREAK);
    }

    public void writeSpectrum(HtmlStream stream) throws IOException {
        if (this.tests.getSpectralPeaks() == null) {
            return;
        }
        stream.write(HtmlTag.HEADER4, "4. Identification of seasonal peaks in a Tukey periodogram and in an auto-regressive spectrum");
        int diag = 1;
        if (SpectralPeaks.hasHighSeasonalPeaks((SpectralPeaks[])this.tests.getSpectralPeaks())) {
            diag = -1;
        } else if (SpectralPeaks.hasSeasonalPeaks((SpectralPeaks[])this.tests.getSpectralPeaks())) {
            diag = 0;
        }
        stream.newLine();
        this.writeSummary(stream, diag);
        stream.newLines(2);
        stream.write(HtmlTag.EMPHASIZED_TEXT, "T or t for Tukey periodogram, A or a for auto-regressive spectrum; 'T' or 'A' for very signficant peaks, 't' or 'a' for signficant peaks, '_' otherwise").newLines(2);
        stream.newLine();
        stream.write(SpectralPeaks.format((SpectralPeaks[])this.tests.getSpectralPeaks()));
        stream.write(HtmlTag.LINEBREAK);
    }

    public void writePeriodogram(HtmlStream stream) throws IOException {
        stream.write(HtmlTag.HEADER4, "5. Periodogram");
        stream.write(HtmlTag.EMPHASIZED_TEXT, "Test on the sum of the values of a periodogram at seasonal frequencies").newLines(2);
        stream.newLine();
        StatisticalTest test = this.tests.getPeriodogramTest();
        this.writeSummary(stream, test.getPValue());
        stream.newLines(2);
        stream.write("Distribution: " + test.getDistribution().getDescription()).newLine();
        stream.write("Value: " + df4.format(test.getValue())).newLine();
        stream.write("PValue: " + df4.format(test.getPValue()));
        stream.write(HtmlTag.LINEBREAK);
    }

    private void writeSummary(HtmlStream stream) throws IOException {
        stream.write(HtmlTag.HEADER4, "Summary");
        this.writeTransformation(stream);
        stream.open(new HtmlTable().withWidth(300));
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell("Test").withWidth(250));
        stream.write(new HtmlTableCell("Seasonality").withWidth(50));
        stream.close(HtmlTag.TABLEROW);
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell("1. Auto-correlations at seasonal lags").withWidth(250));
        stream.write(this.getCellSummary(this.tests.getQs().getPValue(), 50));
        stream.close(HtmlTag.TABLEROW);
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell("2. Friedman (non parametric)").withWidth(250));
        stream.write(this.getCellSummary(this.tests.getNonParametricTest().getPValue(), 50));
        stream.close(HtmlTag.TABLEROW);
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell("3. Kruskall-Wallis (non parametric)").withWidth(250));
        stream.write(this.getCellSummary(this.kwTest.getPValue(), 50));
        stream.close(HtmlTag.TABLEROW);
        if (this.tests.getSpectralPeaks() != null) {
            int diag = 1;
            if (SpectralPeaks.hasHighSeasonalPeaks((SpectralPeaks[])this.tests.getSpectralPeaks())) {
                diag = -1;
            } else if (SpectralPeaks.hasSeasonalPeaks((SpectralPeaks[])this.tests.getSpectralPeaks())) {
                diag = 0;
            }
            stream.open(HtmlTag.TABLEROW);
            stream.write(new HtmlTableCell("4. Spectral peaks").withWidth(250));
            stream.write(this.getCellSummary(diag, 50));
            stream.close(HtmlTag.TABLEROW);
        }
        TsData ddata = this.tests.getDifferencing().getDifferenced();
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell("5. Periodogram ").withWidth(250));
        stream.write(this.getCellSummary(this.tests.getPeriodogramTest().getPValue(), 50));
        stream.close(HtmlTag.TABLEROW);
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell("6. Seasonal dummies").withWidth(250));
        stream.write(this.getCellSummary(this.ftest.getFTest().getPValue(), 50));
        stream.close(HtmlTag.TABLEROW);
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell("6bis. Seasonal dummies (AMI)").withWidth(250));
        stream.write(this.getCellSummary(this.ftestAMI.getFTest().getPValue(), 50));
        stream.close(HtmlTag.TABLEROW);
        stream.close(HtmlTag.TABLE);
        stream.write(HtmlTag.LINEBREAK);
    }

    private void writeSummary(HtmlStream stream, double pval) throws IOException {
        int val = pval > 0.05 ? 1 : (pval > 0.01 ? 0 : -1);
        this.writeSummary(stream, val);
    }

    private void writeSummary(HtmlStream stream, int val) throws IOException {
        if (this.noSeasControl) {
            if (val < 0) {
                stream.write(HtmlTag.IMPORTANT_TEXT, "Seasonality present", Bootstrap4.TEXT_DANGER);
            } else if (val == 0) {
                stream.write("Seasonality perhaps present", Bootstrap4.TEXT_WARNING);
            } else {
                stream.write("Seasonality not present", Bootstrap4.TEXT_SUCCESS);
            }
        } else if (val < 0) {
            stream.write("Seasonality present", Bootstrap4.TEXT_SUCCESS);
        } else if (val == 0) {
            stream.write("Seasonality perhaps present", Bootstrap4.TEXT_WARNING);
        } else {
            stream.write(HtmlTag.IMPORTANT_TEXT, "Seasonality not present", Bootstrap4.TEXT_DANGER);
        }
    }

    private HtmlTableCell getCellSummary(double pval, int l) throws IOException {
        int val = pval > 0.05 ? 1 : (pval > 0.01 ? 0 : -1);
        return this.getCellSummary(val, l);
    }

    private HtmlTableCell getCellSummary(int val, int l) throws IOException {
        HtmlClass style;
        String txt;
        if (this.noSeasControl) {
            if (val < 0) {
                txt = "YES";
                style = Bootstrap4.TEXT_DANGER;
            } else if (val == 0) {
                txt = "?";
                style = Bootstrap4.TEXT_WARNING;
            } else {
                txt = "NO";
                style = Bootstrap4.TEXT_SUCCESS;
            }
        } else if (val < 0) {
            txt = "YES";
            style = Bootstrap4.TEXT_SUCCESS;
        } else if (val == 0) {
            txt = "?";
            style = Bootstrap4.TEXT_WARNING;
        } else {
            txt = "NO";
            style = Bootstrap4.TEXT_DANGER;
        }
        return new HtmlTableCell(txt).withWidth(l).withClass(style);
    }
}

