/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.html.implementation;

import ec.satoolkit.DecompositionMode;
import ec.satoolkit.ISeriesDecomposition;
import ec.satoolkit.diagnostics.CombinedSeasonalityTest;
import ec.satoolkit.diagnostics.FriedmanTest;
import ec.satoolkit.diagnostics.KruskalWallisTest;
import ec.satoolkit.diagnostics.ResidualSeasonalityDiagnostics;
import ec.satoolkit.diagnostics.SeasonalityTest;
import ec.tss.html.AbstractHtmlElement;
import ec.tss.html.Bootstrap4;
import ec.tss.html.HtmlClass;
import ec.tss.html.HtmlStream;
import ec.tss.html.HtmlTable;
import ec.tss.html.HtmlTableCell;
import ec.tss.html.HtmlTag;
import ec.tstoolkit.modelling.ComponentInformation;
import ec.tstoolkit.modelling.ComponentType;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import java.io.IOException;

public class HtmlSeasonalityTest
extends AbstractHtmlElement {
    private TsData m_si;
    private CombinedSeasonalityTest m_stests;
    private FriedmanTest m_ftest;
    private double m_badthreshold = 0.1;
    private double m_goodthresohold = 0.01;
    private ResidualSeasonalityDiagnostics.Configuration m_config = ResidualSeasonalityDiagnostics.defaultConfiguration.clone();

    public HtmlSeasonalityTest(ISeriesDecomposition output) {
        TsData s = output.getSeries(ComponentType.Seasonal, ComponentInformation.Value);
        TsData i = output.getSeries(ComponentType.Irregular, ComponentInformation.Value);
        if (s == null || s.getFrequency() == TsFrequency.Yearly) {
            return;
        }
        boolean mul = output.getMode() != DecompositionMode.Additive;
        this.m_si = mul ? TsData.multiply((TsData)s, (TsData)i) : TsData.add((TsData)s, (TsData)i);
        this.m_stests = new CombinedSeasonalityTest(this.m_si, mul);
        this.m_ftest = new FriedmanTest(this.m_si);
    }

    public HtmlSeasonalityTest(TsData si, boolean mul) {
        if (si == null || si.getFrequency() == TsFrequency.Yearly) {
            return;
        }
        this.m_si = si;
        this.m_stests = new CombinedSeasonalityTest(this.m_si, mul);
        this.m_ftest = new FriedmanTest(this.m_si);
    }

    public void CombinedSeasonalityTest(HtmlStream stream) throws IOException {
        stream.write(HtmlTag.HEADER1, "Combined seasonality test").newLine();
        switch (this.m_stests.getSummary()) {
            case None: {
                stream.write(HtmlTag.IMPORTANT_TEXT, "Identifiable seasonality not present", Bootstrap4.TEXT_DANGER);
                break;
            }
            case ProbablyNone: {
                stream.write("Identifiable seasonality probably not present", Bootstrap4.TEXT_WARNING);
                break;
            }
            case Present: {
                stream.write("Identifiable seasonality present", Bootstrap4.TEXT_SUCCESS);
            }
        }
        stream.newLines(2);
    }

    public void EvolutionSeasonalityTest(HtmlStream stream) throws IOException {
        stream.write(HtmlTag.HEADER1, "Evolutive seasonality test").newLine();
        SeasonalityTest stest = this.m_stests.getEvolutiveSeasonality();
        stream.open(new HtmlTable().withWidth(400));
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell("").withWidth(100));
        stream.write(new HtmlTableCell("Sum of squares").withWidth(100));
        stream.write(new HtmlTableCell("Degrees of freedom").withWidth(100));
        stream.write(new HtmlTableCell("Mean square").withWidth(100));
        stream.close(HtmlTag.TABLEROW);
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell("Between years").withWidth(100).withClass(Bootstrap4.FONT_ITALIC));
        stream.write(new HtmlTableCell(Double.toString(stest.getSSM())).withWidth(100));
        stream.write(new HtmlTableCell(Double.toString(stest.getDFInterPeriod())).withWidth(100));
        stream.write(new HtmlTableCell(Double.toString(stest.getSSM() / (double)stest.getDFInterPeriod())).withWidth(100));
        stream.close(HtmlTag.TABLEROW);
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell("Error").withWidth(100).withClass(Bootstrap4.FONT_ITALIC));
        stream.write(new HtmlTableCell(Double.toString(stest.getSSR())).withWidth(100));
        stream.write(new HtmlTableCell(Double.toString(stest.getDFResidual())).withWidth(100));
        stream.write(new HtmlTableCell(Double.toString(stest.getSSR() / (double)stest.getDFResidual())).withWidth(100));
        stream.close(HtmlTag.TABLE).newLines(2);
        stream.write("Value: " + stest.getValue()).newLine();
        stream.write("Distribution: " + stest.getDistribution().getDescription()).newLine();
        stream.write("PValue: " + df4.format(stest.getPValue()), this.getRPValueClass(stest.getPValue(), 0.01, 0.05)).newLine();
        if (stest.getPValue() > 0.2) {
            stream.write("No evidence of moving seasonality at the 20 per cent level").newLines(2);
        } else if (stest.getPValue() < 0.05) {
            stream.write(HtmlTag.IMPORTANT_TEXT, "Moving seasonality present at the 5 per cent level").newLines(2);
        }
    }

    public void FKWTests(HtmlStream stream) throws IOException {
        stream.write(HtmlTag.HEADER1, "Non parametric tests for stable seasonality").newLine();
        stream.write(HtmlTag.HEADER2, "Friedman test").newLine();
        stream.write("Friedman statistic = " + df4.format(this.m_ftest.getValue())).newLine();
        stream.write("Distribution: " + this.m_ftest.getDistribution().toString()).newLine();
        stream.write("P-Value: ").write(df4.format(this.m_ftest.getPValue()), this.getPValueClass(this.m_ftest.getPValue())).newLines(2);
        if (this.m_ftest.getPValue() < 0.01) {
            stream.write("Stable seasonality present at the 1 per cent level").newLines(2);
        } else if (this.m_ftest.getPValue() > 0.05) {
            stream.write("No evidence of stable seasonality at the 5 per cent level").newLines(2);
        }
        stream.write(HtmlTag.HEADER2, "Kruskall-Wallis test").newLine();
        KruskalWallisTest kw = this.m_stests.getNonParametricTestForStableSeasonality();
        stream.write("Kruskall-Wallis statistic = " + Double.toString(kw.getValue())).newLine();
        stream.write("Distribution: " + kw.getDistribution().toString()).newLine();
        stream.write("P-Value: ").write(df4.format(kw.getPValue()), this.getPValueClass(kw.getPValue())).newLine();
        if (kw.getPValue() < 0.01) {
            stream.write("Stable seasonality present at the 1 per cent level").newLines(2);
        } else if (kw.getPValue() > 0.05) {
            stream.write("No evidence of stable seasonality at the 5 per cent level").newLines(2);
        }
    }

    private HtmlClass getPValueClass(double val) {
        if (val > this.m_badthreshold) {
            return Bootstrap4.TEXT_DANGER;
        }
        if (val > this.m_goodthresohold) {
            return Bootstrap4.TEXT_WARNING;
        }
        return Bootstrap4.TEXT_SUCCESS;
    }

    private HtmlClass getRPValueClass(double val, double lb, double ub) {
        if (val < ub) {
            return Bootstrap4.TEXT_DANGER;
        }
        if (val < lb) {
            return Bootstrap4.TEXT_WARNING;
        }
        return Bootstrap4.TEXT_SUCCESS;
    }

    public void StableSeasonalityTest(HtmlStream stream) throws IOException {
        stream.write(HtmlTag.HEADER1, "Test for the presence of seasonality assuming stability").newLine();
        SeasonalityTest stest = this.m_stests.getStableSeasonality();
        stream.open(new HtmlTable().withWidth(400));
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell("").withWidth(100));
        stream.write(new HtmlTableCell("Sum of squares").withWidth(100));
        stream.write(new HtmlTableCell("Degrees of freedom").withWidth(100));
        stream.write(new HtmlTableCell("Mean square").withWidth(100));
        stream.close(HtmlTag.TABLEROW);
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell("Between periods").withWidth(100).withClass(Bootstrap4.FONT_ITALIC));
        stream.write(new HtmlTableCell(Double.toString(stest.getSSM())).withWidth(100));
        stream.write(new HtmlTableCell(Double.toString(stest.getDFInterPeriod())).withWidth(100));
        stream.write(new HtmlTableCell(Double.toString(stest.getSSM() / (double)stest.getDFInterPeriod())).withWidth(100));
        stream.close(HtmlTag.TABLEROW);
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell("Residual").withWidth(100).withClass(Bootstrap4.FONT_ITALIC));
        stream.write(new HtmlTableCell(Double.toString(stest.getSSR())).withWidth(100));
        stream.write(new HtmlTableCell(Double.toString(stest.getDFResidual())).withWidth(100));
        stream.write(new HtmlTableCell(Double.toString(stest.getSSR() / (double)stest.getDFResidual())).withWidth(100));
        stream.close(HtmlTag.TABLEROW);
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell("Total").withWidth(100).withClass(Bootstrap4.FONT_ITALIC));
        stream.write(new HtmlTableCell(Double.toString(stest.getSSQ())).withWidth(100));
        stream.write(new HtmlTableCell(Double.toString(stest.getDFTot())).withWidth(100));
        stream.write(new HtmlTableCell(Double.toString(stest.getSSQ() / (double)stest.getDFTot())).withWidth(100));
        stream.close(HtmlTag.TABLEROW);
        stream.close(HtmlTag.TABLE).newLine();
        stream.write("Value: " + stest.getValue()).newLine();
        stream.write("Distribution: " + stest.getDistribution().getDescription()).newLine();
        stream.write("PValue: " + df4.format(stest.getPValue()), this.getPValueClass(stest.getPValue())).newLine();
        if (stest.getPValue() < 0.01) {
            stream.write("Seasonality present at the 1 per cent level").newLines(2);
        } else if (stest.getPValue() > 0.05) {
            stream.write(HtmlTag.IMPORTANT_TEXT, "No evidence of seasonality at the 5 per cent level").newLines(2);
        }
    }

    @Override
    public void write(HtmlStream stream) throws IOException {
        if (this.m_si == null) {
            stream.write("Series can't be tested");
            return;
        }
        this.FKWTests(stream);
        this.StableSeasonalityTest(stream);
        this.EvolutionSeasonalityTest(stream);
        this.CombinedSeasonalityTest(stream);
    }
}

