/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.html.implementation;

import ec.tss.html.CssProperty;
import ec.tss.html.CssStyle;
import ec.tss.html.HtmlClass;
import ec.tss.html.HtmlStream;
import ec.tss.html.HtmlTable;
import ec.tss.html.HtmlTag;
import ec.tss.html.IHtmlElement;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDataBlock;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import ec.tstoolkit.timeseries.simplets.YearIterator;
import java.io.IOException;
import java.util.Formatter;

public class HtmlSingleTsData
implements IHtmlElement {
    public static final HtmlClass ROW_HEADERS_CLASS = HtmlClass.of("tsdata-row-header");
    private CssStyle rowHeaders;
    private String fmt = "%.3f";
    private TsData m_ts;
    private String m_name;
    @Deprecated
    public static final CssStyle defaultrowHeaders = new CssStyle();

    public HtmlSingleTsData(TsData ts, String name) {
        this.m_ts = ts;
        this.m_name = name;
    }

    public String getFormat() {
        return this.fmt;
    }

    @Deprecated
    public CssStyle getRowHeadersStyle() {
        return this.rowHeaders;
    }

    public void setFormat(String fmt) {
        this.fmt = fmt;
    }

    @Deprecated
    public void setRowHeadersStyle(CssStyle rowHeaders) {
        this.rowHeaders = rowHeaders;
    }

    @Override
    public void write(HtmlStream stream) throws IOException {
        if (this.m_name != null) {
            stream.write(HtmlTag.HEADER3, this.m_name);
        }
        stream.open(new HtmlTable().withWidth(100));
        stream.open(HtmlTag.TABLEHEADER);
        for (int i = 0; i < this.m_ts.getFrequency().intValue(); ++i) {
            stream.write(HtmlTag.TABLECELL, TsPeriod.formatShortPeriod((TsFrequency)this.m_ts.getFrequency(), (int)i));
        }
        stream.close(HtmlTag.TABLEHEADER);
        int nfreq = this.m_ts.getFrequency().intValue();
        YearIterator iter = new YearIterator(this.m_ts);
        while (iter.hasMoreElements()) {
            int i;
            stream.open(HtmlTag.TABLEROW);
            TsDataBlock block = iter.nextElement();
            if (this.rowHeaders != null) {
                stream.write(HtmlTag.TABLECELL, this.rowHeaders, Integer.toString(block.start.getYear()));
            } else {
                stream.open(HtmlTag.TABLECELL, ROW_HEADERS_CLASS);
                stream.write(Integer.toString(block.start.getYear()));
                stream.close(HtmlTag.TABLECELL);
            }
            int start = block.start.getPosition();
            int n = block.data.getLength();
            for (i = 0; i < start; ++i) {
                stream.write(HtmlTag.TABLECELL);
            }
            for (i = 0; i < n; ++i) {
                if (Double.isFinite(block.data.get(i))) {
                    Formatter formatter = new Formatter();
                    formatter.format(this.fmt, block.data.get(i));
                    stream.write(HtmlTag.TABLECELL, formatter.toString());
                    continue;
                }
                stream.write(HtmlTag.TABLECELL, ".");
            }
            for (i = start + n; i < nfreq; ++i) {
                stream.write(HtmlTag.TABLECELL);
            }
            stream.close(HtmlTag.TABLEROW);
        }
        stream.close(HtmlTag.TABLE);
    }

    static {
        defaultrowHeaders.add(CssProperty.FONT_STYLE, "italic");
        defaultrowHeaders.add(CssProperty.MARGIN_LEFT, "10 px");
        defaultrowHeaders.add(CssProperty.MARGIN_RIGHT, "10 px");
    }
}

