/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.html.implementation;

import ec.tss.html.AbstractHtmlElement;
import ec.tss.html.Bootstrap4;
import ec.tss.html.HtmlClass;
import ec.tss.html.HtmlStream;
import ec.tss.html.HtmlTable;
import ec.tss.html.HtmlTableCell;
import ec.tss.html.HtmlTag;
import ec.tss.html.IHtmlElement;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DescriptiveStatistics;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.timeseries.analysis.DiagnosticInfo;
import ec.tstoolkit.timeseries.analysis.SlidingSpans;
import ec.tstoolkit.timeseries.simplets.PeriodIterator;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDataBlock;
import ec.tstoolkit.timeseries.simplets.YearIterator;
import java.io.IOException;
import java.text.DecimalFormat;

public class HtmlSlidingSpanDocument
extends AbstractHtmlElement
implements IHtmlElement {
    private SlidingSpans slidingspans_;
    private String name_;
    private DiagnosticInfo info_;
    private double threshold_ = 0.03;

    public HtmlSlidingSpanDocument(SlidingSpans slidingspans, String name, DiagnosticInfo info) {
        this.slidingspans_ = slidingspans;
        this.name_ = name;
        this.info_ = info;
    }

    @Override
    public void write(HtmlStream stream) throws IOException {
        TsData s = this.slidingspans_.Statistics(this.name_, this.info_);
        if (s == null || s.getMissingValuesCount() == s.getLength()) {
            return;
        }
        DescriptiveStatistics stats = new DescriptiveStatistics((IReadDataBlock)new DataBlock(s.internalStorage()));
        if (stats.getMax() == stats.getMin() || stats.getMax() == 0.0) {
            return;
        }
        stream.write("Abnormal values : ");
        DecimalFormat format = new DecimalFormat("0.0");
        int nabnormal = stats.countBetween(this.threshold_, Double.MAX_VALUE);
        double mabnormal = stats.getAverage();
        double p = (double)nabnormal * 100.0 / (double)stats.getObservationsCount();
        stream.write(format.format(p) + "%").newLines(2);
        if (nabnormal != 0) {
            String title = "";
            title = this.info_ == DiagnosticInfo.AbsoluteDifference || this.info_ == DiagnosticInfo.PeriodToPeriodDifference ? "Breakdowns of unstable factors and Average Maximum Differences across spans" : "Breakdowns of unstable factors and Average Maximum Percent Differences across spans";
            stream.write(HtmlTag.IMPORTANT_TEXT, title, Bootstrap4.TEXT_INFO).newLines(2);
            PeriodIterator iter = new PeriodIterator(s);
            int freq = s.getFrequency().intValue();
            stream.open(new HtmlTable().withWidth(300));
            stream.open(HtmlTag.TABLEROW);
            stream.write(new HtmlTableCell("Period").withClass(Bootstrap4.FONT_ITALIC));
            stream.write(new HtmlTableCell("Breakdowns").withClass(Bootstrap4.FONT_ITALIC));
            stream.write(new HtmlTableCell("Average").withClass(Bootstrap4.FONT_ITALIC));
            stream.close(HtmlTag.TABLEROW);
            double nbold = 2 * nabnormal;
            nbold /= (double)freq;
            while (iter.hasMoreElements()) {
                TsDataBlock block = iter.nextElement();
                DescriptiveStatistics desc = new DescriptiveStatistics((IReadDataBlock)block.data);
                int n = desc.countBetween(this.threshold_, Double.MAX_VALUE);
                double m = desc.getAverage();
                boolean bold = (double)n > nbold | m > 2.0 * mabnormal;
                HtmlClass style = bold ? Bootstrap4.FONT_WEIGHT_BOLD : HtmlClass.NO_CLASS;
                stream.open(HtmlTag.TABLEROW);
                stream.write(new HtmlTableCell(block.start.getPeriodString()).withClass(style));
                stream.write(new HtmlTableCell(n + "").withClass(style));
                if (this.info_ == DiagnosticInfo.AbsoluteDifference || this.info_ == DiagnosticInfo.PeriodToPeriodDifference) {
                    stream.write(new HtmlTableCell(format.format(m)).withClass(style));
                } else {
                    stream.write(new HtmlTableCell(format.format(100.0 * m)).withClass(style));
                }
                stream.close(HtmlTag.TABLEROW);
            }
            stream.close(HtmlTag.TABLE).newLines(2);
            int y0 = s.getDomain().getStart().getYear();
            int y1 = s.getDomain().getLast().getYear();
            stream.open(new HtmlTable().withWidth(300));
            stream.open(HtmlTag.TABLEROW);
            stream.write(new HtmlTableCell("Year").withClass(Bootstrap4.FONT_ITALIC));
            stream.write(new HtmlTableCell("Breakdowns").withClass(Bootstrap4.FONT_ITALIC));
            stream.write(new HtmlTableCell("Average").withClass(Bootstrap4.FONT_ITALIC));
            stream.close(HtmlTag.TABLEROW);
            nbold = 2 * nabnormal;
            nbold /= (double)(y1 - y0 + 1);
            YearIterator yiter = new YearIterator(s);
            while (yiter.hasMoreElements()) {
                TsDataBlock block = yiter.nextElement();
                DescriptiveStatistics desc = new DescriptiveStatistics((IReadDataBlock)block.data);
                int n = desc.countBetween(this.threshold_, Double.MAX_VALUE);
                double m = desc.getAverage();
                boolean bold = (double)n > nbold | m > 2.0 * mabnormal;
                HtmlClass style = bold ? Bootstrap4.FONT_WEIGHT_BOLD : HtmlClass.NO_CLASS;
                stream.open(HtmlTag.TABLEROW);
                stream.write(new HtmlTableCell(block.start.getYear() + "").withClass(style));
                stream.write(new HtmlTableCell(n + "").withClass(style));
                if (this.info_ == DiagnosticInfo.AbsoluteDifference || this.info_ == DiagnosticInfo.PeriodToPeriodDifference) {
                    stream.write(new HtmlTableCell(format.format(m)).withClass(style));
                } else {
                    stream.write(new HtmlTableCell(format.format(100.0 * m)).withClass(style));
                }
                stream.close(HtmlTag.TABLEROW);
            }
            stream.close(HtmlTag.TABLE);
        }
    }

    public double getThreshold() {
        return this.threshold_;
    }

    public void setThreshold(double threshold) {
        this.threshold_ = threshold;
    }
}

