/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.html.implementation;

import ec.satoolkit.DecompositionMode;
import ec.satoolkit.diagnostics.CombinedSeasonalityTest;
import ec.tss.html.AbstractHtmlElement;
import ec.tss.html.Bootstrap4;
import ec.tss.html.HtmlStream;
import ec.tss.html.HtmlTable;
import ec.tss.html.HtmlTableCell;
import ec.tss.html.HtmlTag;
import ec.tss.html.IHtmlElement;
import ec.tstoolkit.stats.StatisticalTest;
import ec.tstoolkit.timeseries.analysis.SlidingSpans;
import ec.tstoolkit.timeseries.simplets.PeriodIterator;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDataBlock;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import java.io.IOException;
import java.text.DecimalFormat;

public class HtmlSlidingSpanSummary
extends AbstractHtmlElement
implements IHtmlElement {
    private final SlidingSpans slidingspans_;
    private String sname_ = "s_cmp";
    private String siname_ = "si_lin";

    public HtmlSlidingSpanSummary(SlidingSpans slidingspans) {
        this.slidingspans_ = slidingspans;
    }

    public HtmlSlidingSpanSummary(SlidingSpans slidingspans, String sname, String siname) {
        this.slidingspans_ = slidingspans;
        this.sname_ = sname;
        this.siname_ = siname;
    }

    @Override
    public void write(HtmlStream stream) throws IOException {
        int i;
        int ncols = this.slidingspans_.getSpanCount();
        if (ncols <= 1) {
            return;
        }
        TsFrequency freq = this.slidingspans_.getReferenceDomain().getFrequency();
        stream.write(HtmlTag.HEADER1, "Sliding spans summary");
        stream.write(HtmlTag.HEADER2, "Time spans");
        TsPeriod p = new TsPeriod(freq);
        for (int i2 = 0; i2 < this.slidingspans_.getSpanCount(); ++i2) {
            TsDomain domain = this.slidingspans_.getDomain(i2);
            stream.write("Span " + (i2 + 1) + ": from " + domain.getStart() + " to " + domain.getLast()).newLine();
        }
        CombinedSeasonalityTest[] tests = new CombinedSeasonalityTest[ncols];
        PeriodIterator[] siter = new PeriodIterator[ncols];
        TsData[] s = new TsData[ncols];
        for (i = 0; i < ncols; ++i) {
            TsData si;
            s[i] = (TsData)this.slidingspans_.info(i).getData(this.sname_, TsData.class);
            if (s[i] != null) {
                siter[i] = new PeriodIterator(s[i]);
            }
            if ((si = (TsData)this.slidingspans_.info(i).getData(this.siname_, TsData.class)) == null) continue;
            DecompositionMode mode = (DecompositionMode)this.slidingspans_.info(i).getData("mode", DecompositionMode.class);
            tests[i] = new CombinedSeasonalityTest(si, mode != null ? mode != DecompositionMode.Additive : false);
        }
        stream.newLine().write(HtmlTag.HEADER2, "Tests for seasonality");
        stream.open(new HtmlTable().withWidth(400));
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell(""));
        for (i = 1; i <= ncols; ++i) {
            stream.write(new HtmlTableCell("Span " + i).withClass(Bootstrap4.FONT_ITALIC));
        }
        stream.close(HtmlTag.TABLEROW);
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell("Stable seas.").withClass(Bootstrap4.FONT_ITALIC));
        for (i = 0; i < ncols; ++i) {
            stream.write(this.SeasonalityCell((StatisticalTest)tests[i].getStableSeasonality()));
        }
        stream.close(HtmlTag.TABLEROW);
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell("Kruskal-Wallis").withClass(Bootstrap4.FONT_ITALIC));
        for (i = 0; i < ncols; ++i) {
            stream.write(this.SeasonalityCell((StatisticalTest)tests[i].getNonParametricTestForStableSeasonality()));
        }
        stream.close(HtmlTag.TABLEROW);
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell("Moving seas.").withClass(Bootstrap4.FONT_ITALIC));
        for (i = 0; i < ncols; ++i) {
            stream.write(this.MovingSeasonalityCell((StatisticalTest)tests[i].getEvolutiveSeasonality()));
        }
        stream.close(HtmlTag.TABLEROW);
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell("Identifiable seas.").withClass(Bootstrap4.FONT_ITALIC));
        for (i = 0; i < ncols; ++i) {
            stream.write(this.IdentifiableCell(tests[i]));
        }
        stream.close(HtmlTag.TABLEROW);
        stream.close(HtmlTag.TABLE);
        DecompositionMode mode = (DecompositionMode)this.slidingspans_.getReferenceInfo().getData("mode", DecompositionMode.class);
        boolean mul = mode == DecompositionMode.Multiplicative;
        stream.newLines(2).write(HtmlTag.HEADER2, "Means of seasonal factors");
        stream.open(new HtmlTable().withWidth(400));
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell(""));
        for (int i3 = 1; i3 <= ncols; ++i3) {
            stream.write(new HtmlTableCell("Span " + i3).withClass(Bootstrap4.FONT_ITALIC));
        }
        stream.close(HtmlTag.TABLEROW);
        TsPeriod dummy = new TsPeriod(freq);
        for (int i4 = 0; i4 < freq.intValue(); ++i4) {
            stream.open(HtmlTag.TABLEROW);
            stream.write(new HtmlTableCell(dummy.getPeriodString()));
            for (int j = 0; j < ncols; ++j) {
                if (siter[j] != null) {
                    TsDataBlock block = siter[j].nextElement();
                    double v = block.data.sum() / (double)block.data.getLength();
                    if (mul) {
                        stream.write(new HtmlTableCell(df4.format(v)));
                        continue;
                    }
                    stream.write(new HtmlTableCell(dg6.format(v)));
                    continue;
                }
                stream.write(new HtmlTableCell(""));
            }
            stream.close(HtmlTag.TABLEROW);
            dummy.move(1);
        }
        stream.close(HtmlTag.TABLE);
    }

    private void writeTimeSpans(HtmlStream stream) throws IOException {
    }

    private HtmlTableCell SeasonalityCell(StatisticalTest test) {
        DecimalFormat format = new DecimalFormat("0.0");
        String val = format.format(test.getValue());
        if (test.getPValue() > 0.05) {
            return new HtmlTableCell(val).withClass(Bootstrap4.TEXT_DANGER);
        }
        if (test.getPValue() > 0.01) {
            return new HtmlTableCell(val).withClass(Bootstrap4.TEXT_WARNING);
        }
        return new HtmlTableCell(val).withClass(Bootstrap4.TEXT_SUCCESS);
    }

    private HtmlTableCell MovingSeasonalityCell(StatisticalTest test) {
        DecimalFormat format = new DecimalFormat("0.0");
        String val = format.format(test.getValue());
        if (test.getPValue() < 0.05) {
            return new HtmlTableCell(val).withClass(Bootstrap4.TEXT_DANGER);
        }
        if (test.getPValue() < 0.2) {
            return new HtmlTableCell(val).withClass(Bootstrap4.TEXT_WARNING);
        }
        return new HtmlTableCell(val).withClass(Bootstrap4.TEXT_SUCCESS);
    }

    private HtmlTableCell IdentifiableCell(CombinedSeasonalityTest test) {
        switch (test.getSummary()) {
            case None: {
                return new HtmlTableCell("NO").withClass(Bootstrap4.TEXT_DANGER);
            }
            case ProbablyNone: {
                return new HtmlTableCell("???").withClass(Bootstrap4.TEXT_WARNING);
            }
            case Present: {
                return new HtmlTableCell("YES").withClass(Bootstrap4.TEXT_SUCCESS);
            }
        }
        return null;
    }
}

