/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.html.implementation;

import ec.satoolkit.diagnostics.StationaryVarianceDecomposition;
import ec.tss.html.AbstractHtmlElement;
import ec.tss.html.HtmlStream;
import ec.tss.html.HtmlTable;
import ec.tss.html.HtmlTableCell;
import ec.tss.html.HtmlTag;
import java.io.IOException;

public class HtmlStationaryVarianceDecomposition
extends AbstractHtmlElement {
    private final StationaryVarianceDecomposition vdecomp;
    private static final String TITLE = "Relative contribution of the components to the stationary portion of the variance in the original series, after the removal of the long term trend";

    public HtmlStationaryVarianceDecomposition(StationaryVarianceDecomposition vdecomp) {
        this.vdecomp = vdecomp;
    }

    @Override
    public void write(HtmlStream stream) throws IOException {
        stream.write(HtmlTag.HEADER2, TITLE);
        stream.newLine();
        stream.write(this.vdecomp.getTrendComputer().toString());
        stream.newLine();
        stream.open(new HtmlTable().withWidth(200));
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell("Cycle").withWidth(100));
        stream.write(new HtmlTableCell(df2.format(100.0 * this.vdecomp.getVarC())).withWidth(100));
        stream.close(HtmlTag.TABLEROW);
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell("Seasonal").withWidth(100));
        stream.write(new HtmlTableCell(df2.format(100.0 * this.vdecomp.getVarS())).withWidth(100));
        stream.close(HtmlTag.TABLEROW);
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell("Irregular").withWidth(100));
        stream.write(new HtmlTableCell(df2.format(100.0 * this.vdecomp.getVarI())).withWidth(100));
        stream.close(HtmlTag.TABLEROW);
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell("TD & Hol.").withWidth(100));
        stream.write(new HtmlTableCell(df2.format(100.0 * this.vdecomp.getVarTD())).withWidth(100));
        stream.close(HtmlTag.TABLEROW);
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell("Others").withWidth(100));
        stream.write(new HtmlTableCell(df2.format(100.0 * this.vdecomp.getVarP())).withWidth(100));
        stream.close(HtmlTag.TABLEROW);
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell("Total").withWidth(50));
        stream.write(new HtmlTableCell(df2.format(100.0 * this.vdecomp.getVarTotal())).withWidth(50));
        stream.close(HtmlTag.TABLEROW);
        stream.close(HtmlTag.TABLE);
        stream.newLine();
    }
}

