/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.html.implementation;

import ec.tss.html.AbstractHtmlElement;
import ec.tss.html.HtmlStream;
import ec.tss.html.HtmlTag;
import ec.tss.html.IHtmlElement;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import java.io.IOException;

public class HtmlTramo
extends AbstractHtmlElement
implements IHtmlElement {
    private PreprocessingModel model_;

    public HtmlTramo(PreprocessingModel model) {
        this.model_ = model;
    }

    @Override
    public void write(HtmlStream stream) throws IOException {
        this.writeLogLevel(stream);
    }

    private void writeLogLevel(HtmlStream stream) throws IOException {
        InformationSet pinfo = this.model_.info_;
        if (pinfo == null) {
            return;
        }
        InformationSet tinfo = pinfo.getSubSet("transformation");
        if (tinfo == null) {
            return;
        }
        Double level = (Double)tinfo.get("level", Double.class);
        Double log = (Double)tinfo.get("log", Double.class);
        if (level != null && log != null) {
            stream.write(HtmlTag.HEADER1, "Log/level transformation");
            stream.newLine();
            stream.write(HtmlTag.HEADER2, "Objective function for level: ").write(level.toString()).newLine();
            stream.write(HtmlTag.HEADER2, "Objective function for log: ").write(log.toString()).newLine();
            stream.write(HtmlTag.LINEBREAK);
        }
    }

    private void writeCalendar(HtmlStream stream) throws IOException {
        InformationSet pinfo = this.model_.info_;
        if (pinfo == null) {
            return;
        }
        InformationSet cinfo = pinfo.getSubSet("calendar");
        if (cinfo == null) {
            return;
        }
        stream.write(HtmlTag.HEADER1, "Trading days");
        stream.newLine();
        stream.write(HtmlTag.LINEBREAK);
    }

    private void writeEaster(HtmlStream stream) throws IOException {
        InformationSet pinfo = this.model_.info_;
        if (pinfo == null) {
            return;
        }
        InformationSet einfo = pinfo.getSubSet("easter");
        if (einfo == null) {
            return;
        }
        stream.write(HtmlTag.HEADER1, "Easter effect");
        stream.write(HtmlTag.LINEBREAK);
    }
}

