/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.html.implementation;

import ec.satoolkit.DecompositionMode;
import ec.satoolkit.GenericSaResults;
import ec.satoolkit.ISeriesDecomposition;
import ec.satoolkit.seats.SeatsResults;
import ec.tss.html.AbstractHtmlElement;
import ec.tss.html.HtmlStream;
import ec.tss.html.HtmlTable;
import ec.tss.html.HtmlTableCell;
import ec.tss.html.HtmlTag;
import ec.tss.html.IHtmlElement;
import ec.tstoolkit.algorithm.CompositeResults;
import ec.tstoolkit.modelling.ComponentInformation;
import ec.tstoolkit.modelling.ComponentType;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import ec.tstoolkit.timeseries.simplets.TsData;
import java.io.IOException;

public class HtmlTramoSeatsGrowthRates
extends AbstractHtmlElement
implements IHtmlElement {
    private static final String TITLE = "Rates of growth";
    private static final String COMMENT1 = "The rate-of-growth of series Z(t) over the period (t1,t2) is expressed in percent points as [ (Z(t2) / Z(t1)) -1] * 100";
    private static final String TITLE_ADD = "Variations";
    private static final String COMMENT1_ADD = "The changes of series Z(t) over the period (t1,t2) is defined by [ (Z(t2) - Z(t1))]";
    private static final String COMMENT2 = "All standard errors reported for the rates-of growth in the following tables are computed using linear approximation to the rates. When period-to-period changes are large, these standard errors should be interpreted as broad approximations, that will tend to UNDERESTIMATE the true values.";
    private static final String COMMENT3 = "The error variances are based on the estimation error of the stochastic Trend and Sa series, and the errors in the parameter estimates are not considered.";
    private final PreprocessingModel preprocessing_;
    private final SeatsResults decomposition_;
    private final ISeriesDecomposition finalDecomposition_;
    private final int np;
    private final boolean mul;

    public HtmlTramoSeatsGrowthRates(CompositeResults results) {
        this.preprocessing_ = GenericSaResults.getPreprocessingModel((CompositeResults)results);
        this.decomposition_ = (SeatsResults)GenericSaResults.getDecomposition((CompositeResults)results, SeatsResults.class);
        this.finalDecomposition_ = GenericSaResults.getFinalDecomposition((CompositeResults)results);
        this.np = this.finalDecomposition_.getSeries(ComponentType.Series, ComponentInformation.Value).getFrequency().intValue() * 2 + 1;
        this.mul = this.finalDecomposition_.getMode() != DecompositionMode.Additive;
    }

    @Override
    public void write(HtmlStream stream) throws IOException {
        this.writeHeader(stream);
        this.writePeriodToPeriod(stream);
    }

    private void writeHeader(HtmlStream stream) throws IOException {
        if (this.mul) {
            stream.write(HtmlTag.HEADER1, TITLE).newLine();
            stream.write(HtmlTag.HEADER4, COMMENT1).newLine();
            stream.write(HtmlTag.HEADER4, COMMENT2).newLine();
        } else {
            stream.write(HtmlTag.HEADER1, TITLE_ADD).newLine();
            stream.write(HtmlTag.HEADER4, COMMENT1_ADD).newLine();
        }
        stream.write(HtmlTag.HEADER4, COMMENT3).newLine();
    }

    private void writePeriodToPeriod(HtmlStream stream) throws IOException {
        int i;
        if (this.mul) {
            stream.write(HtmlTag.HEADER2, "Period to period growth rates").newLine();
        } else {
            stream.write(HtmlTag.HEADER2, "Period to period variations").newLine();
        }
        double[] re = new double[this.np];
        double[] te = new double[this.np];
        double ser = this.decomposition_.getModel().getSer();
        if (!this.decomposition_.getUcarimaModel().getComponent(1).isNull()) {
            TsData sa = this.finalDecomposition_.getSeries(ComponentType.SeasonallyAdjusted, ComponentInformation.Value);
            for (i = 0; i < re.length; ++i) {
                re[i] = ser * Math.sqrt(this.decomposition_.getWienerKolmogorovEstimators().variationPrecision(1, i, 1, false));
                te[i] = ser * Math.sqrt(this.decomposition_.getWienerKolmogorovEstimators().variationPrecision(1, i, 1, true));
            }
            stream.write(HtmlTag.HEADER2, "Seasonally adjusted series").newLine();
            this.writePeriodToPeriod(stream, sa, re, te);
        }
        if (!this.decomposition_.getUcarimaModel().getComponent(0).isNull()) {
            TsData t = this.finalDecomposition_.getSeries(ComponentType.Trend, ComponentInformation.Value);
            for (i = 0; i < re.length; ++i) {
                re[i] = ser * Math.sqrt(this.decomposition_.getWienerKolmogorovEstimators().variationPrecision(0, i, 1, false));
                te[i] = ser * Math.sqrt(this.decomposition_.getWienerKolmogorovEstimators().variationPrecision(0, i, 1, true));
            }
            stream.write(HtmlTag.HEADER2, "Trend").newLine();
            this.writePeriodToPeriod(stream, t, re, te);
        }
    }

    private void writePeriodToPeriod(HtmlStream stream, TsData s, double[] re, double[] te) throws IOException {
        TsData gs = this.mul ? s.pctVariation(1) : s.delta(1);
        stream.open(new HtmlTable().withWidth(400));
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell("Period").withWidth(100));
        if (this.mul) {
            stream.write(new HtmlTableCell("Growth").withWidth(100));
        } else {
            stream.write(new HtmlTableCell("Changes").withWidth(100));
        }
        stream.write(new HtmlTableCell("Std error (revisions)").withWidth(100));
        stream.write(new HtmlTableCell("Std error (total error)").withWidth(100));
        stream.close(HtmlTag.TABLEROW);
        int i = gs.getLength() - 1;
        int j = 0;
        while (i >= gs.getLength() - this.np) {
            stream.open(HtmlTag.TABLEROW);
            stream.write(new HtmlTableCell(gs.getDomain().get(i).toString()).withWidth(100));
            if (this.mul) {
                stream.write(new HtmlTableCell(pc2.format(gs.get(i) * 0.01)).withWidth(100));
                stream.write(new HtmlTableCell(pc2.format(Math.exp(re[j]) - 1.0)).withWidth(100));
                stream.write(new HtmlTableCell(pc2.format(Math.exp(te[j]) - 1.0)).withWidth(100));
            } else {
                stream.write(new HtmlTableCell(dg6.format(gs.get(i))).withWidth(100));
                stream.write(new HtmlTableCell(dg6.format(re[j])).withWidth(100));
                stream.write(new HtmlTableCell(dg6.format(te[j])).withWidth(100));
            }
            stream.close(HtmlTag.TABLEROW);
            --i;
            ++j;
        }
        stream.close(HtmlTag.TABLE);
    }
}

