/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.html.implementation;

import ec.satoolkit.GenericSaResults;
import ec.satoolkit.seats.SeatsResults;
import ec.tss.html.AbstractHtmlElement;
import ec.tss.html.HtmlStream;
import ec.tss.html.HtmlTag;
import ec.tss.html.IHtmlElement;
import ec.tss.html.implementation.HtmlDiagnosticSummary;
import ec.tss.html.implementation.HtmlProcessingInformation;
import ec.tss.html.implementation.HtmlRegArima;
import ec.tss.html.implementation.HtmlUcarima;
import ec.tss.sa.SaManager;
import ec.tstoolkit.algorithm.CompositeResults;
import ec.tstoolkit.algorithm.ProcessingInformation;
import ec.tstoolkit.arima.ArimaModel;
import ec.tstoolkit.arima.IArimaModel;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.ucarima.UcarimaModel;
import java.io.IOException;
import java.util.List;

public class HtmlTramoSeatsSummary
extends AbstractHtmlElement
implements IHtmlElement {
    private final List<ProcessingInformation> infos_;
    private final PreprocessingModel preprocessing_;
    private final SeatsResults decomposition_;
    private final String[] names_;
    private final ArimaModel[] list_;
    private final InformationSet diags_;
    private final String title_;

    public HtmlTramoSeatsSummary(String title, CompositeResults results, String[] names, ArimaModel[] list, InformationSet diags) {
        this.title_ = title;
        this.preprocessing_ = GenericSaResults.getPreprocessingModel((CompositeResults)results);
        this.decomposition_ = (SeatsResults)GenericSaResults.getDecomposition((CompositeResults)results, SeatsResults.class);
        this.names_ = names;
        this.list_ = list;
        this.diags_ = diags != null ? diags : SaManager.createDiagnostics(results);
        this.infos_ = results.getProcessingInformation();
    }

    @Override
    public void write(HtmlStream stream) throws IOException {
        this.writeTitle(stream);
        this.writeInformation(stream);
        if (this.preprocessing_ == null && this.decomposition_ == null) {
            return;
        }
        this.writePreprocessing(stream);
        this.writeDecomposition(stream);
        this.writeDiagnostics(stream);
    }

    private void writeTitle(HtmlStream stream) throws IOException {
        if (this.title_ != null) {
            stream.write(HtmlTag.HEADER1, this.title_).newLine();
        }
    }

    private void writeInformation(HtmlStream stream) throws IOException {
        stream.write(new HtmlProcessingInformation(this.infos_));
    }

    private void writePreprocessing(HtmlStream stream) throws IOException {
        if (this.preprocessing_ == null) {
            return;
        }
        stream.write(HtmlTag.HEADER2, "Pre-processing (Tramo)").newLine();
        stream.write(new HtmlRegArima(this.preprocessing_, true));
    }

    private void writeDecomposition(HtmlStream stream) throws IOException {
        if (this.decomposition_ == null) {
            return;
        }
        stream.write(HtmlTag.HEADER2, "Decomposition (Seats)").newLine();
        SarimaModel tmodel = this.preprocessing_.estimation.getArima();
        IArimaModel smodel = this.decomposition_.getModel().getArima();
        if (tmodel == null || smodel == null) {
            stream.write(HtmlTag.IMPORTANT_TEXT, "No decomposition").newLine();
        } else {
            boolean changed;
            boolean bl = changed = !ArimaModel.same((IArimaModel)tmodel, (IArimaModel)smodel, (double)1.0E-4);
            if (changed) {
                stream.write(HtmlTag.IMPORTANT_TEXT, "Model changed by Seats").newLine();
            }
            UcarimaModel ucm = this.decomposition_.getUcarimaModel();
            HtmlUcarima arima = new HtmlUcarima(ucm.getModel(), (IArimaModel[])this.list_, this.names_);
            arima.writeSummary(stream);
            stream.newLine();
        }
    }

    private void writeDiagnostics(HtmlStream stream) throws IOException {
        stream.write(HtmlTag.HEADER2, "Diagnostics").newLine();
        stream.write(new HtmlDiagnosticSummary(this.diags_));
    }
}

