/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.html.implementation;

import ec.tss.html.Bootstrap4;
import ec.tss.html.HtmlStream;
import ec.tss.html.HtmlTag;
import ec.tss.html.IHtmlElement;
import ec.tss.html.implementation.HtmlArima;
import ec.tstoolkit.arima.IArimaModel;
import java.io.IOException;

public class HtmlUcarima
implements IHtmlElement {
    private IArimaModel model_;
    private String[] names_;
    private IArimaModel[] cmps_;

    public HtmlUcarima(IArimaModel model, IArimaModel[] cmps, String[] names) {
        this.model_ = model;
        this.cmps_ = cmps;
        this.names_ = names;
    }

    @Override
    public void write(HtmlStream stream) throws IOException {
        this.writeDecomposition(stream);
    }

    public void writeDecomposition(HtmlStream stream) throws IOException {
        if (this.model_ != null) {
            stream.write(HtmlTag.IMPORTANT_TEXT, "Model", Bootstrap4.TEXT_INFO).newLine().write(new HtmlArima(this.model_)).newLine();
        }
        for (int i = 0; i < this.cmps_.length; ++i) {
            if (this.cmps_[i] == null || this.cmps_[i].isNull()) continue;
            String name = this.names_ != null ? this.names_[i] : "Cmp_" + Integer.toString(i + 1);
            stream.write(HtmlTag.IMPORTANT_TEXT, name, Bootstrap4.TEXT_INFO).newLine().write(new HtmlArima(this.cmps_[i]));
        }
    }

    public void writeSummary(HtmlStream stream) throws IOException {
        if (this.names_ != null) {
            for (int i = 0; i < this.names_.length; ++i) {
                HtmlArima arima = new HtmlArima(this.cmps_[i]);
                stream.write(this.names_[i]);
                arima.writeShortModel(stream);
                stream.newLine();
            }
        }
    }
}

