/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.html.implementation;

import ec.tss.html.AbstractHtmlElement;
import ec.tss.html.Bootstrap4;
import ec.tss.html.HtmlClass;
import ec.tss.html.HtmlStream;
import ec.tss.html.HtmlTable;
import ec.tss.html.HtmlTableCell;
import ec.tss.html.HtmlTableHeader;
import ec.tss.html.HtmlTag;
import ec.tss.html.IHtmlElement;
import ec.tstoolkit.arima.ArimaModel;
import ec.tstoolkit.arima.BartlettApproximation;
import ec.tstoolkit.arima.LinearModel;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.dstats.Normal;
import ec.tstoolkit.stats.AutoCorrelations;
import ec.tstoolkit.ucarima.WienerKolmogorovDiagnostics;
import java.io.IOException;

public class HtmlWienerKolmogorovDiagnostics
extends AbstractHtmlElement
implements IHtmlElement {
    private double m_badthreshold = 0.005;
    private double m_goodthresohold = 0.05;
    private double m_ccbadthreshold = 0.5;
    private double m_ccgoodthresohold = 0.25;
    private WienerKolmogorovDiagnostics diags_;
    private int freq_;
    private String[] desc_;
    private boolean[] signals_;

    private HtmlClass valueStyle(double val) {
        if (val < this.m_badthreshold) {
            return Bootstrap4.TEXT_DANGER;
        }
        if (val < this.m_goodthresohold) {
            return Bootstrap4.TEXT_WARNING;
        }
        return Bootstrap4.TEXT_SUCCESS;
    }

    private HtmlClass ccStyle(double val) {
        double aval = Math.abs(val);
        if (aval >= this.m_ccbadthreshold) {
            return Bootstrap4.TEXT_DANGER;
        }
        if (aval < this.m_ccgoodthresohold) {
            return Bootstrap4.TEXT_SUCCESS;
        }
        return Bootstrap4.TEXT_WARNING;
    }

    public HtmlWienerKolmogorovDiagnostics(WienerKolmogorovDiagnostics diags, String[] desc, boolean[] signals, int freq) {
        this.diags_ = diags;
        this.freq_ = freq;
        this.desc_ = desc;
        this.signals_ = signals;
    }

    @Override
    public void write(HtmlStream stream) throws IOException {
        this.writeHeader(stream);
        this.writeVariance(stream);
        this.writeAutoCorrelations(stream);
        this.writeCrossCorrelations(stream);
    }

    private void writeHeader(HtmlStream stream) throws IOException {
        stream.write(HtmlTag.HEADER1, "Distribution of component, theoretical estimator and empirical estimate (stationary transformation)").newLine();
    }

    private void writeVariance(HtmlStream stream) throws IOException {
        stream.write(HtmlTag.HEADER2, "Variance");
        stream.newLine();
        stream.open(new HtmlTable().withWidth(500));
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableHeader("").withWidth(100));
        stream.write(new HtmlTableHeader("Component").withWidth(100));
        stream.write(new HtmlTableHeader("Estimator").withWidth(100));
        stream.write(new HtmlTableHeader("Estimate").withWidth(100));
        stream.write(new HtmlTableHeader("P-Value").withWidth(100));
        stream.close(HtmlTag.TABLEROW);
        for (int i = 0; i < this.desc_.length; ++i) {
            ArimaModel stmodel = this.diags_.getStationaryComponentModel(i);
            if (stmodel == null) continue;
            stream.open(HtmlTag.TABLEROW);
            stream.write(new HtmlTableCell(this.desc_[i]));
            stream.write(new HtmlTableCell(df4.format(stmodel.getAutoCovarianceFunction().get(0))));
            stream.write(new HtmlTableCell(df4.format(this.diags_.getEstimatorVariance(i))));
            stream.write(new HtmlTableCell(df4.format(this.diags_.getEstimateVariance(i))));
            double pval = this.diags_.getPValue(i);
            stream.write(new HtmlTableCell(df4.format(pval)).withClass(this.valueStyle(pval)));
            stream.close(HtmlTag.TABLEROW);
        }
        stream.close(HtmlTag.TABLE);
        stream.newLine();
    }

    private void writeAutoCorrelations(HtmlStream stream) throws IOException {
        stream.write(HtmlTag.LINEBREAK);
        stream.write(HtmlTag.HEADER2, "Autocorrelation");
        Normal dist = new Normal();
        for (int i = 0; i < this.desc_.length; ++i) {
            ArimaModel cmodel = this.diags_.getStationaryComponentModel(i);
            LinearModel emodel = this.diags_.getStationaryEstimatorModel(i);
            if (cmodel == null || emodel == null) continue;
            stream.newLine();
            stream.write(HtmlTag.HEADER3, this.desc_[i]);
            stream.open(new HtmlTable().withWidth(500));
            stream.open(HtmlTag.TABLEROW);
            stream.write(new HtmlTableHeader("Lag").withWidth(100));
            stream.write(new HtmlTableHeader("Component").withWidth(100));
            stream.write(new HtmlTableHeader("Estimator").withWidth(100));
            stream.write(new HtmlTableHeader("Estimate").withWidth(100));
            stream.write(new HtmlTableHeader("P-Value").withWidth(100));
            stream.close(HtmlTag.TABLEROW);
            double tvar = cmodel.getAutoCovarianceFunction().get(0);
            double evar = emodel.getAutoCovarianceFunction().get(0);
            BartlettApproximation bartlett = new BartlettApproximation();
            bartlett.setX(emodel);
            IReadDataBlock data = this.diags_.getStationaryEstimate(i);
            AutoCorrelations ac = new AutoCorrelations(data);
            for (int l = 1; l <= this.freq_; ++l) {
                stream.open(HtmlTag.TABLEROW);
                double tcor = cmodel.getAutoCovarianceFunction().get(l) / tvar;
                double ecor = emodel.getAutoCovarianceFunction().get(l) / evar;
                double cor = ac.autoCorrelation(l);
                double sd = bartlett.SDAutoCorrelation(data.getLength(), l);
                double z = Math.abs(ecor - cor) / sd;
                double pval = 1.0 - dist.getProbabilityForInterval(-z, z);
                stream.write(new HtmlTableCell(Integer.toString(l)));
                stream.write(new HtmlTableCell(df4.format(tcor)));
                stream.write(new HtmlTableCell(df4.format(ecor)));
                stream.write(new HtmlTableCell(df4.format(cor)));
                stream.write(new HtmlTableCell(df4.format(pval)).withClass(this.valueStyle(pval)));
                stream.close(HtmlTag.TABLEROW);
            }
            stream.close(HtmlTag.TABLE);
        }
    }

    private void writeCrossCorrelations(HtmlStream stream) throws IOException {
        stream.write(HtmlTag.LINEBREAK);
        stream.write(HtmlTag.HEADER2, "Cross-correlation");
        stream.open(new HtmlTable().withWidth(500));
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableHeader("").withWidth(200));
        stream.write(new HtmlTableHeader("Estimator").withWidth(100));
        stream.write(new HtmlTableHeader("Estimate").withWidth(100));
        stream.write(new HtmlTableHeader("P-Value").withWidth(100));
        stream.close(HtmlTag.TABLEROW);
        for (int i = 1; i < this.desc_.length; ++i) {
            if (this.diags_.getStationaryEstimate(i) == null || !this.signals_[i]) continue;
            for (int j = 0; j < i; ++j) {
                if (this.diags_.getStationaryEstimate(j) == null || !this.signals_[j] || this.diags_.getStationaryComponentModel(i) == null || this.diags_.getStationaryComponentModel(j) == null) continue;
                stream.open(HtmlTag.TABLEROW);
                StringBuilder builder = new StringBuilder();
                builder.append(this.desc_[j]).append("/").append(this.desc_[i]);
                stream.write(new HtmlTableCell(builder.toString()));
                double cc = this.diags_.getEstimatorCrossCorrelation(i, j);
                stream.write(new HtmlTableCell(df4.format(cc)).withClass(this.ccStyle(cc)));
                stream.write(new HtmlTableCell(df4.format(this.diags_.getEstimateCrossCorrelation(i, j))));
                double pval = this.diags_.getPValue(i, j);
                stream.write(new HtmlTableCell(df4.format(pval)).withClass(this.valueStyle(pval)));
                stream.close(HtmlTag.TABLEROW);
            }
        }
        stream.close(HtmlTag.TABLE);
    }
}

