/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.html.implementation;

import ec.satoolkit.x11.Mstatistics;
import ec.satoolkit.x11.SeriesEvolution;
import ec.tss.html.AbstractHtmlElement;
import ec.tss.html.Bootstrap4;
import ec.tss.html.HtmlStream;
import ec.tss.html.HtmlTable;
import ec.tss.html.HtmlTableCell;
import ec.tss.html.HtmlTag;
import ec.tss.html.implementation.HtmlMovingSeasonalityRatios;
import ec.tstoolkit.timeseries.simplets.TsData;
import java.io.IOException;

public class HtmlX11Diagnostics
extends AbstractHtmlElement {
    Mstatistics stats_;
    private static final String F2A_TITLE_MUL = "Average percent change without regard to sign over the indicated span";
    private static final String F2B_TITLE_MUL = "Relative contributions to the variance of the percent change in the components of the original series";
    private static final String F2C_TITLE_MUL = "Average percent change with regard to sign and standard deviation over indicated span";
    private static final String F2A_TITLE_ADD = "Average differences without regard to sign over the indicated span";
    private static final String F2B_TITLE_ADD = "Relative contributions to the variance of the differences in the components of the original series";
    private static final String F2C_TITLE_ADD = "Average differences with regard to sign and standard deviation over indicated span";
    private static final String F2D_TITLE = "Average duration of run";
    private static final String F2E_TITLE = "I/C Ratio for indicated span";
    private static final String F2E_TITLE2 = "I/C Ratio: ";
    private static final String F2F_TITLE = "Relative contribution of the components to the stationary portion of the variance in the original series";
    private static final String F2G_TITLE = "Autocorrelation of the irregular";
    private static final String F2H_TITLE = "Heteroskedasticity (Cochran test on equal variances within each period)";
    private static final String[] F2A_HEADERS = new String[]{"Span", "O", "CI", "I", "C", "S", "P", "TD&H", "Mod.O", "Mod.CI", "Mod.I"};
    private static final String[] F2B_HEADERS = new String[]{"Span", "I", "C", "S", "P", "TD&H", "Total", "Ratio"};
    private static final String[] F2C_HEADERS = new String[]{"O", "I", "C", "S", "CI"};
    private static final String[] F2H_HEADERS = new String[]{"Test statistic", "Critical value (5% level)", "Decision"};

    public HtmlX11Diagnostics(Mstatistics mstats) {
        this.stats_ = mstats;
    }

    @Override
    public void write(HtmlStream stream) throws IOException {
        this.writeF2A(stream);
        this.writeF2B(stream);
        this.writeF2C(stream);
        this.writeF2D(stream);
        this.writeF2E(stream);
        this.writeF2F(stream);
        this.writeF2G(stream);
        this.writeF2H(stream);
        this.writeF2I(stream);
    }

    private void writeF2A(HtmlStream stream) throws IOException {
        stream.write(HtmlTag.HEADER2, this.stats_.getMode().isMultiplicative() ? F2A_TITLE_MUL : F2A_TITLE_ADD);
        double[][] Q = new double[][]{this.stats_.getOcChanges(), this.stats_.getCIcChanges(), this.stats_.getIcChanges(), this.stats_.getCcChanges(), this.stats_.getScChanges(), this.stats_.getPChanges(), this.stats_.getTDChanges(), this.stats_.getOmodChanges(), this.stats_.getCImodChanges(), this.stats_.getImodChanges()};
        int len = Q[0].length;
        stream.open(new HtmlTable().withWidth(50 * F2A_HEADERS.length));
        stream.open(HtmlTag.TABLEROW);
        for (int j = 0; j < F2A_HEADERS.length; ++j) {
            stream.write(new HtmlTableCell(F2A_HEADERS[j]).withWidth(50));
        }
        stream.close(HtmlTag.TABLEROW);
        for (int i = 1; i <= len; ++i) {
            stream.open(HtmlTag.TABLEROW);
            stream.write(new HtmlTableCell(Integer.toString(i)).withWidth(50));
            for (int j = 0; j < Q.length; ++j) {
                if (Q[j] != null) {
                    stream.write(new HtmlTableCell(df2.format(Q[j][i - 1])).withWidth(50));
                    continue;
                }
                stream.write(new HtmlTableCell(".").withWidth(50));
            }
            stream.close(HtmlTag.TABLEROW);
        }
        stream.close(HtmlTag.TABLE);
        stream.newLines(2);
    }

    private void writeF2B(HtmlStream stream) throws IOException {
        stream.write(HtmlTag.HEADER2, this.stats_.getMode().isMultiplicative() ? F2B_TITLE_MUL : F2B_TITLE_ADD);
        double[][] Q = new double[][]{this.stats_.getImodChanges(), this.stats_.getCcChanges(), this.stats_.getScChanges(), this.stats_.getPChanges(), this.stats_.getTDChanges()};
        double[] O = this.stats_.getOmodChanges();
        int len = Q[0].length;
        stream.open(new HtmlTable().withWidth(50 * F2B_HEADERS.length));
        stream.open(HtmlTag.TABLEROW);
        for (int j = 0; j < F2B_HEADERS.length; ++j) {
            stream.write(new HtmlTableCell(F2B_HEADERS[j]).withWidth(50));
        }
        stream.close(HtmlTag.TABLEROW);
        for (int i = 1; i <= len; ++i) {
            double s;
            int j;
            stream.open(HtmlTag.TABLEROW);
            stream.write(new HtmlTableCell(Integer.toString(i)).withWidth(50));
            double tot = 0.0;
            for (j = 0; j < Q.length; ++j) {
                if (Q[j] == null) continue;
                s = Q[j][i - 1];
                s *= s;
                tot += s;
            }
            for (j = 0; j < Q.length; ++j) {
                if (Q[j] != null) {
                    s = Q[j][i - 1];
                    stream.write(new HtmlTableCell(df2.format(100.0 * s * s / tot)).withWidth(50));
                    continue;
                }
                stream.write(new HtmlTableCell(".").withWidth(50));
            }
            stream.write(new HtmlTableCell(df2.format(100L)).withWidth(50));
            stream.write(new HtmlTableCell(df2.format(100.0 * tot / (O[i - 1] * O[i - 1]))).withWidth(50));
            stream.close(HtmlTag.TABLEROW);
        }
        stream.close(HtmlTag.TABLE);
        stream.newLines(2);
    }

    private void writeF2C(HtmlStream stream) throws IOException {
        int j;
        stream.write(HtmlTag.HEADER2, this.stats_.getMode().isMultiplicative() ? F2C_TITLE_MUL : F2C_TITLE_ADD);
        stream.open(new HtmlTable().withWidth(50 + 100 * F2C_HEADERS.length));
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell("").withWidth(50));
        for (j = 0; j < F2C_HEADERS.length; ++j) {
            stream.write(new HtmlTableCell("").withWidth(50));
            stream.write(new HtmlTableCell(F2C_HEADERS[j]).withWidth(50).withClass(Bootstrap4.TEXT_LEFT));
        }
        stream.close(HtmlTag.TABLEROW);
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell("Span").withWidth(50));
        for (j = 0; j < F2C_HEADERS.length; ++j) {
            stream.write(new HtmlTableCell("Avg").withWidth(50));
            stream.write(new HtmlTableCell("S.D.").withWidth(50));
        }
        stream.close(HtmlTag.TABLEROW);
        boolean mul = this.stats_.getMode().isMultiplicative();
        double[][] QO = SeriesEvolution.calcVariations((TsData)this.stats_.getOc(), null, (boolean)mul, (boolean[])this.stats_.validObservations());
        double[][] QI = SeriesEvolution.calcVariations((TsData)this.stats_.getIc(), null, (boolean)mul, (boolean[])this.stats_.validObservations());
        double[][] QC = SeriesEvolution.calcVariations((TsData)this.stats_.getCc(), null, (boolean)mul, (boolean[])this.stats_.validObservations());
        double[][] QS = SeriesEvolution.calcVariations((TsData)this.stats_.getSc(), null, (boolean)mul, (boolean[])this.stats_.validObservations());
        double[][] QCI = SeriesEvolution.calcVariations((TsData)this.stats_.getCIc(), null, (boolean)mul, (boolean[])this.stats_.validObservations());
        int len = QO[0].length;
        for (int i = 1; i <= len; ++i) {
            stream.open(HtmlTag.TABLEROW);
            stream.write(new HtmlTableCell(Integer.toString(i)).withWidth(50));
            stream.write(new HtmlTableCell(df2.format(QO[0][i - 1])).withWidth(50));
            stream.write(new HtmlTableCell(df2.format(QO[1][i - 1])).withWidth(50));
            stream.write(new HtmlTableCell(df2.format(QI[0][i - 1])).withWidth(50));
            stream.write(new HtmlTableCell(df2.format(QI[1][i - 1])).withWidth(50));
            stream.write(new HtmlTableCell(df2.format(QC[0][i - 1])).withWidth(50));
            stream.write(new HtmlTableCell(df2.format(QC[1][i - 1])).withWidth(50));
            stream.write(new HtmlTableCell(df2.format(QS[0][i - 1])).withWidth(50));
            stream.write(new HtmlTableCell(df2.format(QS[1][i - 1])).withWidth(50));
            stream.write(new HtmlTableCell(df2.format(QCI[0][i - 1])).withWidth(50));
            stream.write(new HtmlTableCell(df2.format(QCI[1][i - 1])).withWidth(50));
            stream.close(HtmlTag.TABLEROW);
        }
        stream.close(HtmlTag.TABLE);
        stream.newLines(2);
    }

    private void writeF2D(HtmlStream stream) throws IOException {
        stream.write(HtmlTag.HEADER2, F2D_TITLE);
        stream.open(new HtmlTable().withWidth(100));
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell("CI").withWidth(50));
        stream.write(new HtmlTableCell(df2.format(this.stats_.getAdrOfCI())).withWidth(50));
        stream.close(HtmlTag.TABLEROW);
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell("I").withWidth(50));
        stream.write(new HtmlTableCell(df2.format(this.stats_.getAdrOfI())).withWidth(50));
        stream.close(HtmlTag.TABLEROW);
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell("C").withWidth(50));
        stream.write(new HtmlTableCell(df2.format(this.stats_.getAdrOfC())).withWidth(50));
        stream.close(HtmlTag.TABLEROW);
        stream.close(HtmlTag.TABLE);
        stream.newLines(2);
    }

    private void writeF2E(HtmlStream stream) throws IOException {
        stream.write(HtmlTag.HEADER2, F2E_TITLE);
        double[] I = this.stats_.getIcChanges();
        double[] C = this.stats_.getCcChanges();
        boolean lt1 = false;
        stream.open(new HtmlTable().withWidth(100));
        for (int i = 1; i <= I.length; ++i) {
            double r = I[i - 1] / C[i - 1];
            boolean bold = !lt1 && r < 1.0 || r < 1.0 && i == 1;
            stream.open(HtmlTag.TABLEROW);
            if (bold) {
                stream.write(new HtmlTableCell(Integer.toString(i)).withWidth(50).withClass(Bootstrap4.FONT_WEIGHT_BOLD));
                stream.write(new HtmlTableCell(df3.format(r)).withWidth(50).withClass(Bootstrap4.FONT_WEIGHT_BOLD));
                lt1 = true;
            } else {
                stream.write(new HtmlTableCell(Integer.toString(i)).withWidth(50));
                stream.write(new HtmlTableCell(df3.format(r)).withWidth(50));
            }
            stream.close(HtmlTag.TABLEROW);
        }
        stream.close(HtmlTag.TABLE);
        stream.newLine();
        stream.write(HtmlTag.IMPORTANT_TEXT, F2E_TITLE2).write(df3.format(this.stats_.getIcr()));
        stream.newLines(2);
    }

    private void writeF2F(HtmlStream stream) throws IOException {
        stream.write(HtmlTag.HEADER2, F2F_TITLE);
        stream.open(new HtmlTable().withWidth(100));
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell("I").withWidth(50));
        stream.write(new HtmlTableCell(df2.format(100.0 * this.stats_.getVarI())).withWidth(50));
        stream.close(HtmlTag.TABLEROW);
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell("C").withWidth(50));
        stream.write(new HtmlTableCell(df2.format(100.0 * this.stats_.getVarC())).withWidth(50));
        stream.close(HtmlTag.TABLEROW);
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell("S").withWidth(50));
        stream.write(new HtmlTableCell(df2.format(100.0 * this.stats_.getVarS())).withWidth(50));
        stream.close(HtmlTag.TABLEROW);
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell("P").withWidth(50));
        stream.write(new HtmlTableCell(df2.format(100.0 * this.stats_.getVarP())).withWidth(50));
        stream.close(HtmlTag.TABLEROW);
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell("TD&H").withWidth(50));
        stream.write(new HtmlTableCell(df2.format(100.0 * this.stats_.getVarTD())).withWidth(50));
        stream.close(HtmlTag.TABLEROW);
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell("Total").withWidth(50));
        stream.write(new HtmlTableCell(df2.format(100.0 * this.stats_.getVarTotal())).withWidth(50));
        stream.close(HtmlTag.TABLEROW);
        stream.close(HtmlTag.TABLE);
        stream.newLines(2);
    }

    private void writeF2G(HtmlStream stream) throws IOException {
        stream.write(HtmlTag.HEADER2, F2G_TITLE);
        double[] c = this.stats_.getAutoCorrelationsOfIrregular();
        stream.open(new HtmlTable().withWidth(100));
        for (int i = 1; i <= c.length; ++i) {
            stream.open(HtmlTag.TABLEROW);
            stream.write(new HtmlTableCell(Integer.toString(i)).withWidth(50));
            stream.write(new HtmlTableCell(df3.format(c[i - 1])).withWidth(50));
            stream.close(HtmlTag.TABLEROW);
        }
        stream.close(HtmlTag.TABLE);
        stream.newLines(2);
    }

    private void writeF2H(HtmlStream stream) throws IOException {
        stream.write(HtmlTag.HEADER2, F2H_TITLE);
        boolean testResultCochran = this.stats_.getCochranResult();
        stream.open(new HtmlTable().withWidth(30 + 120 * F2H_HEADERS.length));
        stream.open(HtmlTag.TABLEROW);
        for (int j = 0; j < F2H_HEADERS.length; ++j) {
            stream.write(new HtmlTableCell(F2H_HEADERS[j]).withWidth(120));
        }
        stream.close(HtmlTag.TABLEROW);
        stream.open(HtmlTag.TABLEROW);
        stream.write(new HtmlTableCell(Double.toString((double)Math.round(this.stats_.getTestValue() * 10000.0) / 10000.0)).withWidth(120));
        stream.write(new HtmlTableCell(Double.toString((double)Math.round(this.stats_.getCriticalValue() * 10000.0) / 10000.0)).withWidth(120));
        if (testResultCochran) {
            stream.write(new HtmlTableCell("Null hypothesis is not rejected.").withWidth(150));
        } else {
            stream.write(new HtmlTableCell("Null hypothesis is rejected.").withWidth(150));
        }
        stream.close(HtmlTag.TABLEROW);
        stream.close(HtmlTag.TABLE);
        stream.newLines(2);
    }

    private void writeF2I(HtmlStream stream) throws IOException {
        if (this.stats_.getRms() != null) {
            HtmlMovingSeasonalityRatios hmsr = new HtmlMovingSeasonalityRatios(this.stats_.getRms());
            hmsr.write(stream);
        }
    }
}

