/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.html.implementation;

import ec.tss.html.AbstractHtmlElement;
import ec.tss.html.HtmlStream;
import ec.tss.html.HtmlTag;
import ec.tss.html.implementation.HtmlLikelihood;
import ec.tstoolkit.arima.estimation.LikelihoodStatistics;
import ec.tstoolkit.information.Information;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import java.io.IOException;
import java.util.List;

public class HtmlX13Preprocessing
extends AbstractHtmlElement {
    private PreprocessingModel model_;

    public HtmlX13Preprocessing(PreprocessingModel model) {
        this.model_ = model;
    }

    @Override
    public void write(HtmlStream stream) throws IOException {
        this.writeLogLevel(stream);
        this.writeCalendar(stream);
        this.writeEaster(stream);
    }

    private void writeLogLevel(HtmlStream stream) throws IOException {
        InformationSet pinfo = this.model_.info_;
        if (pinfo == null) {
            return;
        }
        InformationSet tinfo = pinfo.getSubSet("transformation");
        if (tinfo == null) {
            return;
        }
        LikelihoodStatistics levelStats = (LikelihoodStatistics)tinfo.get("stats_level", LikelihoodStatistics.class);
        LikelihoodStatistics logStats = (LikelihoodStatistics)tinfo.get("stats_log", LikelihoodStatistics.class);
        if (levelStats != null && logStats != null) {
            stream.write(HtmlTag.HEADER1, "Log/level transformation");
            stream.newLine();
            stream.write(HtmlTag.HEADER2, "Likelihood statistics for model fit to untransformed series.");
            stream.write(new HtmlLikelihood(levelStats));
            stream.write(HtmlTag.HEADER2, "Likelihood statistics for model fit to log transformed series.");
            stream.write(new HtmlLikelihood(logStats));
            stream.write(HtmlTag.LINEBREAK);
        }
    }

    private void writeCalendar(HtmlStream stream) throws IOException {
        InformationSet pinfo = this.model_.info_;
        if (pinfo == null) {
            return;
        }
        InformationSet cinfo = pinfo.getSubSet("calendar");
        if (cinfo == null) {
            return;
        }
        LikelihoodStatistics tdStats = (LikelihoodStatistics)cinfo.get("stats_td", LikelihoodStatistics.class);
        LikelihoodStatistics ntdStats = (LikelihoodStatistics)cinfo.get("stats_ntd", LikelihoodStatistics.class);
        if (tdStats != null && ntdStats != null) {
            stream.write(HtmlTag.HEADER1, "Trading days");
            stream.newLine();
            stream.write(HtmlTag.HEADER2, "Likelihood statistics for model fit without td.");
            stream.write(new HtmlLikelihood(ntdStats));
            stream.write(HtmlTag.HEADER2, "Likelihood statistics for model fit with td.");
            stream.write(new HtmlLikelihood(tdStats));
            stream.write(HtmlTag.LINEBREAK);
        }
    }

    private void writeEaster(HtmlStream stream) throws IOException {
        InformationSet pinfo = this.model_.info_;
        if (pinfo == null) {
            return;
        }
        InformationSet einfo = pinfo.getSubSet("easter");
        if (einfo == null) {
            return;
        }
        List stats = einfo.select(LikelihoodStatistics.class);
        if (stats == null || stats.isEmpty()) {
            return;
        }
        stream.write(HtmlTag.HEADER1, "Easter effect");
        for (Information linfo : stats) {
            stream.newLine();
            stream.write(HtmlTag.HEADER2, "Likelihood statistics for model fit with " + linfo.name.substring(6));
            stream.write(new HtmlLikelihood((LikelihoodStatistics)linfo.value));
        }
        stream.write(HtmlTag.LINEBREAK);
    }
}

