/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.html.implementation;

import ec.satoolkit.GenericSaResults;
import ec.satoolkit.x11.X11Results;
import ec.tss.html.AbstractHtmlElement;
import ec.tss.html.HtmlStream;
import ec.tss.html.HtmlTag;
import ec.tss.html.IHtmlElement;
import ec.tss.html.implementation.HtmlDiagnosticSummary;
import ec.tss.html.implementation.HtmlProcessingInformation;
import ec.tss.html.implementation.HtmlRegArima;
import ec.tss.sa.SaManager;
import ec.tstoolkit.algorithm.CompositeResults;
import ec.tstoolkit.algorithm.ProcessingInformation;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import java.io.IOException;
import java.util.List;

public class HtmlX13Summary
extends AbstractHtmlElement
implements IHtmlElement {
    private final List<ProcessingInformation> infos_;
    private final PreprocessingModel preprocessing_;
    private final X11Results decomposition_;
    private final InformationSet diags_;
    private final String title_;

    public HtmlX13Summary(String title, CompositeResults results, InformationSet diags) {
        this.title_ = title;
        this.infos_ = results.getProcessingInformation();
        this.preprocessing_ = GenericSaResults.getPreprocessingModel((CompositeResults)results);
        this.decomposition_ = (X11Results)GenericSaResults.getDecomposition((CompositeResults)results, X11Results.class);
        this.diags_ = diags != null ? diags : SaManager.createDiagnostics(results);
    }

    @Override
    public void write(HtmlStream stream) throws IOException {
        this.writeTitle(stream);
        this.writeInformation(stream);
        if (this.preprocessing_ == null && this.decomposition_ == null) {
            return;
        }
        this.writePreprocessing(stream);
        this.writeDiagnostics(stream);
    }

    private void writeTitle(HtmlStream stream) throws IOException {
        if (this.title_ != null) {
            stream.write(HtmlTag.HEADER1, this.title_).newLine();
        }
    }

    private void writeInformation(HtmlStream stream) throws IOException {
        stream.write(new HtmlProcessingInformation(this.infos_));
    }

    private void writePreprocessing(HtmlStream stream) throws IOException {
        if (this.preprocessing_ == null) {
            stream.write(HtmlTag.HEADER2, "No pre-processing").newLine();
        } else {
            stream.write(HtmlTag.HEADER2, "Pre-processing (RegArima)").newLine();
            stream.write(new HtmlRegArima(this.preprocessing_, true));
        }
    }

    private void writeDecomposition(HtmlStream stream) throws IOException {
    }

    private void writeDiagnostics(HtmlStream stream) throws IOException {
        stream.write(HtmlTag.HEADER2, "Diagnostics").newLine();
        stream.write(new HtmlDiagnosticSummary(this.diags_));
    }
}

